wandb_project_name=permutation

task=max_min
encoding_method=standard
epochs=2

# max_steps_per_epoch=1000
batch_size=128

count=4
# for task in sum prod gcd remainder 
# do
# Dataset parameter settings
nvars=0
field=ZZ
# max_coefficient=-10
max_coefficient=100
max_degree=1
num_digits=20
num_max_digits=100
max_seq_len=128

# Specify data load path
exp_name=max_min_gpt2
data_class=large
data_name=data # data, data-inv, etc.
data_path=/mnt/nfs/data/${data_class}/${task}/n=${num_digits}_V=${num_max_digits}/${data_name}

# Specify save destination
run_name=${exp_name}_${data_class}_${task}_digits=${num_digits}_V=${num_max_digits}
run_name_sub=${exp_name}_digits=${num_digits}_V=${num_max_digits}_bs=${batch_size}
save_path=/mnt/nfs/results/${data_class}/${task}/${run_name_sub}

mkdir -p $save_path
CUDA_VISIBLE_DEVICES=$count python3 src/main.py  --save_path $save_path \
                                            --data_path $data_path \
                                            --task $task \
                                            --epochs $epochs \
                                            --num_batch $batch_size \
                                            --nhead 1 \
                                            --num_encoder_layers 1 \
                                            --exp_name $wandb_project_name \
                                            --exp_id $run_name \
                                            --num_variables $nvars \
                                            --field $field \
                                            --max_coefficient $max_coefficient \
                                            --max_degree $max_degree \
                                            --encoding_method $encoding_method \
                                            --model gpt2 \
                                            --max_sequence_length $max_seq_len > ${save_path}/run.log &

count=$((count+1))

data_name=data-inv # data, data-inv, etc.
data_path=/mnt/nfs/data/${data_class}/${task}/n=${num_digits}_V=${num_max_digits}/${data_name}

# Specify save destination
run_name=${exp_name}_${data_class}_${task}_digits=${num_digits}_V=${num_max_digits}_inverse
run_name_sub=${exp_name}_digits=${num_digits}_V=${num_max_digits}_bs=${batch_size}_inverse
save_path=/mnt/nfs/results/${data_class}/${task}/${run_name_sub}


mkdir -p $save_path
CUDA_VISIBLE_DEVICES=$count python3 src/main.py  --save_path $save_path \
                                            --data_path $data_path \
                                            --task $task \
                                            --epochs $epochs \
                                            --num_batch $batch_size \
                                            --nhead 1 \
                                            --num_encoder_layers 1 \
                                            --exp_name $wandb_project_name \
                                            --exp_id $run_name \
                                            --num_variables $nvars \
                                            --field $field \
                                            --max_coefficient $max_coefficient \
                                            --max_degree $max_degree \
                                            --encoding_method $encoding_method \
                                            --model gpt2 \
                                            --max_sequence_length $max_seq_len > ${save_path}/run.log &
                                            
