wandb_project_name=permutation

task=rev_multi
encoding_method=standard
epochs=40

# max_steps_per_epoch=1000
batch_size=128

count=6
# for task in sum prod gcd remainder
# do
# Dataset parameter settings
nvars=0
field=ZZ
max_coefficient=10
max_coefficient=10
max_degree=1
num_bits=200
max_seq_len=256

# Specify data load path
exp_name=rev_multi_standard
data_class=small
data_name=data # data, data-inv, etc.
data_path=/mnt/nfs/data/${data_class}/${task}/rev_multi_digits=${num_bits}/${data_name}

# Specify save destination
run_name=${exp_name}_${data_class}_${task}_digits=${num_bits}_bs=${batch_size}
run_name_sub=${exp_name}_digits=${num_bits}_bs=${batch_size}
save_path=/mnt/nfs/results/${data_class}/${task}/${run_name_sub}

mkdir -p $save_path
CUDA_VISIBLE_DEVICES=$count python3 src/main.py  --save_path $save_path \
                                            --data_path $data_path \
                                            --task $task \
                                            --epochs $epochs \
                                            --num_batch $batch_size \
                                            --exp_name $wandb_project_name \
                                            --exp_id $run_name \
                                            --num_variables $nvars \
                                            --field $field \
                                            --max_coefficient $max_coefficient \
                                            --max_degree $max_degree \
                                            --encoding_method $encoding_method \
                                            --max_sequence_length $max_seq_len > ${save_path}/run.log &

count=$((count+1))

data_name=data-inv # data, data-inv, etc.
data_path=/mnt/nfs/data/${data_class}/${task}/rev_multi_digits=${num_bits}/${data_name}

# Specify save destination
run_name=${exp_name}_${data_class}_${task}_digits=${num_bits}_bs=${batch_size}_inverse
run_name_sub=${exp_name}_digits=${num_bits}_bs=${batch_size}_inverse
save_path=/mnt/nfs/results/${data_class}/${task}/${run_name_sub}


mkdir -p $save_path
CUDA_VISIBLE_DEVICES=$count python3 src/main.py  --save_path $save_path \
                                            --data_path $data_path \
                                            --task $task \
                                            --epochs $epochs \
                                            --num_batch $batch_size \
                                            --exp_name $wandb_project_name \
                                            --exp_id $run_name \
                                            --num_variables $nvars \
                                            --field $field \
                                            --max_coefficient $max_coefficient \
                                            --max_degree $max_degree \
                                            --encoding_method $encoding_method \
                                            --max_sequence_length $max_seq_len > ${save_path}/run.log &
                                            
