     ](}messages](}(rolesystemcontentX	  You are tasked with analyzing two examples, each contains a user query and its corresponding workflow (defined to be the same as the output workflow) or tool calls with execution results. Based on these examples, your objective is to generalize a meta workflow that can solve similar problems using a combination of static executable tool calls and dynamic LLM agent configurations. The meta workflow you generalize should not only summarize the given samples, but it should be as general as possible so that it can solve similar problems by reusing static code and utilizing dynamic agents.
The meta workflow runs sequentially. When encountering a static tool call, it is executed directly. When encountering a dynamic agent's JSON configuration file, an LLM agent is triggered to generate tool calls to solve the specific task. The tool calls generated by the LLM agent and the static tool calls will operate within the same compilation environment, allowing them to output and reference variables to interact with each other.

# Key Requirements:

## Static tool calls:

Static tool calls represent reusable logic that can be executed without model inference. These calls must:
- Be complete and executable.
- Use constants or variables defined in earlier steps.
- Avoid variable placeholders in the `"action"` field (e.g., `"action": "email.send_email"` is valid, but `"action": "${some_variable}"` is not).

Example:
```json
{
  "type": "static",
  "action": "calendar.search_events",
  "params": {
    "time_min": "${formatted_date} 09:00:00",
    "time_max": "${formatted_date} 18:00:00"
  },
  "output": "event_data"
}



## Dynamic Configurations:

Dynamic steps delegate logic to an LLM, which should be used for query-specific reasoning. These should:
- The `instruction` that clearly defines the query-specific logic.
- The `outputs` defines a list of output variables for the dynamic agent. If there are no output variables, it is left empty.


Example:

```json
{
  "type": "dynamic",
  "instruction": "Extract the name and participant_email of the earliest event from the `event_data` list",
  "outputs": ["event_name", "participant_email"]
}
```
## Meta Query:

The meta query should describe the type of problem that the meta workflow can solve, without including all specific details from the input queries. It should use placeholders (e.g., [criteria]) to generalize the problem.

## Meta Workflow Structure:

The meta workflow should alternate between static tool calls and dynamic agent's configurations.
u}(huserhX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Cancel my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you cancel my first meeting on December 1
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-01 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}, {\"event_id\": \"00000237\", \"event_name\": \"project checkpoint\", \"participant_email\": \"nia.johnson@atlas.com\", \"event_start\": \"2023-12-01 12:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000093\", \"event_name\": \"retrospective meeting\", \"participant_email\": \"raj.patel@atlas.com\", \"event_start\": \"2023-12-01 13:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000261\", \"event_name\": \"performance evaluation\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-01 14:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(h	assistanthX  **Meta Query**:
Cancel my first meeting on {natural_language_event_date}.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract date from user query and format to YYYY-MM-DD",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the earliest event from the `event_data` list",
    "outputs": [
      "event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id}"
    },
    "output": "delete_result"
  }
]
```ues}h](}(hhhhu}(hh
hX5  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check the percent growth of engaged users since Wednesday? If it grew by more than total visits make a task called 'Improve total visits' on the front-end backlog for olga that's due next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"olga@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of engaged users since Saturday and if was more than total visits make a backlog task called 'Improve total visits' for olga on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check the percent growth of engaged users since [start_day] and if it was more than total visits, make a backlog task called 'Improve total visits' for [user] on the [board] board with a deadline of next Friday.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start day, user email, and board name from the user query and calculate the start date and next Friday's date in YYYY-MM-DD format.",
    "outputs": [
      "time_min",
      "time_max",
      "user_email",
      "board_name"
    ]
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "engaged_users_data"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "total_visits_data"
  },
  {
    "type": "dynamic",
    "instruction": "Calculate the percent growth of engaged users and total visits. If the percent growth of engaged users is more than the total visits, create a task using the `project_management.create_task` function. The task should have the name 'Improve total visits', be assigned to ${user_email}, be in the backlog list, and have a due date of next Friday (${time_max}).",
    "outputs": [
      "task_creation_result"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Can you plot the distribution of both total visits and average session duration between October 11 and November 19??
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-11\", \"time_max\": \"2023-11-19\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-11_2023-11-19_total_visits_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-11\", \"time_max\": \"2023-11-19\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-11_2023-11-19_session_duration_seconds_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
Can you plot the distribution of both total visits and average session duration between October 12 and November 6??
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-06\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-12_2023-11-06_total_visits_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-06\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-12_2023-11-06_session_duration_seconds_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXw  **Meta Query**:
Can you plot the distribution of both total visits and average session duration between [start_date] and [end_date]?

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start_date and end_date from the user query",
    "outputs": [
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "value_to_plot": "total_visits",
      "plot_type": "histogram"
    },
    "output": "total_visits_plot_path"
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "value_to_plot": "session_duration_seconds",
      "plot_type": "histogram"
    },
    "output": "session_duration_plot_path"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Move all of kofi's tasks that are in progress to in review
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of kofi's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list` using the `project_management.update_task` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX8  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you cancel my first meeting on December 1
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-01 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}, {\"event_id\": \"00000237\", \"event_name\": \"project checkpoint\", \"participant_email\": \"nia.johnson@atlas.com\", \"event_start\": \"2023-12-01 12:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000093\", \"event_name\": \"retrospective meeting\", \"participant_email\": \"raj.patel@atlas.com\", \"event_start\": \"2023-12-01 13:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000261\", \"event_name\": \"performance evaluation\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-01 14:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you cancel my first meeting on December 8
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-08 00:00:00\", \"time_max\": \"2023-12-08 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000236\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-08 10:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000213\", \"event_name\": \"IT Systems Update Briefing\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-08 14:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000185\", \"event_name\": \"strategic planning meeting\", \"participant_email\": \"chenwei.zhang@atlas.com\", \"event_start\": \"2023-12-08 15:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000236\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel my first meeting on {natural_language_event_date}.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract date from user query and format to YYYY-MM-DD",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the earliest event from the `event_data` list",
    "outputs": [
      "event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id}"
    },
    "output": "delete_result"
  }
]
```ues}h](}(hhhhu}(hh
hX(  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Can you make a line plot of the most popular traffic source since November 24?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"visits_direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-24_2023-11-29_visits_direct_line.png\""
  }
]
```

**Sample2**:
**Query**:
Make a line plot of the most popular traffic source since November 16
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 3, \"2023-11-17\": 4, \"2023-11-18\": 3, \"2023-11-19\": 5, \"2023-11-20\": 8, \"2023-11-21\": 8, \"2023-11-22\": 4, \"2023-11-23\": 5, \"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 0, \"2023-11-19\": 2, \"2023-11-20\": 1, \"2023-11-21\": 2, \"2023-11-22\": 3, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"visits_direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-16_2023-11-29_visits_direct_line.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXw  **Meta Query**:
Make a line plot of the most popular traffic source since [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract date from the user query and format to YYYY-MM-DD. Output the formatted date as `formatted_date`.",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "2023-11-29",
      "traffic_source": "direct"
    },
    "output": "direct_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "2023-11-29",
      "traffic_source": "referral"
    },
    "output": "referral_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "2023-11-29",
      "traffic_source": "search engine"
    },
    "output": "search_engine_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "2023-11-29",
      "traffic_source": "social media"
    },
    "output": "social_media_visits"
  },
  {
    "type": "dynamic",
    "instruction": "Determine the most popular traffic source from the `direct_visits`, `referral_visits`, `search_engine_visits`, and `social_media_visits`. Use the most popular traffic source to generate a line plot using the `analytics.create_plot` function.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
please plot the distribution of the total visits metric on October 10
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-10\", \"time_max\": \"2023-10-10\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-10_2023-10-10_total_visits_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
please plot the distribution of the total visits metric on October 20
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-20\", \"time_max\": \"2023-10-20\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-20_2023-10-20_total_visits_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u@     }(hh
hX3  **Meta Query**:
Plot the distribution of the total visits metric on {date} as a histogram.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the date from the user query and format it to YYYY-MM-DD.",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "${formatted_date}",
      "value_to_plot": "total_visits",
      "plot_type": "histogram"
    },
    "output": "plot_file_path"
  }
]
```ues}h](}(hhhhu}(hh
hX[@  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Can you make a line plot of the most popular traffic source since September 28?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-12-31\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-09-28\": 6, \"2023-09-29\": 3, \"2023-09-30\": 5, \"2023-10-01\": 2, \"2023-10-02\": 2, \"2023-10-03\": 6, \"2023-10-04\": 4, \"2023-10-05\": 3, \"2023-10-06\": 8, \"2023-10-07\": 5, \"2023-10-08\": 8, \"2023-10-09\": 8, \"2023-10-10\": 5, \"2023-10-11\": 4, \"2023-10-12\": 4, \"2023-10-13\": 5, \"2023-10-14\": 7, \"2023-10-15\": 4, \"2023-10-16\": 5, \"2023-10-17\": 5, \"2023-10-18\": 7, \"2023-10-19\": 3, \"2023-10-20\": 3, \"2023-10-21\": 6, \"2023-10-22\": 10, \"2023-10-23\": 3, \"2023-10-24\": 7, \"2023-10-25\": 0, \"2023-10-26\": 6, \"2023-10-27\": 5, \"2023-10-28\": 10, \"2023-10-29\": 3, \"2023-10-30\": 9, \"2023-10-31\": 5, \"2023-11-01\": 13, \"2023-11-02\": 5, \"2023-11-03\": 6, \"2023-11-04\": 5, \"2023-11-05\": 5, \"2023-11-06\": 6, \"2023-11-07\": 5, \"2023-11-08\": 6, \"2023-11-09\": 9, \"2023-11-10\": 8, \"2023-11-11\": 5, \"2023-11-12\": 8, \"2023-11-13\": 6, \"2023-11-14\": 5, \"2023-11-15\": 9, \"2023-11-16\": 3, \"2023-11-17\": 4, \"2023-11-18\": 3, \"2023-11-19\": 5, \"2023-11-20\": 8, \"2023-11-21\": 8, \"2023-11-22\": 4, \"2023-11-23\": 5, \"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-12-31\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-09-28\": 3, \"2023-09-29\": 2, \"2023-09-30\": 1, \"2023-10-01\": 0, \"2023-10-02\": 4, \"2023-10-03\": 1, \"2023-10-04\": 0, \"2023-10-05\": 0, \"2023-10-06\": 2, \"2023-10-07\": 1, \"2023-10-08\": 1, \"2023-10-09\": 1, \"2023-10-10\": 2, \"2023-10-11\": 2, \"2023-10-12\": 1, \"2023-10-13\": 0, \"2023-10-14\": 0, \"2023-10-15\": 2, \"2023-10-16\": 1, \"2023-10-17\": 2, \"2023-10-18\": 1, \"2023-10-19\": 1, \"2023-10-20\": 1, \"2023-10-21\": 2, \"2023-10-22\": 2, \"2023-10-23\": 1, \"2023-10-24\": 4, \"2023-10-25\": 1, \"2023-10-26\": 0, \"2023-10-27\": 1, \"2023-10-28\": 1, \"2023-10-29\": 1, \"2023-10-30\": 1, \"2023-10-31\": 0, \"2023-11-01\": 1, \"2023-11-02\": 1, \"2023-11-03\": 0, \"2023-11-04\": 1, \"2023-11-05\": 1, \"2023-11-06\": 1, \"2023-11-07\": 2, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-12-31\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-09-28\": 1, \"2023-09-29\": 1, \"2023-09-30\": 0, \"2023-10-01\": 1, \"2023-10-02\": 6, \"2023-10-03\": 2, \"2023-10-04\": 2, \"2023-10-05\": 5, \"2023-10-06\": 0, \"2023-10-07\": 0, \"2023-10-08\": 1, \"2023-10-09\": 2, \"2023-10-10\": 1, \"2023-10-11\": 0, \"2023-10-12\": 0, \"2023-10-13\": 0, \"2023-10-14\": 1, \"2023-10-15\": 2, \"2023-10-16\": 1, \"2023-10-17\": 2, \"2023-10-18\": 2, \"2023-10-19\": 1, \"2023-10-20\": 2, \"2023-10-21\": 3, \"2023-10-22\": 0, \"2023-10-23\": 0, \"2023-10-24\": 1, \"2023-10-25\": 2, \"2023-10-26\": 2, \"2023-10-27\": 1, \"2023-10-28\": 2, \"2023-10-29\": 3, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 0, \"2023-11-02\": 2, \"2023-11-03\": 2, \"2023-11-04\": 1, \"2023-11-05\": 0, \"2023-11-06\": 1, \"2023-11-07\": 1, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 1, \"2023-11-11\": 0, \"2023-11-12\": 1, \"2023-11-13\": 0, \"2023-11-14\": 2, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 0, \"2023-11-19\": 2, \"2023-11-20\": 1, \"2023-11-21\": 2, \"2023-11-22\": 3, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-12-31\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-09-28\": 4, \"2023-09-29\": 3, \"2023-09-30\": 4, \"2023-10-01\": 0, \"2023-10-02\": 3, \"2023-10-03\": 2, \"2023-10-04\": 3, \"2023-10-05\": 6, \"2023-10-06\": 3, \"2023-10-07\": 8, \"2023-10-08\": 5, \"2023-10-09\": 2, \"2023-10-10\": 2, \"2023-10-11\": 3, \"2023-10-12\": 4, \"2023-10-13\": 3, \"2023-10-14\": 2, \"2023-10-15\": 6, \"2023-10-16\": 2, \"2023-10-17\": 6, \"2023-10-18\": 6, \"2023-10-19\": 4, \"2023-10-20\": 2, \"2023-10-21\": 4, \"2023-10-22\": 1, \"2023-10-23\": 4, \"2023-10-24\": 9, \"2023-10-25\": 4, \"2023-10-26\": 2, \"2023-10-27\": 4, \"2023-10-28\": 4, \"2023-10-29\": 7, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 2, \"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"referral\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"search_engine\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"social_media\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"visits_direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-28_2023-11-29_visits_direct_line.png\""
  }
]
```

**Sample2**:
**Query**:
Make a line plot of the most popular traffic source since November 16
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 3, \"2023-11-17\": 4, \"2023-11-18\": 3, \"2023-11-19\": 5, \"2023-11-20\": 8, \"2023-11-21\": 8, \"2023-11-22\": 4, \"2023-11-23\": 5, \"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 0, \"2023-11-19\": 2, \"2023-11-20\": 1, \"2023-11-21\": 2, \"2023-11-22\": 3, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"visits_direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-16_2023-11-29_visits_direct_line.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX}  **Meta Query**:
Make a line plot of the most popular traffic source since [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start date from the user query and format it to YYYY-MM-DD. The start date is a natural language date like 'September 28'.",
    "outputs": [
      "time_min"
    ]
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "2023-12-31",
      "traffic_source": "direct"
    },
    "output": "direct_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "2023-12-31",
      "traffic_source": "referral"
    },
    "output": "referral_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "2023-12-31",
      "traffic_source": "search engine"
    },
    "output": "search_engine_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "2023-12-31",
      "traffic_source": "social media"
    },
    "output": "social_media_visits"
  },
  {
    "type": "dynamic",
    "instruction": "Compare the total visits from each traffic source and determine the most popular one. Use the most popular traffic source to generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `visits_[traffic_source]`.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Was total visits more than 21 at any time in the last 1 weeks? If so, please plot it as a line chart
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 7, \"2023-11-17\": 7, \"2023-11-18\": 6, \"2023-11-19\": 10, \"2023-11-20\": 13, \"2023-11-21\": 11, \"2023-11-22\": 10, \"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

**Sample2**:
**Query**:
Was total visits less than 3 at any time in the last 1 weeks? If so, please plot it as a line chart
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-23\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX[  **Meta Query**:
Was the total visits [comparison_operator] [threshold] at any time in the last [natural_language_time_period]? If so, please plot it as a line chart.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the comparison operator, threshold, and time period from the user query and calculate the start and end date. The time period is natural language like '1 week' or '2 weeks'. Output the start and end dates as ISO 8601 format.",
    "outputs": [
      "time_min",
      "time_max",
      "comparison_operator",
      "threshold"
    ]
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "total_visits_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the total visits data meets the condition specified by the comparison operator and threshold. If so, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `total_visits`.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hXo  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
something came up. Can you cancel my meetings on Tuesday before 9?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_max\": \"2023-12-05 09:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000013\", \"event_name\": \"sync up\", \"participant_email\": \"luis.ortiz@atlas.com\", \"event_start\": \"2023-08-01 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000275\", \"event_name\": \"process review\", \"participant_email\": \"fatima.khan@atlas.com\", \"event_start\": \"2023-08-01 11:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000098\", \"event_name\": \"Data Security and Compliance Training\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-08-02 11:00:00\", \"duration\": \"30\"}, {\"event_id\": \"00000190\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-08-02 11:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000071\", \"event_name\": \"daily stand-up\", \"participant_email\": \"kofi.mensah@atlas.com\", \"event_start\": \"2023-08-02 13:30:00\", \"duration\": \"30\"}]"
  }
]
```

**Sample2**:
**Query**:
something came up. Can you cancel my meetings on Friday before 11:30?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-01 11:30:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000091\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel my meetings on [day_of_week] before [time].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the day of the week and time from the user query, and format the day to an ISO 8601 date based on the current week. Output the formatted date and time_min as ISO 8601 format.",
    "outputs": [
      "formatted_date",
      "time_min"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${time_min}"
    },
    "output": "events_to_cancel"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_to_cancel` list, delete the event using the `calendar.delete_event` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
All my emails from yuki from the last 3 days need to be deleted. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"yuki\", \"date_min\": \"2023-11-27\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "\"No emails found.\""
  }
]
```

**Sample2**:
**Query**:
Delete all my emails from yuki from the last 5 days
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"yuki\", \"date_min\": \"2023-11-25\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000149\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"yuki.tanaka@atlas.com\", \"subject\": \"Task Update on Develop prototype for login system\", \"sent_datetime\": \"2023-11-26 13:09:38\", \"body\": \"Dear Sam,\\\\n\\\\nRegarding task 'Develop prototype for login system', I've made significant progress but have hit a snag with third-party API compatibility. Could use a brainstorm session.\\\\n\\\\nThanks,\\\\nYuki\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000149\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete all my emails from [sender] from the last [natural_language_time_period].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's name and the natural language time period from the user query. Calculate the start and end dates for the search query.",
    "outputs": [
      "sender_name",
      "date_min",
      "date_max"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_name}",
      "date_min": "${date_min}",
      "date_max": "${date_max}"
    },
    "output": "emails_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each email in the `emails_found` list, delete the email using the `email.delete_email` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX&  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Make bar charts of referral and social media over the last 4 weeks if we got more traffic from referral than social media
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-02\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-02\": 1, \"2023-11-03\": 0, \"2023-11-04\": 1, \"2023-11-05\": 1, \"2023-11-06\": 1, \"2023-11-07\": 2, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-02\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  }
]
```

**Sample2**:
**Query**:
If we got more traffic from referral than social media during the last 6 weeks, make bar charts of both over that period
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-19\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-19\": 1, \"2023-10-20\": 1, \"2023-10-21\": 2, \"2023-10-22\": 2, \"2023-10-23\": 1, \"2023-10-24\": 4, \"2023-10-25\": 1, \"2023-10-26\": 0, \"2023-10-27\": 1, \"2023-10-28\": 1, \"2023-10-29\": 1, \"2023-10-30\": 1, \"2023-10-31\": 0, \"2023-11-01\": 1, \"2023-11-02\": 1, \"2023-11-03\": 0, \"2023-11-04\": 1, \"2023-11-05\": 1, \"2023-11-06\": 1, \"2023-11-07\": 2, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-19\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-19\": 4, \"2023-10-20\": 2, \"2023-10-21\": 4, \"2023-10-22\": 1, \"2023-10-23\": 4, \"2023-10-24\": 9, \"2023-10-25\": 4, \"2023-10-26\": 2, \"2023-10-27\": 4, \"2023-10-28\": 4, \"2023-10-29\": 7, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 2, \"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
If we got more traffic from [source1] than [source2] during the last [natural_language_time_period], make [plot_type] charts of both over that period.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the time period, traffic sources (source1 and source2), and plot type from the user query. Calculate the start and end date. The time period is natural language like '4 weeks' or '6 weeks'. Output the start and end dates as ISO 8601 format.",
    "outputs": [
      "time_min",
      "time_max",
      "source1",
      "source2",
      "plot_type"
    ]
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "traffic_source": "${source1}"
    },
    "output": "source1_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "traffic_source": "${source2}"
    },
    "output": "source2_visits"
  },
  {
    "type": "dynamic",
    "instruction": "Compare the total visits of source1 and source2. If source1 has more visits, generate a plot for both sources using the `analytics.create_plot` function with the `value_to_plot` set to the respective traffic source.",
    "outputs": [
      "plot_file_path1",
      "plot_file_path2"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move all of leila's unfinished tasks to the backlog?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"leila@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
I need to move all of leila's unfinished tasks to the backlog. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"leila@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"leila@example.com\", \"list_name\": \"To do\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXY  **Meta Query**:
Move all of [user]'s unfinished tasks to the [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, the current list names (like 'In progress', 'To do'), and the new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_lists",
      "new_list"
    ]
  },
  {
    "type": "dynamic",
    "instruction": "Iterate over each list name in `current_lists`. For each list, call the `project_management.search_tasks` function to find the tasks assigned to the user and in that list.",
    "outputs": [
      "tasks_to_move"
    ]
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_to_move` list, update the task's list_name to the `new_list` using the `project_management.update_task` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I think there's a few customers that haven't responded to a proposal for the software product in 6 weeks. Can you move them to lost in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-25\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
We need to move all customers that haven't responded to a proposal for the software product in 6 weeks to lost. Can you update the CRM?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-14\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
uX     }(hh
hX  **Meta Query**:
Move all customers that haven't responded to a proposal for the [product_interest] in [natural_language_time_period] to the "Lost" status.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the product interest, status, and time period from the user query. Convert the natural language time period to a date format (YYYY-MM-DD) for the `follow_up_by_max` parameter.",
    "outputs": [
      "product_interest",
      "follow_up_by_max"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "product_interest": "${product_interest}",
      "status": "Proposal",
      "follow_up_by_max": "${follow_up_by_max}"
    },
    "output": "customers_to_update"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer in the `customers_to_update` list, update their status to 'Lost'.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move all of kofi's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
Move any of kofi's tasks that are in review to completed
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000219\", \"task_name\": \"Update brand colors in mobile app\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Design\"}, {\"task_id\": \"00000270\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Design\"}, {\"task_id\": \"00000217\", \"task_name\": \"Design logo for blog\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000219\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000270\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000217\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list` and generate a list of updated tasks.",
    "outputs": [
      "updated_tasks"
    ]
  },
  {
    "type": "static",
    "action": "project_management.update_task",
    "params": {
      "task_id": "${updated_tasks.task_id}",
      "field": "list_name",
      "new_value": "${updated_tasks.new_list}"
    },
    "output": "task_updates"
  }
]
```ues}h](}(hhhhu}(hh
hX4  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Make a line plot of the most popular traffic source since October 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-13\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-13\": 5, \"2023-10-14\": 7, \"2023-10-15\": 4, \"2023-10-16\": 5, \"2023-10-17\": 5, \"2023-10-18\": 7, \"2023-10-19\": 3, \"2023-10-20\": 3, \"2023-10-21\": 6, \"2023-10-22\": 10, \"2023-10-23\": 3, \"2023-10-24\": 7, \"2023-10-25\": 0, \"2023-10-26\": 6, \"2023-10-27\": 5, \"2023-10-28\": 10, \"2023-10-29\": 3, \"2023-10-30\": 9, \"2023-10-31\": 5, \"2023-11-01\": 13, \"2023-11-02\": 5, \"2023-11-03\": 6, \"2023-11-04\": 5, \"2023-11-05\": 5, \"2023-11-06\": 6, \"2023-11-07\": 5, \"2023-11-08\": 6, \"2023-11-09\": 9, \"2023-11-10\": 8, \"2023-11-11\": 5, \"2023-11-12\": 8, \"2023-11-13\": 6, \"2023-11-14\": 5, \"2023-11-15\": 9, \"2023-11-16\": 3, \"2023-11-17\": 4, \"2023-11-18\": 3, \"2023-11-19\": 5, \"2023-11-20\": 8, \"2023-11-21\": 8, \"2023-11-22\": 4, \"2023-11-23\": 5, \"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-13\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-13\": 0, \"2023-10-14\": 0, \"2023-10-15\": 2, \"2023-10-16\": 1, \"2023-10-17\": 2, \"2023-10-18\": 1, \"2023-10-19\": 1, \"2023-10-20\": 1, \"2023-10-21\": 2, \"2023-10-22\": 2, \"2023-10-23\": 1, \"2023-10-24\": 4, \"2023-10-25\": 1, \"2023-10-26\": 0, \"2023-10-27\": 1, \"2023-10-28\": 1, \"2023-10-29\": 1, \"2023-10-30\": 1, \"2023-10-31\": 0, \"2023-11-01\": 1, \"2023-11-02\": 1, \"2023-11-03\": 0, \"2023-11-04\": 1, \"2023-11-05\": 1, \"2023-11-06\": 1, \"2023-11-07\": 2, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-13\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-13\": 0, \"2023-10-14\": 1, \"2023-10-15\": 2, \"2023-10-16\": 1, \"2023-10-17\": 2, \"2023-10-18\": 2, \"2023-10-19\": 1, \"2023-10-20\": 2, \"2023-10-21\": 3, \"2023-10-22\": 0, \"2023-10-23\": 0, \"2023-10-24\": 1, \"2023-10-25\": 2, \"2023-10-26\": 2, \"2023-10-27\": 1, \"2023-10-28\": 2, \"2023-10-29\": 3, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 0, \"2023-11-02\": 2, \"2023-11-03\": 2, \"2023-11-04\": 1, \"2023-11-05\": 0, \"2023-11-06\": 1, \"2023-11-07\": 1, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 1, \"2023-11-11\": 0, \"2023-11-12\": 1, \"2023-11-13\": 0, \"2023-11-14\": 2, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 0, \"2023-11-19\": 2, \"2023-11-20\": 1, \"2023-11-21\": 2, \"2023-11-22\": 3, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-13\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-13\": 3, \"2023-10-14\": 2, \"2023-10-15\": 6, \"2023-10-16\": 2, \"2023-10-17\": 6, \"2023-10-18\": 6, \"2023-10-19\": 4, \"2023-10-20\": 2, \"2023-10-21\": 4, \"2023-10-22\": 1, \"2023-10-23\": 4, \"2023-10-24\": 9, \"2023-10-25\": 4, \"2023-10-26\": 2, \"2023-10-27\": 4, \"2023-10-28\": 4, \"2023-10-29\": 7, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 2, \"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-13\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"visits_direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-13_2023-11-29_visits_direct_line.png\""
  }
]
```

**Sample2**:
**Query**:
Make a line plot of the most popular traffic source since November 16
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 3, \"2023-11-17\": 4, \"2023-11-18\": 3, \"2023-11-19\": 5, \"2023-11-20\": 8, \"2023-11-21\": 8, \"2023-11-22\": 4, \"2023-11-23\": 5, \"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 0, \"2023-11-19\": 2, \"2023-11-20\": 1, \"2023-11-21\": 2, \"2023-11-22\": 3, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"visits_direct\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-16_2023-11-29_visits_direct_line.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Make a line plot of the most popular traffic source since {natural_language_start_date}.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start date from the user query and format it to YYYY-MM-DD. Output the start date as `start_date`.",
    "outputs": [
      "start_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${start_date}",
      "traffic_source": "direct"
    },
    "output": "direct_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${start_date}",
      "traffic_source": "referral"
    },
    "output": "referral_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${start_date}",
      "traffic_source": "search engine"
    },
    "output": "search_engine_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${start_date}",
      "traffic_source": "social media"
    },
    "output": "social_media_visits"
  },
  {
    "type": "dynamic",
    "instruction": "Identify the most popular traffic source among `direct_visits`, `referral_visits`, `search_engine_visits`, and `social_media_visits`. Output the traffic source as `most_popular_traffic_source`.",
    "outputs": [
      "most_popular_traffic_source"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${most_recent_date}",
      "value_to_plot": "${most_popular_traffic_source}",
      "plot_type": "line"
    },
    "output": "plot_file_path"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
If average session duration on saturday was more than 3% higher than it was the previous saturday, make a line plot of it over that period.
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-18\", \"time_max\": \"2023-11-25\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-18\": 9.833333333333334, \"2023-11-19\": 23.9, \"2023-11-20\": 28.923076923076923, \"2023-11-21\": 19.90909090909091, \"2023-11-22\": 20.5, \"2023-11-23\": 9.571428571428571, \"2023-11-24\": 21.88888888888889, \"2023-11-25\": 20.857142857142858}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-18\", \"time_max\": \"2023-11-25\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-18_2023-11-25_session_duration_seconds_line.png\""
  }
]
```

**Sample2**:
**Query**:
If average session duration on sunday was more than 2% lower than it was the previous sunday, make a line plot of it over that period.
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-19\", \"time_max\": \"2023-11-19\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-19\": 23.9}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXk  **Meta Query**:
If the average session duration on [day_of_week] was [comparison_operator] [percentage] [comparison] than it was the previous [day_of_week], make a line plot of it over that period.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the day of the week, comparison operator, percentage, and comparison from the user query.",
    "outputs": [
      "day_of_week",
      "comparison_operator",
      "percentage",
      "comparison"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "${formatted_date}"
    },
    "output": "current_weekday_average_session_duration"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${formatted_previous_date}",
      "time_max": "${formatted_previous_date}"
    },
    "output": "previous_weekday_average_session_duration"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the average session duration on the current [day_of_week] meets the condition specified by the comparison operator, percentage, and comparison. If so, generate a line plot using the `analytics.create_plot` function with the `value_to_plot` set to `session_duration_seconds`.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX=>  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move any of fatima's tasks that are in review to completed?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"list_name\": \"In Review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000203\", \"task_name\": \"Update brand colors in website\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000249\", \"task_name\": \"Design logo for e-commerce platform\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000279\", \"task_name\": \"Design logo for website\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000165\", \"task_name\": \"Design UI for landing page\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-28\", \"board\": \"Front end\"}, {\"task_id\": \"00000113\", \"task_name\": \"Design UI for landing page\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Front end\"}, {\"task_id\": \"00000265\", \"task_name\": \"Update brand colors in e-commerce platform\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Design\"}, {\"task_id\": \"00000183\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Front end\"}, {\"task_id\": \"00000276\", \"task_name\": \"Improve UX of onboarding process\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-30\", \"board\": \"Design\"}, {\"task_id\": \"00000070\", \"task_name\": \"Implement search functionality API\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-30\", \"board\": \"Back end\"}, {\"task_id\": \"00000092\", \"task_name\": \"Fix bug in payment processing module\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000035\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"fatima.khan@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000067\", \"task_name\": \"Add authentication for payment gateway\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000076\", \"task_name\": \"Implement user profile management API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000186\", \"task_name\": \"Add animation to navigation bar\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000115\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"anaya.patel@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000272\", \"task_name\": \"Update brand colors in website\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Design\"}, {\"task_id\": \"00000198\", \"task_name\": \"Add animation to navigation bar\", \"assigned_to_email\": \"anaya.patel@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000116\", \"task_name\": \"Fix alignment issue in settings page\", \"assigned_to_email\": \"santiago.martinez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-03\", \"board\": \"Front end\"}, {\"task_id\": \"00000219\", \"task_name\": \"Update brand colors in mobile app\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Design\"}, {\"task_id\": \"00000157\", \"task_name\": \"Design UI for profile page\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Front end\"}, {\"task_id\": \"00000120\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Front end\"}, {\"task_id\": \"00000007\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"yuki.tanaka@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Back end\"}, {\"task_id\": \"00000270\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Design\"}, {\"task_id\": \"00000199\", \"task_name\": \"Design UI for dashboard\", \"assigned_to_email\": \"santiago.martinez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Front end\"}, {\"task_id\": \"00000191\", \"task_name\": \"Integrate Stripe payment API with frontend\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Front end\"}, {\"task_id\": \"00000296\", \"task_name\": \"Improve UX of feedback submission\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Design\"}, {\"task_id\": \"00000252\", \"task_name\": \"Design logo for mobile app\", \"assigned_to_email\": \"amir.ali@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Design\"}, {\"task_id\": \"00000025\", \"task_name\": \"Fix bug in payment processing module\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Back end\"}, {\"task_id\": \"00000271\", \"task_name\": \"Design logo for website\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}, {\"task_id\": \"00000217\", \"task_name\": \"Design logo for blog\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}, {\"task_id\": \"00000292\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-08\", \"board\": \"Design\"}, {\"task_id\": \"00000080\", \"task_name\": \"Optimize database query for report generation\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-09\", \"board\": \"Back end\"}, {\"task_id\": \"00000127\", \"task_name\": \"Implement responsive layout for homepage\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Front end\"}, {\"task_id\": \"00000230\", \"task_name\": \"Improve UX of feedback submission\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Design\"}, {\"task_id\": \"00000053\", \"task_name\": \"Fix bug in data storage module\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Back end\"}, {\"task_id\": \"00000094\", \"task_name\": \"Add authentication for file upload\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000126\", \"task_name\": \"Integrate Google Maps API with frontend\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Front end\"}, {\"task_id\": \"00000012\", \"task_name\": \"Update Django to latest version\", \"assigned_to_email\": \"yuki.tanaka@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000280\", \"task_name\": \"Improve UX of checkout process\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Design\"}, {\"task_id\": \"00000118\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Front end\"}, {\"task_id\": \"00000264\", \"task_name\": \"Develop prototype for login system\", \"assigned_to_email\": \"amir.ali@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Design\"}, {\"task_id\": \"00000073\", \"task_name\": \"Optimize database query for data export\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Back end\"}, {\"task_id\": \"00000197\", \"task_name\": \"Fix alignment issue in dashboard\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Front end\"}, {\"task_id\": \"00000121\", \"task_name\": \"Integrate Twilio SMS API with frontend\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Front end\"}, {\"task_id\": \"00000228\", \"task_name\": \"Create wireframe for dashboard\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Design\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000035\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

**Sample2**:
**Query**:
I've finished reviewing all of fatima's tasks. Can you move all the ones that are in review to completed?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"fatima.khan@atlas.com\", \"list_name\": \"In review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000035\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"fatima.khan@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000035\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Move all of kofi's tasks that are in progress to in review
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
Move any of kofi's tasks that are in review to completed
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000219\", \"task_name\": \"Update brand colors in mobile app\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Design\"}, {\"task_id\": \"00000270\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Design\"}, {\"task_id\": \"00000217\", \"task_name\": \"Design logo for blog\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000219\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000270\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000217\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX0#  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Check the percent growth of average session duration since Friday. If it grew by more than engaged users, plot both lines since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 21.88888888888889, \"2023-11-25\": 20.857142857142858, \"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332, \"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of engaged users since Tuesday. If it grew by more than average session duration, plot both lines since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\", \"value_to_plot\": \"engaged_users\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\", \"value_to_plot\": \"average_session_duration_seconds\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u     }(hh
hX  **Meta Query**:
Determine if the [target_metric] has grown by more than the [comparison_metric] since [start_date]. If so, plot the trends of both metrics since the start date.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start date, target metric, and comparison metric from the user query. Format the start date to YYYY-MM-DD.",
    "outputs": [
      "time_min",
      "target_metric",
      "comparison_metric"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${time_min}"
    },
    "output": "target_metric_data"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${time_min}"
    },
    "output": "comparison_metric_data"
  },
  {
    "type": "dynamic",
    "instruction": "Compare the growth rate of the target metric and the comparison metric since the start date. If the target metric has grown by more than the comparison metric, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `average_session_duration_seconds` and `engaged_users_count`.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX$@  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if carlos has any overdue tasks? If so, send them an email titled 'Overdue tasks' saying 'You have a few overdue tasks - can you update me on them?'. Otherwise email them with 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000013\", \"task_name\": \"Implement payment gateway API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000043\", \"task_name\": \"Update Vue.js to latest version\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"carlos.rodriguez@atlas.com\", \"subject\": \"Good work this sprint\", \"body\": \"Nice work keeping on top of your tasks this sprint!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you check if carlos has any overdue tasks? If so, book a 30 minute meeting with them called 'Catch up on overdue tasks' at the earliest time I'm free tomorrow and send them an email titled 'Discuss overdue tasks' saying 'I noticed you have a few overdue tasks - let's catch up tomorrow.' Otherwise send them an email saying 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000013\", \"task_name\": \"Implement payment gateway API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000043\", \"task_name\": \"Update Vue.js to latest version\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"carlos.rodriguez@atlas.com\", \"subject\": \"Good work this sprint\", \"body\": \"Nice work keeping on top of your tasks this sprint!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check if [user] has any overdue tasks? If so, perform action [overdue_action]; otherwise, perform action [non_overdue_action].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user's email from the user query.",
    "outputs": [
      "user_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${user_email}",
      "due_date": "${current_date}"
    },
    "output": "tasks"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the `tasks` list contains any overdue tasks. If it does, generate an email subject and content for the 'overdue_action'. Otherwise, generate an email subject and content for the 'non_overdue_action'. Output the recipient's email, email subject, and email body.",
    "outputs": [
      "recipient_email",
      "email_subject",
      "email_body"
    ]
  },
  {
    "type": "static",
    "action": "email.send_email",
    "params": {
      "recipient": "${recipient_email}",
      "subject": "${email_subject}",
      "body": "${email_body}"
    },
    "output": "email_result"
  }
]
```ues}h](}(hhhhu}(hh
hXl  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you cancel my first meeting on December 8
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-08 00:00:00\", \"time_max\": \"2023-12-08 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000236\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-08 10:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000213\", \"event_name\": \"IT Systems Update Briefing\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-08 14:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000185\", \"event_name\": \"strategic planning meeting\", \"participant_email\": \"chenwei.zhang@atlas.com\", \"event_start\": \"2023-12-08 15:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000236\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Cancel my first meeting on {natural_language_event_date}.
**Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract date from user query and format to YYYY-MM-DD",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the earliest event from the `event_data` list",
    "outputs": [
      "event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id}"
    },
    "output": "delete_result"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX/  **Meta Query**:
Cancel my first meeting on {natural_language_event_date}.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the event date from the user query and format it to YYYY-MM-DD.",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the earliest event from the `event_data` list",
    "outputs": [
      "event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id}"
    },
    "output": "delete_result"
  }
]
```ues}h](}(hhhhu}(hh
hX
  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].
**Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list` and generate a list of updated tasks.",
    "outputs": [
      "updated_tasks"
    ]
  },
  {
    "type": "static",
    "action": "project_management.update_task",
    "params": {
      "task_id": "${updated_tasks.task_id}",
      "field": "list_name",
      "new_value": "${updated_tasks.new_list}"
    },
    "output": "task_updates"
  }
]
```

**Sample2**:
**Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].
**Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`. Generate a list of updated tasks if needed.",
    "outputs": [
      "updated_tasks"
    ]
  },
  {
    "type": "static",
    "action": "project_management.update_task",
    "params": {
      "task_id": "${updated_tasks.task_id}",
      "field": "list_name",
      "new_value": "${updated_tasks.new_list}"
    },
    "output": "task_updates"
  }
]
```ues}h](}(hhhhu}(hh
hXP<  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
fatima has a bunch of overdue tasks in the backlog. Can you move them to in progress?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"fatima@example.com\", \"list_name\": \"backlog\", \"due_date\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move any of fatima's tasks that are in review to completed?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"list_name\": \"In Review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000203\", \"task_name\": \"Update brand colors in website\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000249\", \"task_name\": \"Design logo for e-commerce platform\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000279\", \"task_name\": \"Design logo for website\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000165\", \"task_name\": \"Design UI for landing page\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-28\", \"board\": \"Front end\"}, {\"task_id\": \"00000113\", \"task_name\": \"Design UI for landing page\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Front end\"}, {\"task_id\": \"00000265\", \"task_name\": \"Update brand colors in e-commerce platform\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Design\"}, {\"task_id\": \"00000183\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Front end\"}, {\"task_id\": \"00000276\", \"task_name\": \"Improve UX of onboarding process\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-30\", \"board\": \"Design\"}, {\"task_id\": \"00000070\", \"task_name\": \"Implement search functionality API\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-30\", \"board\": \"Back end\"}, {\"task_id\": \"00000092\", \"task_name\": \"Fix bug in payment processing module\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000035\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"fatima.khan@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000067\", \"task_name\": \"Add authentication for payment gateway\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000076\", \"task_name\": \"Implement user profile management API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000186\", \"task_name\": \"Add animation to navigation bar\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000115\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"anaya.patel@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000272\", \"task_name\": \"Update brand colors in website\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Design\"}, {\"task_id\": \"00000198\", \"task_name\": \"Add animation to navigation bar\", \"assigned_to_email\": \"anaya.patel@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000116\", \"task_name\": \"Fix alignment issue in settings page\", \"assigned_to_email\": \"santiago.martinez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-03\", \"board\": \"Front end\"}, {\"task_id\": \"00000219\", \"task_name\": \"Update brand colors in mobile app\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Design\"}, {\"task_id\": \"00000157\", \"task_name\": \"Design UI for profile page\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Front end\"}, {\"task_id\": \"00000120\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Front end\"}, {\"task_id\": \"00000007\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"yuki.tanaka@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Back end\"}, {\"task_id\": \"00000270\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Design\"}, {\"task_id\": \"00000199\", \"task_name\": \"Design UI for dashboard\", \"assigned_to_email\": \"santiago.martinez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Front end\"}, {\"task_id\": \"00000191\", \"task_name\": \"Integrate Stripe payment API with frontend\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Front end\"}, {\"task_id\": \"00000296\", \"task_name\": \"Improve UX of feedback submission\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Design\"}, {\"task_id\": \"00000252\", \"task_name\": \"Design logo for mobile app\", \"assigned_to_email\": \"amir.ali@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Design\"}, {\"task_id\": \"00000025\", \"task_name\": \"Fix bug in payment processing module\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Back end\"}, {\"task_id\": \"00000271\", \"task_name\": \"Design logo for website\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}, {\"task_id\": \"00000217\", \"task_name\": \"Design logo for blog\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}, {\"task_id\": \"00000292\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-08\", \"board\": \"Design\"}, {\"task_id\": \"00000080\", \"task_name\": \"Optimize database query for report generation\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-09\", \"board\": \"Back end\"}, {\"task_id\": \"00000127\", \"task_name\": \"Implement responsive layout for homepage\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Front end\"}, {\"task_id\": \"00000230\", \"task_name\": \"Improve UX of feedback submission\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Design\"}, {\"task_id\": \"00000053\", \"task_name\": \"Fix bug in data storage module\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Back end\"}, {\"task_id\": \"00000094\", \"task_name\": \"Add authentication for file upload\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000126\", \"task_name\": \"Integrate Google Maps API with frontend\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Front end\"}, {\"task_id\": \"00000012\", \"task_name\": \"Update Django to latest version\", \"assigned_to_email\": \"yuki.tanaka@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000280\", \"task_name\": \"Improve UX of checkout process\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Design\"}, {\"task_id\": \"00000118\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Front end\"}, {\"task_id\": \"00000264\", \"task_name\": \"Develop prototype for login system\", \"assigned_to_email\": \"amir.ali@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Design\"}, {\"task_id\": \"00000073\", \"task_name\": \"Optimize database query for data export\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Back end\"}, {\"task_id\": \"00000197\", \"task_name\": \"Fix alignment issue in dashboard\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Front end\"}, {\"task_id\": \"00000121\", \"task_name\": \"Integrate Twilio SMS API with frontend\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Front end\"}, {\"task_id\": \"00000228\", \"task_name\": \"Create wireframe for dashboard\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Design\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000035\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need a histogram of total visits and average session duration between September 29 and November 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-29\", \"time_max\": \"2023-11-13\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-29_2023-11-13_total_visits_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-29\", \"time_max\": \"2023-11-13\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-29_2023-11-13_session_duration_seconds_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
I need a histogram of average session duration and engaged users between November 3 and November 19
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-03\", \"time_max\": \"2023-11-19\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-03_2023-11-19_session_duration_seconds_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-03\", \"time_max\": \"2023-11-19\", \"value_to_plot\": \"user_engaged\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-03_2023-11-19_user_engaged_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Generate a histogram plot for [value_to_plot] and [another_value_to_plot] between [start_date] and [end_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start and end dates and the values to plot from the user query.",
    "outputs": [
      "time_min",
      "time_max",
      "value_to_plot",
      "another_value_to_plot"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "value_to_plot": "${value_to_plot}",
      "plot_type": "histogram"
    },
    "output": "plot_file_path_1"
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "value_to_plot": "${another_value_to_plot}",
      "plot_type": "histogram"
    },
    "output": "plot_file_path_2"
  }
]
```ues}h](}(hhhhu}(hh
hX&  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Move all of carlos's overdue tasks in the backlog to in progress
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos@example.com\", \"list_name\": \"backlog\", \"due_date\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of carlos's unfinished tasks to the backlog?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000086\", \"task_name\": \"Optimize database query for content delivery\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Progress\", \"due_date\": \"2023-12-09\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000086\", \"field\": \"list_name\", \"new_value\": \"Backlog\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that meet [criteria] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, criteria, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "criteria",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${criteria}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I think there's a few customers that haven't responded to a proposal for the consulting product in 4 weeks. Can you move them to lost in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Consulting\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
Move all customers that haven't responded to a proposal for the consulting product in 6 weeks to lost in the crm
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Consulting\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-14\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u      }(hh
hX  **Meta Query**:
Move customers that haven't responded to a proposal for the [product_interest] product in [natural_language_time_period] to "Lost" in the CRM.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the product interest and time period from the user query, and convert the time period into a specific date (ISO 8601 format). Output the extracted product interest and the converted date.",
    "outputs": [
      "product_interest",
      "follow_up_by_max"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "product_interest": "${product_interest}",
      "status": "Proposal",
      "follow_up_by_max": "${follow_up_by_max}"
    },
    "output": "customers_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer in the `customers_found` list, update their status to 'Lost' in the CRM.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX7  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Was engaged users more than 11 at any time since October 9? If so, make a backlog task called 'Improve engaged users' on the front-end board and assign it to for nia with next Friday as the deadline
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-10-09\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-09\": 7, \"2023-10-10\": 4, \"2023-10-11\": 6, \"2023-10-12\": 6, \"2023-10-13\": 4, \"2023-10-14\": 7, \"2023-10-15\": 7, \"2023-10-16\": 1, \"2023-10-17\": 7, \"2023-10-18\": 8, \"2023-10-19\": 3, \"2023-10-20\": 3, \"2023-10-21\": 11, \"2023-10-22\": 5, \"2023-10-23\": 4, \"2023-10-24\": 10, \"2023-10-25\": 0, \"2023-10-26\": 3, \"2023-10-27\": 4, \"2023-10-28\": 5, \"2023-10-29\": 10, \"2023-10-30\": 5, \"2023-10-31\": 4, \"2023-11-01\": 5, \"2023-11-02\": 5, \"2023-11-03\": 7, \"2023-11-04\": 6, \"2023-11-05\": 8, \"2023-11-06\": 4, \"2023-11-07\": 6, \"2023-11-08\": 7, \"2023-11-09\": 8, \"2023-11-10\": 8, \"2023-11-11\": 4, \"2023-11-12\": 7, \"2023-11-13\": 1, \"2023-11-14\": 9, \"2023-11-15\": 7, \"2023-11-16\": 5, \"2023-11-17\": 3, \"2023-11-18\": 2, \"2023-11-19\": 7, \"2023-11-20\": 10, \"2023-11-21\": 5, \"2023-11-22\": 7, \"2023-11-23\": 2, \"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve engaged users\", \"assigned_to_email\": \"nia@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Was engaged users more than 11 at any time since September 28? We need to fix this by next Friday if so - make a backlog task called 'Improve engaged users' on the front-end board and assign it to the person with the most completed front end tasks
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-09-28\": 7, \"2023-09-29\": 4, \"2023-09-30\": 5, \"2023-10-01\": 0, \"2023-10-02\": 7, \"2023-10-03\": 6, \"2023-10-04\": 5, \"2023-10-05\": 5, \"2023-10-06\": 4, \"2023-10-07\": 6, \"2023-10-08\": 9, \"2023-10-09\": 7, \"2023-10-10\": 4, \"2023-10-11\": 6, \"2023-10-12\": 6, \"2023-10-13\": 4, \"2023-10-14\": 7, \"2023-10-15\": 7, \"2023-10-16\": 1, \"2023-10-17\": 7, \"2023-10-18\": 8, \"2023-10-19\": 3, \"2023-10-20\": 3, \"2023-10-21\": 11, \"2023-10-22\": 5, \"2023-10-23\": 4, \"2023-10-24\": 10, \"2023-10-25\": 0, \"2023-10-26\": 3, \"2023-10-27\": 4, \"2023-10-28\": 5, \"2023-10-29\": 10, \"2023-10-30\": 5, \"2023-10-31\": 4, \"2023-11-01\": 5, \"2023-11-02\": 5, \"2023-11-03\": 7, \"2023-11-04\": 6, \"2023-11-05\": 8, \"2023-11-06\": 4, \"2023-11-07\": 6, \"2023-11-08\": 7, \"2023-11-09\": 8, \"2023-11-10\": 8, \"2023-11-11\": 4, \"2023-11-12\": 7, \"2023-11-13\": 1, \"2023-11-14\": 9, \"2023-11-15\": 7, \"2023-11-16\": 5, \"2023-11-17\": 3, \"2023-11-18\": 2, \"2023-11-19\": 7, \"2023-11-20\": 10, \"2023-11-21\": 5, \"2023-11-22\": 7, \"2023-11-23\": 2, \"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve engaged users\", \"assigned_to_email\": \"generic.email@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Was the [metric] [comparison_operator] [threshold] at any time since [natural_language_start_date]? If so, make a backlog task called 'Improve [metric]' on the [board] board and assign it to [assignee] with [due_date] as the deadline.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric, comparison operator, threshold, natural language start date, board name, assignee, and due date from the user query. Output the start date in ISO 8601 format and ensure the due date is in ISO 8601 format.",
    "outputs": [
      "metric",
      "comparison_operator",
      "threshold",
      "time_min",
      "board",
      "assignee",
      "due_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${formatted_date}"
    },
    "output": "metric_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the metric data meets the condition specified by the comparison operator and threshold. If so, generate a task using the `project_management.create_task` function with the appropriate parameters.",
    "outputs": [
      "task_id"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Cancel my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you cancel my first meeting on December 8
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-08 00:00:00\", \"time_max\": \"2023-12-08 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000236\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-08 10:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000213\", \"event_name\": \"IT Systems Update Briefing\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-08 14:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000185\", \"event_name\": \"strategic planning meeting\", \"participant_email\": \"chenwei.zhang@atlas.com\", \"event_start\": \"2023-12-08 15:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000236\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX3  **Meta Query**:
Cancel my first meeting on [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the date from the user query and format it to YYYY-MM-DD",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_list"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the `event_id` of the first event from the `event_list`.",
    "outputs": [
      "event_id_to_cancel"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id_to_cancel}"
    },
    "output": "deletion_result"
  }
]
```ues}h](}(hhhhu}(hh
hX_(  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
If we got more traffic from referral than social media during the last 6 weeks, make bar charts of both over that period
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-19\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-19\": 1, \"2023-10-20\": 1, \"2023-10-21\": 2, \"2023-10-22\": 2, \"2023-10-23\": 1, \"2023-10-24\": 4, \"2023-10-25\": 1, \"2023-10-26\": 0, \"2023-10-27\": 1, \"2023-10-28\": 1, \"2023-10-29\": 1, \"2023-10-30\": 1, \"2023-10-31\": 0, \"2023-11-01\": 1, \"2023-11-02\": 1, \"2023-11-03\": 0, \"2023-11-04\": 1, \"2023-11-05\": 1, \"2023-11-06\": 1, \"2023-11-07\": 2, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-19\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-19\": 4, \"2023-10-20\": 2, \"2023-10-21\": 4, \"2023-10-22\": 1, \"2023-10-23\": 4, \"2023-10-24\": 9, \"2023-10-25\": 4, \"2023-10-26\": 2, \"2023-10-27\": 4, \"2023-10-28\": 4, \"2023-10-29\": 7, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 2, \"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  }
]
```

**Sample2**:
**Query**:
If we got more traffic from search engine than social media during the last 5 weeks, make bar charts of both over that period
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-23\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"search engine\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-23\": 0, \"2023-10-24\": 1, \"2023-10-25\": 2, \"2023-10-26\": 2, \"2023-10-27\": 1, \"2023-10-28\": 2, \"2023-10-29\": 3, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 0, \"2023-11-02\": 2, \"2023-11-03\": 2, \"2023-11-04\": 1, \"2023-11-05\": 0, \"2023-11-06\": 1, \"2023-11-07\": 1, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 1, \"2023-11-11\": 0, \"2023-11-12\": 1, \"2023-11-13\": 0, \"2023-11-14\": 2, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 0, \"2023-11-19\": 2, \"2023-11-20\": 1, \"2023-11-21\": 2, \"2023-11-22\": 3, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 0, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 2, \"2023-11-29\": 1}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-10-23\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-23\": 4, \"2023-10-24\": 9, \"2023-10-25\": 4, \"2023-10-26\": 2, \"2023-10-27\": 4, \"2023-10-28\": 4, \"2023-10-29\": 7, \"2023-10-30\": 1, \"2023-10-31\": 2, \"2023-11-01\": 2, \"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX,  **Meta Query**:
If we got more traffic from [traffic_source1] than [traffic_source2] during the last [natural_language_time_period], make bar charts of both over that period.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the traffic sources and time period from the user query. Calculate the start and end date based on the time period and format them as ISO 8601. Output the traffic sources and dates as `traffic_source1`, `traffic_source2`, `time_min`, and `time_max`.",
    "outputs": [
      "traffic_source1",
      "traffic_source2",
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "traffic_source": "${traffic_source1}"
    },
    "output": "traffic_source1_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "traffic_source": "${traffic_source2}"
    },
    "output": "traffic_source2_visits"
  },
  {
    "type": "dynamic",
    "instruction": "Compare the total visits from `traffic_source1_visits` and `traffic_source2_visits`. If `traffic_source1` has more visits than `traffic_source2`, generate a bar chart using `analytics.create_plot` with `value_to_plot` set to `traffic_source1_visits` and `value_to_plot` set to `traffic_source2_visits`. Output the path to the generated plot file.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
please plot the distribution of the total visits metric on October 10
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-10\", \"time_max\": \"2023-10-10\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-10_2023-10-10_total_visits_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
please plot the distribution of the total visits metric on September 9
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-09\", \"time_max\": \"2023-09-09\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-09_2023-09-09_total_visits_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXn  **Meta Query**:
Plot the distribution of the [metric] metric on [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric to plot and the date from the user query and format the date to ISO 8601 format.",
    "outputs": [
      "value_to_plot",
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "${formatted_date}",
      "value_to_plot": "${value_to_plot}",
      "plot_type": "histogram"
    },
    "output": "plot_file_path"
  }
]
```ues}h](}(hhhhu}(hh
hX=2  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if engaged users was less than 11 at any time since November 26? If so, send an email to luis.ortiz@atlas.com titled 'Update on engaged users' saying 'I noticed engaged users was less than 11 - can you update me?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"luis.ortiz@atlas.com\", \"subject\": \"Update on engaged users\", \"body\": \"I noticed engaged users was less than 11 - can you update me?\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you check if engaged users was more than 5 at any time since November 1? If so, send an email to leila.azizi@atlas.com titled 'Update on engaged users' saying 'I noticed engaged users was more than 5 - can you update me?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-01\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-01\": 5, \"2023-11-02\": 5, \"2023-11-03\": 7, \"2023-11-04\": 6, \"2023-11-05\": 8, \"2023-11-06\": 4, \"2023-11-07\": 6, \"2023-11-08\": 7, \"2023-11-09\": 8, \"2023-11-10\": 8, \"2023-11-11\": 4, \"2023-11-12\": 7, \"2023-11-13\": 1, \"2023-11-14\": 9, \"2023-11-15\": 7, \"2023-11-16\": 5, \"2023-11-17\": 3, \"2023-11-18\": 2, \"2023-11-19\": 7, \"2023-11-20\": 10, \"2023-11-21\": 5, \"2023-11-22\": 7, \"2023-11-23\": 2, \"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Update on engaged users\", \"body\": \"I noticed engaged users was more than 5 - can you update me?\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check if engaged users [comparison_operator] [threshold] at any time since [start_date]. If so, send an email to [recipient] titled 'Update on engaged users' saying 'I noticed engaged users was [comparison_operator] [threshold] - can you update me?'

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the comparison operator, threshold, start date, and recipient email from the user query.",
    "outputs": [
      "comparison_operator",
      "threshold",
      "start_date",
      "recipient"
    ]
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${utils.get_today_date()}"
    },
    "output": "engaged_users_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the engaged users data meets the condition specified by the comparison operator and threshold. If so, generate an email content to be sent to the recipient.",
    "outputs": [
      "email_content"
    ]
  },
  {
    "type": "static",
    "action": "email.send_email",
    "params": {
      "recipient": "${recipient}",
      "subject": "Update on engaged users",
      "body": "${email_content}"
    },
    "output": "email_sent"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Push back my first meeting with yuki on December 4 by 2 hours
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"Yuki\", \"time_min\": \"2023-12-04 00:00:00\", \"time_max\": \"2023-12-04 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000062\", \"event_name\": \"performance evaluation\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-12-04 14:30:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.update_event\", \"params\": {\"event_id\": \"00000062\", \"field\": \"event_start\", \"new_value\": \"2023-12-04 16:30:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event updated successfully.\""
  }
]
```

**Sample2**:
**Query**:
Delay my first meeting with yuki on December 4 by 30 minutes
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"yuki\", \"time_min\": \"2023-12-04 00:00:00\", \"time_max\": \"2023-12-04 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000062\", \"event_name\": \"performance evaluation\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-12-04 14:30:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.update_event\", \"params\": {\"event_id\": \"00000062\", \"field\": \"event_start\", \"new_value\": \"2023-12-04 15:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Push back or delay my first meeting with [participant] on [natural_language_date] by [duration].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the participant, date, and duration from the user query. Format the date to YYYY-MM-DD.",
    "outputs": [
      "participant_email",
      "formatted_date",
      "duration"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${participant_email}",
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the earliest event's start time from the `event_data` list and calculate the new start time by adding the provided duration. Generate an update event call with the new start time.",
    "outputs": [
      "event_id",
      "new_event_start"
    ]
  },
  {
    "type": "static",
    "action": "calendar.update_event",
    "params": {
      "event_id": "${event_id}",
      "field": "event_start",
      "new_value": "${new_event_start}"
    },
    "output": "update_message"
  }
]
```ues
     }h](}(hhhhu}(hh
hX-  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to check if I have any meetings scheduled with amir in the next 2 days. If not, send them an email titled 'Catch up soon?' saying 'We have not caught up in a while - can you send some availability over next week?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"amir\", \"time_min\": \"2023-11-30 00:00:00\", \"time_max\": \"2023-12-02 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000261\", \"event_name\": \"performance evaluation\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-01 14:30:00\", \"duration\": \"30\"}]"
  }
]
```

**Sample2**:
**Query**:
I haven't met with amir in a while. if it's been longer than 2 days can you send them an email titled 'Catch up soon?' saying 'We haven't caught up in a while - can you send some availability over next week?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"Amir\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000098\", \"event_name\": \"Data Security and Compliance Training\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-08-02 11:00:00\", \"duration\": \"30\"}, {\"event_id\": \"00000135\", \"event_name\": \"Annual Budget Planning Session\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-09-08 13:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000280\", \"event_name\": \"feedback discussion\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-09-26 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000084\", \"event_name\": \"process review\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-09-26 11:00:00\", \"duration\": \"120\"}, {\"event_id\": \"00000210\", \"event_name\": \"brainstorming session\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-09-29 12:00:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"amir.ali@atlas.com\", \"subject\": \"Catch up soon?\", \"body\": \"We haven't caught up in a while - can you send some availability over next week?\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check if there are any meetings scheduled with [user] in the next [time_period]. If not, send them an email titled '[email_subject]' saying '[email_body]'.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, time period, email subject, and email body from the user query. Convert the time period into a start and end date in ISO 8601 format.",
    "outputs": [
      "participant_email",
      "time_min",
      "time_max",
      "email_subject",
      "email_body"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${participant_email}",
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "Check if there are any events in the `events_found` list. If none are found, send an email to the user with the specified subject and body.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I think there's a few customers that haven't responded to a proposal for the software product in 6 weeks. Can you move them to lost in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-25\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
I think there's a few customers that haven't responded to a proposal for the consulting product in 4 weeks. Can you move them to lost in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Consulting\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move customers that have not responded to a proposal for the [product_interest] product in the last [natural_language_period] to the "Lost" status in the CRM.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the product interest and the follow-up period from the user query and convert the natural language period into a specific date format.",
    "outputs": [
      "product_interest",
      "follow_up_by_max"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "product_interest": "${product_interest}",
      "status": "Proposal",
      "follow_up_by_max": "${follow_up_by_max}"
    },
    "output": "customers_to_update"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer found in the `customers_to_update` list, update their status to 'Lost'.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX:  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Delete my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Cancel my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX5  **Meta Query**:
Delete or cancel the first event on [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the date from the user query and format it to YYYY-MM-DD.",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "events"
  },
  {
    "type": "dynamic",
    "instruction": "Identify the first event from the list of events `events` and output the event ID.",
    "outputs": [
      "event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id}"
    },
    "output": "delete_result"
  }
]
```ues}h](}(hhhhu}(hh
hX4%  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to delete my last email from leila. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Leila\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000052\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Integrate Google Maps API with frontend\", \"sent_datetime\": \"2023-11-28 11:12:12\", \"body\": \"Dear Sam,\\\\n\\\\nCompleted task 'Integrate Google Maps API with frontend' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nRegards,\\\\nLeila\"}, {\"email_id\": \"00000349\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Add animation to form submission button\", \"sent_datetime\": \"2023-11-28 09:49:54\", \"body\": \"Sam,\\\\n\\\\nCompleted task 'Add animation to form submission button' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nRegards,\\\\nLeila\"}, {\"email_id\": \"00000200\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Develop prototype for payment gateway\", \"sent_datetime\": \"2023-11-27 13:02:32\", \"body\": \"Hey Sam,\\\\n\\\\nI've been assigned 'Develop prototype for payment gateway'. Excited to work on this and confident it will greatly improve our security protocols.\\\\n\\\\nThanks,\\\\nLeila\"}, {\"email_id\": \"00000433\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Develop prototype for login system\", \"sent_datetime\": \"2023-11-25 13:11:21\", \"body\": \"Dear Sam,\\\\n\\\\nI've been assigned 'Develop prototype for login system'. Excited to work on this and confident it will greatly improve our backend efficiency.\\\\n\\\\nRegards,\\\\nLeila\"}, {\"email_id\": \"00000086\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Implement payment gateway API\", \"sent_datetime\": \"2023-11-20 14:43:48\", \"body\": \"Hi Sam,\\\\n\\\\nCompleted task 'Implement payment gateway API' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nCheers,\\\\nLeila\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000052\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Delete my last email from nadia
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"nadia\", \"date_min\": \"2023-11-23\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000479\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nadia.moreau@atlas.com\", \"subject\": \"Update on Health & Wellness Expo\", \"sent_datetime\": \"2023-11-29 12:32:17\", \"body\": \"Hey Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the Health & Wellness Expo. Looking forward to your feedback.\\\\n\\\\nCheers,\\\\nNadia\"}, {\"email_id\": \"00000070\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nadia.moreau@atlas.com\", \"subject\": \"Update on Diversity & Inclusion Workshop\", \"sent_datetime\": \"2023-11-26 10:25:56\", \"body\": \"Sam,\\\\n\\\\nI have some ideas for the Diversity & Inclusion Workshop that I'd like to run by you. When are you free?\\\\n\\\\nCheers,\\\\nNadia\"}, {\"email_id\": \"00000460\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nadia.moreau@atlas.com\", \"subject\": \"Update on project progress update\", \"sent_datetime\": \"2023-11-24 13:50:00\", \"body\": \"Sam,\\\\n\\\\nReminder about the project progress update next week. lets make sure we're all prepared.\\\\n\\\\nI also wanted to share some exciting news about our upcoming team-building event. We've been planning a fun and engaging day for everyone, and I'm confident it will be a great opportunity for everyone to unwind and bond with their colleagues. I'll be sending out more details soon, so keep an eye out for that!\\\\n\\\\nThanks,\\\\nNadia\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000479\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete the last email from [sender].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email from the user query and set the date range for the last email to be deleted. Use the current date as the upper limit and calculate the lower limit as the date one week ago.",
    "outputs": [
      "sender_email",
      "date_min",
      "date_max"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_email}",
      "date_min": "${date_min}",
      "date_max": "${date_max}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "Identify the most recent email (based on sent_datetime) from the `matching_emails` list and extract its email_id.",
    "outputs": [
      "email_id_to_delete"
    ]
  },
  {
    "type": "static",
    "action": "email.delete_email",
    "params": {
      "email_id": "${email_id_to_delete}"
    },
    "output": "deletion_result"
  }
]
```ues}h](}(hhhhu}(hh
hX1  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if total visits was more than 21 at any time since October 12? If so, make a backlog task called 'Improve total visits' for dmitri on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-12\": 9, \"2023-10-13\": 8, \"2023-10-14\": 10, \"2023-10-15\": 14, \"2023-10-16\": 9, \"2023-10-17\": 15, \"2023-10-18\": 16, \"2023-10-19\": 9, \"2023-10-20\": 8, \"2023-10-21\": 15, \"2023-10-22\": 13, \"2023-10-23\": 8, \"2023-10-24\": 21, \"2023-10-25\": 7, \"2023-10-26\": 10, \"2023-10-27\": 11, \"2023-10-28\": 17, \"2023-10-29\": 14, \"2023-10-30\": 12, \"2023-10-31\": 9, \"2023-11-01\": 16, \"2023-11-02\": 13, \"2023-11-03\": 11, \"2023-11-04\": 9, \"2023-11-05\": 10, \"2023-11-06\": 10, \"2023-11-07\": 13, \"2023-11-08\": 11, \"2023-11-09\": 14, \"2023-11-10\": 11, \"2023-11-11\": 10, \"2023-11-12\": 12, \"2023-11-13\": 8, \"2023-11-14\": 13, \"2023-11-15\": 11, \"2023-11-16\": 7, \"2023-11-17\": 7, \"2023-11-18\": 6, \"2023-11-19\": 10, \"2023-11-20\": 13, \"2023-11-21\": 11, \"2023-11-22\": 10, \"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"dmitri@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
If total visits was more than 21 at any time since November 29 make a backlog task called 'Improve total visits' for santiago on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 10}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Was the total visits more than [threshold] at any time in the last [natural_language_time_period]? If so, create a backlog task called 'Improve total visits' for [assigned_to_email] on the [board] board with a deadline of next Friday.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the threshold, time period, assigned_to_email, and board name from the user query. Convert the natural language time period to a date range and output the start date and end date in ISO 8601 format.",
    "outputs": [
      "time_min",
      "time_max",
      "threshold",
      "assigned_to_email",
      "board"
    ]
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "total_visits_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the total visits data meets the condition specified by the threshold. If so, generate a task creation request for the 'Improve total visits' task.",
    "outputs": [
      "task_creation_required"
    ]
  },
  {
    "type": "static",
    "action": "project_management.create_task",
    "params": {
      "task_name": "Improve total visits",
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "Backlog",
      "due_date": "next_friday",
      "board": "${board}"
    },
    "output": "task_id",
    "condition": "${task_creation_required}"
  }
]
```ues}h](}(hhhhu}(hh
hXQ  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you add Jaden Brown to the crm? They're a new lead and need to be assigned to Sofia
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.add_customer\", \"params\": {\"customer_name\": \"Jaden Brown\", \"assigned_to_email\": \"sofia.santos@atlas.com\", \"status\": \"Lead\"}}"
  },
  {
    "from": "observation",
    "value": "\"00000200\""
  }
]
```

**Sample2**:
**Query**:
can you add Taylor Robinson to the crm? They're a new lead and need to be assigned to Sofia
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.add_customer\", \"params\": {\"customer_name\": \"Taylor Robinson\", \"assigned_to_email\": \"sofia.santos@atlas.com\", \"status\": \"Lead\"}}"
  },
  {
    "from": "observation",
    "value": "\"00000200\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Add a new customer [customer_name] to the CRM, assign them to [assigned_to_email], and set their status to [status].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract customer_name, assigned_to_email, and status from the user query.",
    "outputs": [
      "customer_name",
      "assigned_to_email",
      "status"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.add_customer",
    "params": {
      "customer_name": "${customer_name}",
      "assigned_to_email": "${assigned_to_email}",
      "status": "${status}"
    },
    "output": "customer_id"
  }
]
```ues}h](}(hhhhu}(hh
hX;"  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
If average session duration on sunday was more than 2% lower than it was the previous sunday, make a line plot of it over that period.
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-19\", \"time_max\": \"2023-11-19\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-19\": 23.9}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0}"
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of engaged users since Tuesday. If it grew by more than average session duration, plot both lines since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\", \"value_to_plot\": \"engaged_users\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-30\", \"value_to_plot\": \"average_session_duration_seconds\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"Value to plot must be one of 'total_visits', 'session_duration_seconds', 'user_engaged', 'direct', 'referral', 'search engine', 'social media'\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}%     }(hh
hX   **Meta Query**:
Analyze the trend of a specific metric (e.g., average session duration, engaged users count) over a given time period and plot it if certain conditions are met.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric to analyze, start date, end date, and any comparison threshold or condition from the user query. Output the metric name, start date, end date, and comparison threshold.",
    "outputs": [
      "metric_name",
      "start_date",
      "end_date",
      "comparison_threshold"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${end_date}"
    },
    "output": "average_session_duration_data"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${end_date}"
    },
    "output": "engaged_users_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the metric data meets the condition specified by the comparison threshold. If so, generate a line chart using the `analytics.create_plot` function with the appropriate metric data.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX(  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to delete my last email from leila. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Leila\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000052\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Integrate Google Maps API with frontend\", \"sent_datetime\": \"2023-11-28 11:12:12\", \"body\": \"Dear Sam,\\\\n\\\\nCompleted task 'Integrate Google Maps API with frontend' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nRegards,\\\\nLeila\"}, {\"email_id\": \"00000349\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Add animation to form submission button\", \"sent_datetime\": \"2023-11-28 09:49:54\", \"body\": \"Sam,\\\\n\\\\nCompleted task 'Add animation to form submission button' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nRegards,\\\\nLeila\"}, {\"email_id\": \"00000200\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Develop prototype for payment gateway\", \"sent_datetime\": \"2023-11-27 13:02:32\", \"body\": \"Hey Sam,\\\\n\\\\nI've been assigned 'Develop prototype for payment gateway'. Excited to work on this and confident it will greatly improve our security protocols.\\\\n\\\\nThanks,\\\\nLeila\"}, {\"email_id\": \"00000433\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Develop prototype for login system\", \"sent_datetime\": \"2023-11-25 13:11:21\", \"body\": \"Dear Sam,\\\\n\\\\nI've been assigned 'Develop prototype for login system'. Excited to work on this and confident it will greatly improve our backend efficiency.\\\\n\\\\nRegards,\\\\nLeila\"}, {\"email_id\": \"00000086\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"leila.azizi@atlas.com\", \"subject\": \"Task Update on Implement payment gateway API\", \"sent_datetime\": \"2023-11-20 14:43:48\", \"body\": \"Hi Sam,\\\\n\\\\nCompleted task 'Implement payment gateway API' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nCheers,\\\\nLeila\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000052\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Delete my last email from anaya
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Anaya\", \"date_min\": \"2023-11-01\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000166\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Task Update on Fix alignment issue in settings page\", \"sent_datetime\": \"2023-11-29 13:19:14\", \"body\": \"Hi Sam,\\\\n\\\\nRegarding task 'Fix alignment issue in settings page', I've made significant progress but have hit a snag with UI responsiveness. Could use a brainstorm session.\\\\n\\\\nCheers,\\\\nAnaya\"}, {\"email_id\": \"00000456\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on process review\", \"sent_datetime\": \"2023-11-27 13:32:00\", \"body\": \"Hey Sam,\\\\n\\\\nReminder about the process review next week. Let's make sure we're all prepared.\\\\n\\\\nCheers,\\\\nAnaya\"}, {\"email_id\": \"00000281\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on status briefing\", \"sent_datetime\": \"2023-11-22 12:16:17\", \"body\": \"Hey Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the status briefing. Looking forward to your feedback.\\\\n\\\\nI also wanted to share some exciting news about our upcoming team-building event. We've been planning a fun and engaging day for everyone, and I'm confident it will be a great opportunity for everyone to unwindd and bond with their colleagues. I'll be sending out more details soon, so keep an eye out for that!\\\\n\\\\nThanks,\\\\nAnaya\"}, {\"email_id\": \"00000414\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on weekly summary\", \"sent_datetime\": \"2023-11-22 10:53:33\", \"body\": \"Hi Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the weekly summary. Looking forward to your feedback.\\\\n\\\\nBest,\\\\nAnaya\"}, {\"email_id\": \"00000120\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on Board of Directors Conclave\", \"sent_datetime\": \"2023-11-21 13:26:29\", \"body\": \"Hey Sam,\\\\n\\\\nEncountered a few challenges while working on the Board of Directors Conclave. Could use your advice.\\\\n\\\\nThanks,\\\\nAnaya\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000166\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete the last email from [sender].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email address from the user query.",
    "outputs": [
      "sender_email"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_email}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "Identify the email_id of the last email from the `matching_emails` list and assign it to `last_email_id`.",
    "outputs": [
      "last_email_id"
    ]
  },
  {
    "type": "static",
    "action": "email.delete_email",
    "params": {
      "email_id": "${last_email_id}"
    },
    "output": "deletion_confirmation"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Quinn Thomas has moved to lead status. Can you update that in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"customer_name\": \"Quinn Thomas\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"customer_id\": \"00000041\", \"assigned_to_email\": \"akira.sato@atlas.com\", \"customer_name\": \"Quinn Thomas\", \"customer_email\": \"quinn.thomas@tracebiotech\", \"customer_phone\": \"835-217-3683\", \"last_contact_date\": \"2023-10-20\", \"product_interest\": \"Services\", \"status\": \"Proposal\", \"follow_up_by\": \"2023-10-30\", \"notes\": NaN}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000201\", \"field\": \"status\", \"new_value\": \"Lead\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000041\", \"field\": \"status\", \"new_value\": \"Lead\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer updated successfully.\""
  }
]
```

**Sample2**:
**Query**:
Jamie Davis has moved to lead status. Can you update that in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"customer_name\": \"Jamie Davis\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"customer_id\": \"00000007\", \"assigned_to_email\": \"sofia.santos@atlas.com\", \"customer_name\": \"Jamie Davis\", \"customer_email\": \"jamie.davis@omnibiotech\", \"customer_phone\": \"490-710-8668\", \"last_contact_date\": \"2023-11-03\", \"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by\": \"2023-11-18\", \"notes\": NaN}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000007\", \"field\": \"status\", \"new_value\": \"Lead\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Update the status of the customer [customer_name] to [new_status] in the CRM.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the customer name and new status from the user query.",
    "outputs": [
      "customer_name",
      "new_status"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "customer_name": "${customer_name}"
    },
    "output": "customer_info"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the customer ID from the `customer_info` and update the customer's status to the `new_status` using the `customer_relationship_manager.update_customer` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX"  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Is total visits more than 3% higher than it was on Wednesday? If so, please plot it as a line chart since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-28\", \"time_max\": \"2023-11-28\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-28\": 19}"
  }
]
```

**Sample2**:
**Query**:
Is total visits more than 5% lower than September 28? If so, please plot it as a line chart
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-09-28\": 14, \"2023-09-29\": 9, \"2023-09-30\": 10, \"2023-10-01\": 3, \"2023-10-02\": 15, \"2023-10-03\": 11, \"2023-10-04\": 9, \"2023-10-05\": 14, \"2023-10-06\": 13, \"2023-10-07\": 14, \"2023-10-08\": 15, \"2023-10-09\": 13, \"2023-10-10\": 10, \"2023-10-11\": 9, \"2023-10-12\": 9, \"2023-10-13\": 8, \"2023-10-14\": 10, \"2023-10-15\": 14, \"2023-10-16\": 9, \"2023-10-17\": 15, \"2023-10-18\": 16, \"2023-10-19\": 9, \"2023-10-20\": 8, \"2023-10-21\": 15, \"2023-10-22\": 13, \"2023-10-23\": 8, \"2023-10-24\": 21, \"2023-10-25\": 7, \"2023-10-26\": 10, \"2023-10-27\": 11, \"2023-10-28\": 17, \"2023-10-29\": 14, \"2023-10-30\": 12, \"2023-10-31\": 9, \"2023-11-01\": 16, \"2023-11-02\": 13, \"2023-11-03\": 11, \"2023-11-04\": 9, \"2023-11-05\": 10, \"2023-11-06\": 10, \"2023-11-07\": 13, \"2023-11-08\": 11, \"2023-11-09\": 14, \"2023-11-10\": 11, \"2023-11-11\": 10, \"2023-11-12\": 12, \"2023-11-13\": 8, \"2023-11-14\": 13, \"2023-11-15\": 11, \"2023-11-16\": 7, \"2023-11-17\": 7, \"2023-11-18\": 6, \"2023-11-19\": 10, \"2023-11-20\": 13, \"2023-11-21\": 11, \"2023-11-22\": 10, \"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-28\", \"time_max\": \"2023-11-29\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-28_2023-11-29_total_visits_line.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXk  **Meta Query**:
Is the total visits [comparison_operator] [percentage_change] compared to [comparison_date]? If so, please plot it as a line chart since [comparison_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the comparison operator, percentage change, comparison date, and plot type from the user query.",
    "outputs": [
      "comparison_operator",
      "percentage_change",
      "comparison_date",
      "plot_type"
    ]
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${comparison_date}",
      "time_max": "${comparison_date}"
    },
    "output": "visits_on_comparison_date"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${comparison_date}",
      "time_max": "2023-11-30"
    },
    "output": "visits_since_comparison_date"
  },
  {
    "type": "dynamic",
    "instruction": "Compare the total visits on the comparison date with the total visits since the comparison date using the provided comparison operator and percentage change. If the condition is met, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `total_visits` and the `plot_type` set to `line`. Output the file path of the plot.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Was average session duration on monday more than 3% lower than it was the previous monday? If so, please plot it as a line chart
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-20\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-20\": 28.923076923076923, \"2023-11-21\": 19.90909090909091, \"2023-11-22\": 20.5, \"2023-11-23\": 9.571428571428571, \"2023-11-24\": 21.88888888888889, \"2023-11-25\": 20.857142857142858, \"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-20\", \"time_max\": \"2023-11-27\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-20_2023-11-27_session_duration_seconds_line.png\""
  }
]
```

**Sample2**:
**Query**:
Is average session duration more than 10% lower than it was on Wednesday? If so, please plot it as a line chart since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Was the average session duration on [comparison_day] more than [comparison_percentage] lower than it was on [baseline_day]? If so, please plot it as a line chart.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the comparison day, comparison percentage, and baseline day from the user query. Calculate the start and end dates based on these days and output them.",
    "outputs": [
      "comparison_day_start",
      "comparison_day_end",
      "baseline_day_start",
      "baseline_day_end",
      "comparison_percentage"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${comparison_day_start}",
      "time_max": "${comparison_day_end}"
    },
    "output": "comparison_day_average_session_duration"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${baseline_day_start}",
      "time_max": "${baseline_day_end}"
    },
    "output": "baseline_day_average_session_duration"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the average session duration on `comparison_day` is more than `comparison_percentage` lower than on `baseline_day`. If so, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `session_duration_seconds`.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I think there's a few customers that haven't responded to a proposal for the consulting product in 4 weeks. Can you move them to lost in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Consulting\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
We need to move all customers that haven't responded to a proposal for the software product in 6 weeks to lost. Can you update the CRM?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-14\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move customers that haven't responded to a proposal for the [product_interest] product in [follow_up_period] weeks to lost in the CRM.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the product_interest and follow_up_period from the user query. Calculate the follow_up_by_max date based on the current date and the follow_up_period. Output the product_interest, follow_up_by_max, and status.",
    "outputs": [
      "product_interest",
      "follow_up_by_max",
      "status"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "product_interest": "${product_interest}",
      "status": "${status}",
      "follow_up_by_max": "${follow_up_by_max}"
    },
    "output": "customers_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer in the `customers_found` list, update the customer's status to 'Lost'. Output the updated customer information.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
dmitri has a bunch of overdue tasks in the backlog. Can you move them to in progress?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"dmitri@example.com\", \"list_name\": \"backlog\", \"due_date\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move any of dmitri's tasks that are in review to completed?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000067\", \"task_name\": \"Add authentication for payment gateway\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000053\", \"task_name\": \"Fix bug in data storage module\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Back end\"}, {\"task_id\": \"00000094\", \"task_name\": \"Add authentication for file upload\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000073\", \"task_name\": \"Optimize database query for data export\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000067\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000053\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000094\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000073\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
Delete all my emails from yuki from the last 5 days
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"yuki\", \"date_min\": \"2023-11-25\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000149\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"yuki.tanaka@atlas.com\", \"subject\": \"Task Update on Develop prototype for login system\", \"sent_datetime\": \"2023-11-26 13:09:38\", \"body\": \"Dear Sam,\\\\n\\\\nRegarding task 'Develop prototype for login system', I've made significant progress but have hit a snag with third-party API compatibility. Could use a brainstorm session.\\\\n\\\\nThanks,\\\\nYuki\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000149\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
I need to get rid of all my emails from nia from the last 4 days. Can you do delete them?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"nia\", \"date_min\": \"2023-11-26\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000066\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nia.johnson@atlas.com\", \"subject\": \"Update on project checkpoint\", \"sent_datetime\": \"2023-11-28 10:57:50\", \"body\": \"Hi Sam,\\\\n\\\\nI'm reaching out to discuss our upcoming project checkpoint. Can we schedule a meeting to go over the details?\\\\n\\\\nThanks,\\\\nNia\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000066\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX	  **Meta Query**:
Delete all emails from [sender] within the last [natural_language_time_period] days.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email and the time period from the user query. Convert the natural language time period into a start and end date.",
    "outputs": [
      "sender_email",
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_email}",
      "date_min": "${time_min}",
      "date_max": "${time_max}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "For each email in the `matching_emails` list, generate a delete email action.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX+  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
If I don't have any meetings scheduled with aisha in the next 3 days, send them an email titled 'Catch up soon?' saying 'We have not caught up in a while - can you send some availability over next week?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"aisha\", \"time_min\": \"2023-11-30 00:00:00\", \"time_max\": \"2023-12-03 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000225\", \"event_name\": \"Risk Management Forum\", \"participant_email\": \"aisha.chen@atlas.com\", \"event_start\": \"2023-11-30 12:30:00\", \"duration\": \"120\"}, {\"event_id\": \"00000252\", \"event_name\": \"brainstorming session\", \"participant_email\": \"aisha.chen@atlas.com\", \"event_start\": \"2023-12-01 15:00:00\", \"duration\": \"120\"}]"
  }
]
```

**Sample2**:
**Query**:
Did I already schedule a meeting with leila in the next 3 days? If not, send them an email titled 'Catch up soon?' saying 'We have not caught up in a while - can you send some availability over next week?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"Leila\", \"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-03 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"Leila\", \"subject\": \"Catch up soon?\", \"body\": \"We have not caught up in a while - can you send some availability over next week?\"}}"
  },
  {
    "from": "observation",
    "value": "\"Invalid recipient email address.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u     }(hh
hX  **Meta Query**:
Check if there are any meetings scheduled with [participant] in the next [natural_language_time_period]. If not, send an email titled '[email_subject]' saying '[email_body]'.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract participant name, time period, email subject, and email body from the user query. Format the time period to `time_min` and `time_max` in ISO 8601 format.",
    "outputs": [
      "participant_email",
      "time_min",
      "time_max",
      "email_subject",
      "email_body"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${participant_email}",
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if `event_data` is empty. If it is, generate an email using the `email.send_email` function with the `email_subject` and `email_body`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move all of leila's unfinished tasks to the backlog?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"leila@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
I need to move all of santiago's unfinished tasks to the backlog. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s unfinished tasks to the backlog.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email from the user query.",
    "outputs": [
      "assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "In progress"
    },
    "output": "unfinished_tasks"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `unfinished_tasks` list, update the task's list_name to 'Backlog'. If the task is not in 'In progress', add it to the backlog as well.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to reassign all of santiago's in progress tasks to leila. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you reassign all of santiago's in progress tasks to fatima?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Reassign all of [user]'s tasks that are in [current_list] to [new_assignee].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new assignee email from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_assignee_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's `assigned_to_email` to the `new_assignee_email`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hXf  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to cancel my next meeting with akira. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"akira\", \"time_min\": \"2023-11-30 00:00:00\", \"time_max\": \"2023-12-01 00:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"No events found.\""
  }
]
```

**Sample2**:
**Query**:
I need to cancel all future meetings with olga. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"olga\", \"time_min\": \"2023-11-30 00:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000287\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-05 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000121\", \"event_name\": \"Quarterly Sales Review\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-07 10:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000131\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-19 11:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000287\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000121\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000131\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel all future meetings or the next meeting with [participant_name].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the participant name and determine whether to cancel all future meetings or just the next meeting from the user query.",
    "outputs": [
      "participant_name",
      "cancel_all_future",
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${participant_name}",
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_found` list, generate a call to `calendar.delete_event` with the event's `event_id`. If `cancel_all_future` is true, delete all events found. If `cancel_all_future` is false, delete only the next meeting.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX6  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Check the percent growth of average session duration since Monday and if was more than total visits make a backlog task called 'Improve total visits' for amir on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-27\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-27\": 22.333333333333332}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-27\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-27\": 6}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"amir@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of engaged users since Saturday and if was more than total visits make a backlog task called 'Improve total visits' for olga on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXK  **Meta Query**:
Check the percent growth of [metric] since [start_date] and if it was more than [comparison_metric], create a backlog task called 'Improve [comparison_metric]' for [assigned_user] on the [board_name] board with a deadline of [due_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract metric, start_date, comparison_metric, assigned_user, board_name, and due_date from the user query. Calculate the end date from the start date and due_date.",
    "outputs": [
      "metric",
      "start_date",
      "end_date",
      "comparison_metric",
      "assigned_user",
      "board_name",
      "due_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "average_session_duration_start"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "average_session_duration_end"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "total_visits_start"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "total_visits_end"
  },
  {
    "type": "dynamic",
    "instruction": "Calculate the percent growth of the [metric] and compare it with the [comparison_metric]. If [metric] growth is more than [comparison_metric], create a new task.",
    "outputs": [
      "create_task"
    ]
  },
  {
    "type": "static",
    "action": "project_management.create_task",
    "params": {
      "task_name": "Improve ${comparison_metric}",
      "assigned_to_email": "${assigned_user}",
      "list_name": "Backlog",
      "due_date": "${due_date}",
      "board": "${board_name}"
    },
    "output": "task_id",
    "if": "${create_task}"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
please plot the distribution of the total visits metric on October 20
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-20\", \"time_max\": \"2023-10-20\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-20_2023-10-20_total_visits_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
please plot the distribution of the total visits metric on September 9
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-09\", \"time_max\": \"2023-09-09\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-09_2023-09-09_total_visits_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX<  **Meta Query**:
Please plot the distribution of the total visits metric on [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the date from the user query and format it to YYYY-MM-DD.",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${formatted_date}",
      "time_max": "${formatted_date}",
      "value_to_plot": "total_visits",
      "plot_type": "histogram"
    },
    "output": "plot_file_path"
  }
]
```ues}h](}(hhhhu}(hh
hXO  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
fatima has a bunch of overdue tasks in the backlog. Can you move them to in progress?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"fatima@example.com\", \"list_name\": \"backlog\", \"due_date\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
Give all the overdue tasks that fatima hasn't started to santiago.
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"fatima@example.com\", \"list_name\": \"To Do\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are overdue in the [current_list] to the [new_list] or assign them to another user.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, new list name, and optional new assignee email from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list",
      "new_assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}",
      "due_date": "${formatted_due_date}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list` or assign the task to the `new_assigned_to_email` if provided.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Cancel my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
something came up. Can you cancel my meetings on Tuesday before 9?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_max\": \"2023-12-05 09:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000013\", \"event_name\": \"sync up\", \"participant_email\": \"luis.ortiz@atlas.com\", \"event_start\": \"2023-08-01 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000275\", \"event_name\": \"process review\", \"participant_email\": \"fatima.khan@atlas.com\", \"event_start\": \"2023-08-01 11:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000098\", \"event_name\": \"Data Security and Compliance Training\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-08-02 11:00:00\", \"duration\": \"30\"}, {\"event_id\": \"00000190\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-08-02 11:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000071\", \"event_name\": \"daily stand-up\", \"participant_email\": \"kofi.mensah@atlas.com\", \"event_start\": \"2023-08-02 13:30:00\", \"duration\": \"30\"}]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX]  **Meta Query**:
Cancel all meetings [user] has on [natural_language_date] before [time].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, date, and time from the user query and format the date to YYYY-MM-DD and time to HH:MM:SS.",
    "outputs": [
      "user_email",
      "formatted_date",
      "formatted_time"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "participant_email": "${user_email}",
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} ${formatted_time}"
    },
    "output": "events_to_cancel"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_to_cancel` list, generate a tool call to delete the event using the `calendar.delete_event` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move all of kofi's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of amir's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"amir@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```uesg     }h](}(hhhhu}(hh
hXpC  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
If engaged users was less than 1 at any time since November 16 make a backlog task called 'Improve engaged users' on the front-end board with a deadline of next Friday for the person with the most completed front end tasks
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 5, \"2023-11-17\": 3, \"2023-11-18\": 2, \"2023-11-19\": 7, \"2023-11-20\": 10, \"2023-11-21\": 5, \"2023-11-22\": 7, \"2023-11-23\": 2, \"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  }
]
```

**Sample2**:
**Query**:
If engaged users was more than 11 at any time since October 23 make a backlog task 'Improve engaged users' for yuki on the front-end board with a deadline of next Friday otherwise send them an email titled 'Recent engaged users' saying 'I noticed engaged users has been stable, nice work!' 
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-10-23\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-23\": 4, \"2023-10-24\": 10, \"2023-10-25\": 0, \"2023-10-26\": 3, \"2023-10-27\": 4, \"2023-10-28\": 5, \"2023-10-29\": 10, \"2023-10-30\": 5, \"2023-10-31\": 4, \"2023-11-01\": 5, \"2023-11-02\": 5, \"2023-11-03\": 7, \"2023-11-04\": 6, \"2023-11-05\": 8, \"2023-11-06\": 4, \"2023-11-07\": 6, \"2023-11-08\": 7, \"2023-11-09\": 8, \"2023-11-10\": 8, \"2023-11-11\": 4, \"2023-11-12\": 7, \"2023-11-13\": 1, \"2023-11-14\": 9, \"2023-11-15\": 7, \"2023-11-16\": 5, \"2023-11-17\": 3, \"2023-11-18\": 2, \"2023-11-19\": 7, \"2023-11-20\": 10, \"2023-11-21\": 5, \"2023-11-22\": 7, \"2023-11-23\": 2, \"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"yuki.tanaka@atlas.com\", \"subject\": \"Recent engaged users\", \"body\": \"I noticed engaged users has been stable, nice work!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXZ  **Meta Query**:
If the number of engaged users was [comparison_operator] [threshold] at any time in the specified time period, create a backlog task for [task_assignee] on the [board_name] board, otherwise send an email to [email_recipient] with a message based on the condition.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the comparison operator, threshold, time period, task details, and email details from the user query.",
    "outputs": [
      "comparison_operator",
      "threshold",
      "time_min",
      "time_max",
      "task_name",
      "assigned_to_email",
      "list_name",
      "due_date",
      "board",
      "email_recipient",
      "email_subject",
      "email_body"
    ]
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "engaged_users_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the engaged users data meets the condition specified by the comparison operator and threshold. If so, generate a task using the `project_management.create_task` function with the provided task details. If not, send an email using the `email.send_email` function with the provided email details.",
    "outputs": [
      "task_id",
      "email_result"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to move all of santiago's unfinished tasks to the backlog. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of carlos's unfinished tasks to the backlog?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000086\", \"task_name\": \"Optimize database query for content delivery\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Progress\", \"due_date\": \"2023-12-09\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000086\", \"field\": \"list_name\", \"new_value\": \"Backlog\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXy  **Meta Query**:
Move all of [user]'s unfinished tasks to the backlog.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email from the user query.",
    "outputs": [
      "assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "In progress"
    },
    "output": "tasks_in_progress"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_in_progress` list, update the task's list_name to 'Backlog'.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Cancel my meetings on Tuesday after 3
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-11-28 15:00:00\", \"time_max\": \"2023-11-28 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"No events found.\""
  }
]
```

**Sample2**:
**Query**:
something came up. Can you cancel my meetings on Friday before 11:30?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-01 11:30:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000091\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX@  **Meta Query**:
Can you cancel my meetings on [day_of_week] [after/before] [time]?

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the day of the week, time, and direction (after/before) from the user query. Convert the extracted day and time into a specific date range in ISO 8601 format.",
    "outputs": [
      "formatted_time_min",
      "formatted_time_max"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_time_min}",
      "time_max": "${formatted_time_max}"
    },
    "output": "events_to_cancel"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_to_cancel` list, generate a tool call to delete the event using the `calendar.delete_event` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
If average session duration is more than 10% lower than it was on Saturday, make a line plot of it since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-25\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 20.857142857142858}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332, \"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  }
]
```

**Sample2**:
**Query**:
Is average session duration more than 10% lower than it was on Wednesday? If so, please plot it as a line chart since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check if the average session duration is more than [percentage] lower than it was on [specific_date]. If so, plot the average session duration as a line chart since then.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the specific date and the percentage value from the user query.",
    "outputs": [
      "specific_date",
      "percentage"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${specific_date}",
      "time_max": "${specific_date}"
    },
    "output": "average_duration_on_specific_date"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${specific_date} 00:00:00",
      "time_max": "2099-12-31 23:59:59"
    },
    "output": "average_duration_since_specific_date"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the average session duration since the specific date is more than [percentage] lower than the average session duration on the specific date. If so, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `average_session_duration`.",
    "outputs": [
      "should_plot",
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Was average session duration on monday more than 3% lower than it was the previous monday? If so, please plot it as a line chart
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-20\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-20\": 28.923076923076923, \"2023-11-21\": 19.90909090909091, \"2023-11-22\": 20.5, \"2023-11-23\": 9.571428571428571, \"2023-11-24\": 21.88888888888889, \"2023-11-25\": 20.857142857142858, \"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-20\", \"time_max\": \"2023-11-27\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"line\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-20_2023-11-27_session_duration_seconds_line.png\""
  }
]
```

**Sample2**:
**Query**:
If average session duration on sunday was more than 2% lower than it was the previous sunday, make a line plot of it over that period.
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-19\", \"time_max\": \"2023-11-19\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-19\": 23.9}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Was the [metric] on [day_of_week] more than [percentage]% [lower/upper] than it was the previous [day_of_week]? If so, please plot it as a line chart over the specified period.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric, day of the week, percentage, and comparison operator from the user query. Calculate the time range based on the extracted day of the week and percentage. Output the metric, day of the week, percentage, comparison operator, and time range.",
    "outputs": [
      "metric",
      "day_of_week",
      "percentage",
      "comparison_operator",
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "session_duration_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the metric for the specified day of the week is more than the percentage specified in the comparison operator compared to the previous week's same day. If the condition is met, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to the extracted metric.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hXC  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Change the name of the last event on December 19 to casual catch-up
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-19 00:00:00\", \"time_max\": \"2023-12-19 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000096\", \"event_name\": \"annual summary\", \"participant_email\": \"lena.schmidt@atlas.com\", \"event_start\": \"2023-12-19 10:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000131\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-19 11:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000020\", \"event_name\": \"Project Initiation Meeting\", \"participant_email\": \"nia.johnson@atlas.com\", \"event_start\": \"2023-12-19 14:00:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.update_event\", \"params\": {\"event_id\": \"00000020\", \"field\": \"event_name\", \"new_value\": \"casual catch-up\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event updated successfully.\""
  }
]
```

**Sample2**:
**Query**:
Change the name of the last event on December 4 to weekly summary
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-04 00:00:00\", \"time_max\": \"2023-12-04 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000137\", \"event_name\": \"process review\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-04 09:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000109\", \"event_name\": \"project debrief\", \"participant_email\": \"kofi.mensah@atlas.com\", \"event_start\": \"2023-12-04 10:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000062\", \"event_name\": \"performance evaluation\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-12-04 14:30:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.update_event\", \"params\": {\"event_id\": \"00000062\", \"field\": \"event_name\", \"new_value\": \"weekly summary\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Change the name of the last event on [natural_language_date] to [new_event_name].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the natural language date and new event name from the user query. Format the natural language date to YYYY-MM-DD.",
    "outputs": [
      "formatted_date",
      "new_event_name"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the last event from the `event_data` list.",
    "outputs": [
      "last_event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.update_event",
    "params": {
      "event_id": "${last_event_id}",
      "field": "event_name",
      "new_value": "${new_event_name}"
    },
    "output": "update_result"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Can you plot the distribution of both total visits and average session duration between October 12 and November 6??
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-06\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-12_2023-11-06_total_visits_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-06\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-12_2023-11-06_session_duration_seconds_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
I need a histogram of average session duration and engaged users between November 3 and November 19
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-03\", \"time_max\": \"2023-11-19\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-03_2023-11-19_session_duration_seconds_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-11-03\", \"time_max\": \"2023-11-19\", \"value_to_plot\": \"user_engaged\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-11-03_2023-11-19_user_engaged_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u|     }(hh
hX  **Meta Query**:
Plot the distribution of [metric_1] and [metric_2] between [start_date] and [end_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metrics to plot (metric_1 and metric_2), start_date, and end_date from the user query.",
    "outputs": [
      "metric_1",
      "metric_2",
      "start_date",
      "end_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${end_date}",
      "value_to_plot": "${metric_1}",
      "plot_type": "histogram"
    },
    "output": "plot_file_path_1"
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${end_date}",
      "value_to_plot": "${metric_2}",
      "plot_type": "histogram"
    },
    "output": "plot_file_path_2"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
All my emails from yuki from the last 3 days need to be deleted. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"yuki\", \"date_min\": \"2023-11-27\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "\"No emails found.\""
  }
]
```

**Sample2**:
**Query**:
I need to get rid of all my emails from nia from the last 4 days. Can you do delete them?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"nia\", \"date_min\": \"2023-11-26\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000066\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nia.johnson@atlas.com\", \"subject\": \"Update on project checkpoint\", \"sent_datetime\": \"2023-11-28 10:57:50\", \"body\": \"Hi Sam,\\\\n\\\\nI'm reaching out to discuss our upcoming project checkpoint. Can we schedule a meeting to go over the details?\\\\n\\\\nThanks,\\\\nNia\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000066\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete all emails from [sender] within the last [natural_language_time_period].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's name and the time period from the user query. Convert the natural language time period to a start and end date in ISO 8601 format.",
    "outputs": [
      "sender",
      "date_min",
      "date_max"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender}",
      "date_min": "${date_min}",
      "date_max": "${date_max}"
    },
    "output": "found_emails"
  },
  {
    "type": "dynamic",
    "instruction": "For each email in the `found_emails` list, generate a delete_email function call with the email ID.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
All my emails from yuki from the last 3 days need to be deleted. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"yuki\", \"date_min\": \"2023-11-27\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "\"No emails found.\""
  }
]
```

**Sample2**:
**Query**:
Delete my last email from anaya
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Anaya\", \"date_min\": \"2023-11-01\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000166\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Task Update on Fix alignment issue in settings page\", \"sent_datetime\": \"2023-11-29 13:19:14\", \"body\": \"Hi Sam,\\\\n\\\\nRegarding task 'Fix alignment issue in settings page', I've made significant progress but have hit a snag with UI responsiveness. Could use a brainstorm session.\\\\n\\\\nCheers,\\\\nAnaya\"}, {\"email_id\": \"00000456\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on process review\", \"sent_datetime\": \"2023-11-27 13:32:00\", \"body\": \"Hey Sam,\\\\n\\\\nReminder about the process review next week. Let's make sure we're all prepared.\\\\n\\\\nCheers,\\\\nAnaya\"}, {\"email_id\": \"00000281\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on status briefing\", \"sent_datetime\": \"2023-11-22 12:16:17\", \"body\": \"Hey Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the status briefing. Looking forward to your feedback.\\\\n\\\\nI also wanted to share some exciting news about our upcoming team-building event. We've been planning a fun and engaging day for everyone, and I'm confident it will be a great opportunity for everyone to unwindd and bond with their colleagues. I'll be sending out more details soon, so keep an eye out for that!\\\\n\\\\nThanks,\\\\nAnaya\"}, {\"email_id\": \"00000414\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on weekly summary\", \"sent_datetime\": \"2023-11-22 10:53:33\", \"body\": \"Hi Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the weekly summary. Looking forward to your feedback.\\\\n\\\\nBest,\\\\nAnaya\"}, {\"email_id\": \"00000120\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on Board of Directors Conclave\", \"sent_datetime\": \"2023-11-21 13:26:29\", \"body\": \"Hey Sam,\\\\n\\\\nEncountered a few challenges while working on the Board of Directors Conclave. Could use your advice.\\\\n\\\\nThanks,\\\\nAnaya\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000166\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete emails from [sender] based on [criteria].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email address and the deletion criteria (e.g., date range, specific email) from the user query.",
    "outputs": [
      "sender_email",
      "deletion_criteria"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_email}",
      "date_min": "${deletion_criteria.date_min}",
      "date_max": "${deletion_criteria.date_max}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "For each email in `matching_emails`, extract the `email_id` and delete each email using the `email.delete_email` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hXb1  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
If engaged users was less than 1 at any time since November 16 make a backlog task called 'Improve engaged users' on the front-end board with a deadline of next Friday for the person with the most completed front end tasks
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 5, \"2023-11-17\": 3, \"2023-11-18\": 2, \"2023-11-19\": 7, \"2023-11-20\": 10, \"2023-11-21\": 5, \"2023-11-22\": 7, \"2023-11-23\": 2, \"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of average session duration since Sunday and if was more than engaged users make a backlog task called 'Improve engaged users' for chenwei on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 2}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve engaged users\", \"assigned_to_email\": \"chenwei@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check a specific metric within a given time range and if it meets certain criteria, create a task for a specified user on a given board.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric to check, time range, criteria, and task details (task name, assigned to email, list name, due date, board) from the user query.",
    "outputs": [
      "metric",
      "time_min",
      "time_max",
      "criteria",
      "task_name",
      "assigned_to_email",
      "list_name",
      "due_date",
      "board"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_metric_data",
    "params": {
      "metric": "${metric}",
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "metric_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the metric data meets the specified criteria. If so, create a task using the provided task details.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX*  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move all of aisha's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"aisha@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of aisha's overdue tasks in the backlog to in progress?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"aisha@example.com\", \"list_name\": \"backlog\", \"due_date\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user's email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX6  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
fatima has a bunch of overdue tasks in the backlog. Can you move them to in progress?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"fatima@example.com\", \"list_name\": \"backlog\", \"due_date\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you reassign all of santiago's in progress tasks to fatima?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX>  **Meta Query**:
Reassign or move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, new list name, and any other necessary parameters from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list",
      "other_params"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}",
      "other_params": "${other_params}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX;  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
if fatima hasn't sent me any emails in the past 3 days, schedule a half hour meeting with them for Monday at 9:30 and call it 'Catch up with fatima'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"fatima\", \"date_min\": \"2023-11-27\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000119\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"fatima.khan@atlas.com\", \"subject\": \"Task Update on Fix alignment issue in profile page\", \"sent_datetime\": \"2023-11-30 12:47:42\", \"body\": \"Hey Sam,\\\\n\\\\nI've been assigned 'Fix alignment issue in profile page'. Excited to work on this and confident it will greatly improve our security protocols.\\\\n\\\\nRegards,\\\\nFatima\"}, {\"email_id\": \"00000118\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"fatima.khan@atlas.com\", \"subject\": \"Task Update on Design logo for website\", \"sent_datetime\": \"2023-11-28 13:06:17\", \"body\": \"Dear Sam,\\\\n\\\\nRegarding task 'Design logo for website', I've made significant progress but have hit a snag with database integration. Could use a brainstorm session.\\\\n\\\\nCheers,\\\\nFatima\"}]"
  }
]
```

**Sample2**:
**Query**:
can you check if fatima has any overdue tasks? If so, book a 30 minute meeting with them called 'Catch up on overdue tasks' at the earliest time I'm free tomorrow
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"fatima@example.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Perform an action based on the condition of user-defined queries involving email and task checks. If the condition is met, schedule a meeting with the specified details.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user-defined conditions and actions from the query, such as the recipient email, search period, and meeting details.",
    "outputs": [
      "recipient_email",
      "search_period",
      "meeting_details",
      "action_type",
      "check_type"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${recipient_email}",
      "date_min": "${formatted_date_min}",
      "date_max": "${formatted_date_max}"
    },
    "output": "email_search_results"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the recipient has sent any emails within the specified period. If no emails are found, proceed to schedule a meeting.",
    "outputs": [
      "meeting_required"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${recipient_email}",
      "due_date": "${formatted_due_date}"
    },
    "output": "task_search_results"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the recipient has any overdue tasks. If overdue tasks are found, proceed to schedule a meeting.",
    "outputs": [
      "meeting_required"
    ]
  },
  {
    "type": "static",
    "action": "calendar.create_event",
    "params": {
      "event_name": "${meeting_details.event_name}",
      "participant_email": "${recipient_email}",
      "event_start": "${meeting_details.event_start}",
      "duration": "${meeting_details.duration}"
    },
    "output": "event_id"
  }
]
```ues}h](}(hhhhu}(hh
hX)  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
Forward my most recent email from kofi to jinsoo
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"kofi\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000259\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Task Update on Create wireframe for homepage\", \"sent_datetime\": \"2023-11-22 15:22:52\", \"body\": \"Hey Sam,\\\\n\\\\nStarting on 'Create wireframe for homepage' today. Any preliminary thoughts or resources you recommend before I dive in?\\\\n\\\\nThanks,\\\\nKofi\"}, {\"email_id\": \"00000331\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Update on project runway briefing\", \"sent_datetime\": \"2023-11-20 11:02:16\", \"body\": \"Hey Sam,\\\\n\\\\nReminder about the project runway briefing next week. Let's make sure we're all prepared.\\\\n\\\\nBest,\\\\nKofi\"}, {\"email_id\": \"00000277\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Task Update on Implement payment gateway API\", \"sent_datetime\": \"2023-11-18 10:48:40\", \"body\": \"Sam,\\\\n\\\\nStarting on 'Implement payment gateway API' today. Any preliminary thoughts or resources you recommend before I dive in?\\\\n\\\\nI've been meaning to discuss the recent changes in our project timelines. We've had to make some adjustments to accommodate new client requirements and to ensure that Were delivering the best possible results. I'll be reaching out to you soon to discuss this in more detail, so please keep an eye out for my next email.\\\\n\\\\nRegards,\\\\nKofi\"}, {\"email_id\": \"00000333\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Update on team coordination meeting\", \"sent_datetime\": \"2023-11-18 09:51:18\", \"body\": \"Sam,\\\\n\\\\nCould you provide your input on the team coordination meeting planning? Your insights would be really valuable.\\\\n\\\\nCheers,\\\\nKofi\"}, {\"email_id\": \"00000284\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Task Update on Fix alignment issue in homepage\", \"sent_datetime\": \"2023-11-17 11:50:03\", \"body\": \"Dear Sam,\\\\n\\\\nRegarding task 'Fix alignment issue in homepage', I've made significant progress but have hit a snag with third-party API compatibility. Could use a brainstorm session.\\\\n\\\\nRegards,\\\\nKofi\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.forward_email\", \"params\": {\"email_id\": \"00000259\", \"recipient\": \"jinsoo.kim@atlas.com\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email forwarded successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you forward my most recent email from jinsoo to chenwei
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"jinsoo\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000204\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"jinsoo.kim@atlas.com\", \"subject\": \"Task Update on Develop prototype for login system\", \"sent_datetime\": \"2023-11-27 10:52:03\", \"body\": \"Sam,\\\\n\\\\nCompleted task 'Develop prototype for login system' ahead of schedule. Please review and let me know if any tweaks are needed.\\\\n\\\\nI've been meaning to discuss the recent changes in our project timelines. We've had to make some adjustments to accommodate new client requirements and to ensure that Were delivering the best possible results. I'll be reaching out to you soon to discuss this in more detail, so please keep an eye out for my next email.\\\\n\\\\nThanks,\\\\nJinsoo\"}, {\"email_id\": \"00000455\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"jinsoo.kim@atlas.com\", \"subject\": \"Update on brainstorming session\", \"sent_datetime\": \"2023-11-25 15:30:29\", \"body\": \"Sam,\\\\n\\\\nReminder about the brainstorming session next week. Let's make sure we're all prepared.\\\\n\\\\nRegards,\\\\nJinsoo\"}, {\"email_id\": \"00000028\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"jinsoo.kim@atlas.com\", \"subject\": \"Update on Project Initiation Meeting\", \"sent_datetime\": \"2023-11-25 13:48:26\", \"body\": \"Hi Sam,\\\\n\\\\nThanks for the invite. Looking forward to it!\\\\n\\\\nCheers,\\\\nJinsoo\"}, {\"email_id\": \"00000220\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"jinsoo.kim@atlas.com\", \"subject\": \"Task Update on Add authentication for email notification\", \"sent_datetime\": \"2023-11-05 14:55:20\", \"body\": \"Dear Sam,\\\\n\\\\nI've been assigned 'Add authentication for email notification'. Excited to work on this and confident it will greatly improve our backend efficiency.\\\\n\\\\nRegards,\\\\nJinsoo\"}, {\"email_id\": \"00000177\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"jinsoo.kim@atlas.com\", \"subject\": \"Task Update on Design UI for landing page\", \"sent_datetime\": \"2023-10-29 13:33:47\", \"body\": \"Dear Sam,\\\\n\\\\nI've been assigned 'Design UI for landing page'. Excited to work on this and confident it will greatly improve our user experience.\\\\n\\\\nCheers,\\\\nJinsoo\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.forward_email\", \"params\": {\"email_id\": \"00000204\", \"recipient\": \"chenwei.zhang@atlas.com\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email forwarded successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
uU     }(hh
hX]  **Meta Query**:
Forward my most recent email from [sender] to [recipient].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email and recipient's email from the user query.",
    "outputs": [
      "sender_email",
      "recipient_email"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_email}",
      "date_max": "${formatted_date}"
    },
    "output": "recent_emails"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the email_id of the most recent email from the `recent_emails` list.",
    "outputs": [
      "email_id"
    ]
  },
  {
    "type": "static",
    "action": "email.forward_email",
    "params": {
      "email_id": "${email_id}",
      "recipient": "${recipient_email}"
    },
    "output": "forward_result"
  }
]
```ues}h](}(hhhhu}(hh
hX5  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if total visits was more than 21 at any time since October 12? If so, make a backlog task called 'Improve total visits' for dmitri on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-12\": 9, \"2023-10-13\": 8, \"2023-10-14\": 10, \"2023-10-15\": 14, \"2023-10-16\": 9, \"2023-10-17\": 15, \"2023-10-18\": 16, \"2023-10-19\": 9, \"2023-10-20\": 8, \"2023-10-21\": 15, \"2023-10-22\": 13, \"2023-10-23\": 8, \"2023-10-24\": 21, \"2023-10-25\": 7, \"2023-10-26\": 10, \"2023-10-27\": 11, \"2023-10-28\": 17, \"2023-10-29\": 14, \"2023-10-30\": 12, \"2023-10-31\": 9, \"2023-11-01\": 16, \"2023-11-02\": 13, \"2023-11-03\": 11, \"2023-11-04\": 9, \"2023-11-05\": 10, \"2023-11-06\": 10, \"2023-11-07\": 13, \"2023-11-08\": 11, \"2023-11-09\": 14, \"2023-11-10\": 11, \"2023-11-11\": 10, \"2023-11-12\": 12, \"2023-11-13\": 8, \"2023-11-14\": 13, \"2023-11-15\": 11, \"2023-11-16\": 7, \"2023-11-17\": 7, \"2023-11-18\": 6, \"2023-11-19\": 10, \"2023-11-20\": 13, \"2023-11-21\": 11, \"2023-11-22\": 10, \"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"dmitri@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of average session duration since Monday and if was more than total visits make a backlog task called 'Improve total visits' for amir on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-27\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-27\": 22.333333333333332}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-27\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-27\": 6}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"amir@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Determine if a specific condition regarding the analytics data is met (e.g., total visits exceeds a threshold, average session duration meets a criterion), and if true, create a task for a specific user in a project management system.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the time range, the metric to check (e.g., total visits, average session duration), the comparison operator, and the threshold from the user query. Also extract the task details like task name, assignee email, list name, due date, and board name.",
    "outputs": [
      "time_min",
      "time_max",
      "metric_to_check",
      "comparison_operator",
      "threshold",
      "task_name",
      "assigned_to_email",
      "list_name",
      "due_date",
      "board"
    ]
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "total_visits_data"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "average_session_duration_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the metric data meets the condition specified by the comparison operator and threshold. If so, create a project management task for the specified assignee with the provided details.",
    "outputs": [
      "task_creation_status"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX &  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
Delete my last email from kofi
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"kofi\", \"date_min\": \"2023-11-01\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000259\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Task Update on Create wireframe for homepage\", \"sent_datetime\": \"2023-11-22 15:22:52\", \"body\": \"Hey Sam,\\\\n\\\\nStarting on 'Create wireframe for homepage' today. Any preliminary thoughts or resources you recommend before I dive in?\\\\n\\\\nThanks,\\\\nKofi\"}, {\"email_id\": \"00000331\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Update on project runway briefing\", \"sent_datetime\": \"2023-11-20 11:02:16\", \"body\": \"Hey Sam,\\\\n\\\\nReminder about the project runway briefing next week. Let's make sure we're all prepared.\\\\n\\\\nBest,\\\\nKofi\"}, {\"email_id\": \"00000277\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Task Update on Implement payment gateway API\", \"sent_datetime\": \"2023-11-18 10:48:40\", \"body\": \"Sam,\\\\n\\\\nStarting on 'Implement payment gateway API' today. Any preliminary thoughts or resources you recommend before I dive in?\\\\n\\\\nI've been meaning to discuss the recent changes in our project timelines. We've had to make some adjustments to accommodate new client requirements and to ensure that Were delivering the best possible results. I'll be reaching out to you soon to discuss this in more detail, so please keep an eye out for my next email.\\\\n\\\\nRegards,\\\\nKofi\"}, {\"email_id\": \"00000333\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Update on team coordination meeting\", \"sent_datetime\": \"2023-11-18 09:51:18\", \"body\": \"Sam,\\\\n\\\\nCould you provide your input on the team coordination meeting planning? Your insights would be really valuable.\\\\n\\\\nCheers,\\\\nKofi\"}, {\"email_id\": \"00000284\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"kofi.mensah@atlas.com\", \"subject\": \"Task Update on Fix alignment issue in homepage\", \"sent_datetime\": \"2023-11-17 11:50:03\", \"body\": \"Dear Sam,\\\\n\\\\nRegarding task 'Fix alignment issue in homepage', I've made significant progress but have hit a snag with third-party API compatibility. Could use a brainstorm session.\\\\n\\\\nRegards,\\\\nKofi\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000259\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Delete my last email from nadia
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"nadia\", \"date_min\": \"2023-11-23\", \"date_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000479\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nadia.moreau@atlas.com\", \"subject\": \"Update on Health & Wellness Expo\", \"sent_datetime\": \"2023-11-29 12:32:17\", \"body\": \"Hey Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the Health & Wellness Expo. Looking forward to your feedback.\\\\n\\\\nCheers,\\\\nNadia\"}, {\"email_id\": \"00000070\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nadia.moreau@atlas.com\", \"subject\": \"Update on Diversity & Inclusion Workshop\", \"sent_datetime\": \"2023-11-26 10:25:56\", \"body\": \"Sam,\\\\n\\\\nI have some ideas for the Diversity & Inclusion Workshop that I'd like to run by you. When are you free?\\\\n\\\\nCheers,\\\\nNadia\"}, {\"email_id\": \"00000460\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"nadia.moreau@atlas.com\", \"subject\": \"Update on project progress update\", \"sent_datetime\": \"2023-11-24 13:50:00\", \"body\": \"Sam,\\\\n\\\\nReminder about the project progress update next week. lets make sure we're all prepared.\\\\n\\\\nI also wanted to share some exciting news about our upcoming team-building event. We've been planning a fun and engaging day for everyone, and I'm confident it will be a great opportunity for everyone to unwind and bond with their colleagues. I'll be sending out more details soon, so keep an eye out for that!\\\\n\\\\nThanks,\\\\nNadia\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.delete_email\", \"params\": {\"email_id\": \"00000479\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete my last email from [sender].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email address from the user query.",
    "outputs": [
      "sender_email"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${sender_email}",
      "date_min": "${formatted_date_min}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "From the list of matching emails, select the most recent one and extract its email_id.",
    "outputs": [
      "email_id_to_delete"
    ]
  },
  {
    "type": "static",
    "action": "email.delete_email",
    "params": {
      "email_id": "${email_id_to_delete}"
    },
    "output": "delete_result"
  }
]
```ues}h](}(hhhhu}(hh
hXv  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Move all customers that haven't responded to a proposal for the consulting product in 6 weeks to lost in the crm
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Consulting\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-14\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
We need to move all customers that haven't responded to a proposal for the software product in 6 weeks to lost. Can you update the CRM?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-14\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all customers that haven't responded to a proposal for the [product_interest] product in [weeks] weeks to lost in the CRM.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the product interest and number of weeks from the user query and calculate the maximum follow-up date. Output the product interest and maximum follow-up date.",
    "outputs": [
      "product_interest",
      "follow_up_by_max"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "product_interest": "${product_interest}",
      "status": "Proposal",
      "follow_up_by_max": "${follow_up_by_max}"
    },
    "output": "customers_to_update"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer in the `customers_to_update` list, update the customer's status to 'Lost' using the `customer_relationship_manager.update_customer` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hXA  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if carlos has any overdue tasks? If so, send them an email titled 'Overdue tasks' saying 'You have a few overdue tasks - can you update me on them?'. Otherwise email them with 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000013\", \"task_name\": \"Implement payment gateway API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000043\", \"task_name\": \"Update Vue.js to latest version\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"carlos.rodriguez@atlas.com\", \"subject\": \"Good work this sprint\", \"body\": \"Nice work keeping on top of your tasks this sprint!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

**Sample2**:
**Query**:
I think dmitri might have some overdue tasks. Can you check and if so, book a half hour meeting with them called 'Catch up on overdue tasks' at the earliest time I'm free tomorrow and send them an email titled 'Discuss overdue tasks' saying 'I noticed you have a few overdue tasks - let's catch up tomorrow.' Otherwise email them with 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000069\", \"task_name\": \"Implement report generation API\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000020\", \"task_name\": \"Optimize database query for user management\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000056\", \"task_name\": \"Add authentication for third-party login\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000006\", \"task_name\": \"Add authentication for cloud storage\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"dmitri.ivanov@atlas.com\", \"subject\": \"Good work this sprint\", \"body\": \"Nice work keeping on top of your tasks this sprint!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check if [user] has any overdue tasks. If they do, send an email titled 'Overdue tasks' with a message regarding the overdue tasks. Otherwise, send an email titled 'Good work this sprint' congratulating them on managing their tasks well.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract user email from the user query.",
    "outputs": [
      "assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "due_date": "2023-11-29"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the `tasks_found` list is not empty. If not empty, generate an email content mentioning overdue tasks, otherwise, generate a congratulatory email content.",
    "outputs": [
      "email_subject",
      "email_body"
    ]
  },
  {
    "type": "static",
    "action": "email.send_email",
    "params": {
      "recipient": "${assigned_to_email}",
      "subject": "${email_subject}",
      "body": "${email_body}"
    },
    "output": "email_result"
  }
]
```ues}h](}(hhhhu}(hh
hX"  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to cancel my next meeting with aisha. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"aisha\", \"time_min\": \"2023-11-30 09:00:00\", \"time_max\": \"2023-11-30 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000225\", \"event_name\": \"Risk Management Forum\", \"participant_email\": \"aisha.chen@atlas.com\", \"event_start\": \"2023-11-30 12:30:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000225\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
I need to cancel my next meeting with fatima. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"fatima\", \"time_min\": \"2023-11-30 09:00:00\", \"time_max\": \"2023-11-30 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000200\", \"event_name\": \"Annual Budget Planning Session\", \"participant_email\": \"fatima.khan@atlas.com\", \"event_start\": \"2023-11-30 09:30:00\", \"duration\": \"60\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000200\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX)  **Meta Query**:
Cancel the next meeting with [person].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the person's name from the user query.",
    "outputs": [
      "person_name"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${person_name}",
      "time_min": "${formatted_date} 09:00:00",
      "time_max": "${formatted_date} 18:00:00"
    },
    "output": "event_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the earliest event from the `event_data` list",
    "outputs": [
      "event_id"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id}"
    },
    "output": "event_deletion_result"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Delete my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you cancel my first meeting on December 1
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-01 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}, {\"event_id\": \"00000237\", \"event_name\": \"project checkpoint\", \"participant_email\": \"nia.johnson@atlas.com\", \"event_start\": \"2023-12-01 12:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000093\", \"event_name\": \"retrospective meeting\", \"participant_email\": \"raj.patel@atlas.com\", \"event_start\": \"2023-12-01 13:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000261\", \"event_name\": \"performance evaluation\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-01 14:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
ua     }(hh
hXF  **Meta Query**:
Delete the first meeting of the user on [natural_language_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the date from the user query and format it to YYYY-MM-DD.",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the event_id of the first event in the `events_found` list.",
    "outputs": [
      "event_id_to_delete"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id_to_delete}"
    },
    "output": "deletion_result"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to cancel my next meeting with aisha. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"aisha\", \"time_min\": \"2023-11-30 09:00:00\", \"time_max\": \"2023-11-30 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000225\", \"event_name\": \"Risk Management Forum\", \"participant_email\": \"aisha.chen@atlas.com\", \"event_start\": \"2023-11-30 12:30:00\", \"duration\": \"120\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000225\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
I need to cancel all future meetings with olga. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"olga\", \"time_min\": \"2023-11-30 00:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000287\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-05 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000121\", \"event_name\": \"Quarterly Sales Review\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-07 10:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000131\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-19 11:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000287\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000121\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000131\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel all future meetings with [participant_name] or cancel the next meeting with [participant_name].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the participant name from the user query and set the `participant_email` variable by searching the calendar for the participant's email.",
    "outputs": [
      "participant_email"
    ]
  },
  {
    "type": "dynamic",
    "instruction": "Determine whether the query asks to cancel the next meeting or all future meetings with the participant. If the query is to cancel the next meeting, set `time_max` to the current date and time. If the query is to cancel all future meetings, set `time_max` to the maximum possible date.",
    "outputs": [
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${participant_email}",
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_found` list, generate a delete event call for the event with the `event_id`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you forward all the emails from anaya last week about 'Update on Board of Directors Conclave' to nadia
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Update on Board of Directors Conclave\", \"date_min\": \"2023-11-20\", \"date_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000120\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on Board of Directors Conclave\", \"sent_datetime\": \"2023-11-21 13:26:29\", \"body\": \"Hey Sam,\\\\n\\\\nEncountered a few challenges while working on the Board of Directors Conclave. Could use your advice.\\\\n\\\\nThanks,\\\\nAnaya\"}, {\"email_id\": \"00000346\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"anaya.patel@atlas.com\", \"subject\": \"Update on Board of Directors Conclave\", \"sent_datetime\": \"2023-11-20 14:26:53\", \"body\": \"Hey Sam,\\\\n\\\\nEncountered a few challenges while working on the Board of Directors Conclave. Could use your advice.\\\\n\\\\nThanks,\\\\nAnaya\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.forward_email\", \"params\": {\"email_id\": \"00000120\", \"recipient\": \"nadia.moreau@atlas.com\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email forwarded successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.forward_email\", \"params\": {\"email_id\": \"00000346\", \"recipient\": \"nadia.moreau@atlas.com\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email forwarded successfully.\""
  }
]
```

**Sample2**:
**Query**:
nia needs all the emails from sofia last week about 'Update on Risk Management Forum'. Can you forward them?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Update on Risk Management Forum\", \"date_min\": \"2023-11-20\", \"date_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000173\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"sofia.santos@atlas.com\", \"subject\": \"Update on Risk Management Forum\", \"sent_datetime\": \"2023-11-23 11:19:59\", \"body\": \"Hey Sam,\\\\n\\\\nReminder about the Risk Management Forum next week. Let's make sure we're all prepared.\\\\n\\\\nCheers,\\\\nSofia\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.forward_email\", \"params\": {\"email_id\": \"00000173\", \"recipient\": \"nia.johnson@atlas.com\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email forwarded successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Forward all emails from [sender] within the past [natural_language_time_period] that contain the phrase [search_phrase] to [recipient].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email, recipient's email, search phrase, and natural language time period from the user query. Calculate the start and end date of the time period and output them in ISO 8601 format.",
    "outputs": [
      "sender_email",
      "recipient_email",
      "search_phrase",
      "date_min",
      "date_max"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${search_phrase}",
      "date_min": "${date_min}",
      "date_max": "${date_max}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "For each email in the `matching_emails` list, generate a call to forward the email to the recipient.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Delete my meetings on Friday before 12
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-12-01 00:00:00\", \"time_max\": \"2023-12-01 12:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000091\", \"event_name\": \"Year-End Performance Assessment\", \"participant_email\": \"leila.azizi@atlas.com\", \"event_start\": \"2023-12-01 10:00:00\", \"duration\": \"120\"}, {\"event_id\": \"00000237\", \"event_name\": \"project checkpoint\", \"participant_email\": \"nia.johnson@atlas.com\", \"event_start\": \"2023-12-01 12:00:00\", \"duration\": \"60\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000091\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
something came up. Can you cancel my meetings on Tuesday before 9?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_max\": \"2023-12-05 09:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000013\", \"event_name\": \"sync up\", \"participant_email\": \"luis.ortiz@atlas.com\", \"event_start\": \"2023-08-01 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000275\", \"event_name\": \"process review\", \"participant_email\": \"fatima.khan@atlas.com\", \"event_start\": \"2023-08-01 11:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000098\", \"event_name\": \"Data Security and Compliance Training\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-08-02 11:00:00\", \"duration\": \"30\"}, {\"event_id\": \"00000190\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-08-02 11:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000071\", \"event_name\": \"daily stand-up\", \"participant_email\": \"kofi.mensah@atlas.com\", \"event_start\": \"2023-08-02 13:30:00\", \"duration\": \"30\"}]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Delete my meetings on [day] before [time].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract day and time from the user query and format them to YYYY-MM-DD and HH:MM:SS respectively.",
    "outputs": [
      "formatted_day",
      "formatted_time"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "",
      "time_min": "${formatted_day} 00:00:00",
      "time_max": "${formatted_day} ${formatted_time}:00"
    },
    "output": "events_to_delete"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_to_delete` list, generate a delete event tool call.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need a histogram of total visits and average session duration between September 29 and November 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-29\", \"time_max\": \"2023-11-13\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-29_2023-11-13_total_visits_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-09-29\", \"time_max\": \"2023-11-13\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-09-29_2023-11-13_session_duration_seconds_histogram.png\""
  }
]
```

**Sample2**:
**Query**:
Can you plot the distribution of both total visits and average session duration between October 12 and November 6??
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-06\", \"value_to_plot\": \"total_visits\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-12_2023-11-06_total_visits_histogram.png\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.create_plot\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-06\", \"value_to_plot\": \"session_duration_seconds\", \"plot_type\": \"histogram\"}}"
  },
  {
    "from": "observation",
    "value": "\"plots/2023-10-12_2023-11-06_session_duration_seconds_histogram.png\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Plot histograms for total visits and average session duration between [start_date] and [end_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the start and end dates from the user query and format them to YYYY-MM-DD format.",
    "outputs": [
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "value_to_plot": "total_visits",
      "plot_type": "histogram"
    },
    "output": "total_visits_histogram"
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "value_to_plot": "session_duration_seconds",
      "plot_type": "histogram"
    },
    "output": "session_duration_histogram"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to cancel my next meeting with fatima. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"fatima\", \"time_min\": \"2023-11-30 09:00:00\", \"time_max\": \"2023-11-30 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000200\", \"event_name\": \"Annual Budget Planning Session\", \"participant_email\": \"fatima.khan@atlas.com\", \"event_start\": \"2023-11-30 09:30:00\", \"duration\": \"60\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000200\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
I need to cancel all future meetings with olga. Can you do that for me please?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"olga\", \"time_min\": \"2023-11-30 00:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000165\", \"event_name\": \"Corporate Social Responsibility Initiative\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-01 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000287\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-05 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000121\", \"event_name\": \"Quarterly Sales Review\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-07 10:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000131\", \"event_name\": \"Innovation and Creativity Hackathon\", \"participant_email\": \"olga.petrova@atlas.com\", \"event_start\": \"2023-12-19 11:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000165\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000287\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000121\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000131\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXP  **Meta Query**:
Cancel all future meetings with [person]'s name.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the name of the person from the user query.",
    "outputs": [
      "person_name"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${person_name}",
      "time_min": "2023-11-30 00:00:00"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in `events_found`, generate a tool call to delete the event.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX2  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Check the percent growth of average session duration since Sunday and if was more than engaged users make a backlog task called 'Improve engaged users' for chenwei on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 2}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve engaged users\", \"assigned_to_email\": \"chenwei@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
can you check the percent growth of engaged users since Wednesday? If it grew by more than total visits make a task called 'Improve total visits' on the front-end backlog for olga that's due next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"olga@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX	  **Meta Query**:
Check the percent growth of [metric] since [start_date] and if it meets a specified condition, create a task called '[task_name]' for [assigned_to_email] on the [board]'s [list_name] with a deadline of [due_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric, start_date, end_date, comparison_operator, comparison_value, task_name, assigned_to_email, list_name, board, and due_date from the user query. If the comparison is not provided, set a default value. Ensure that the due_date is a valid ISO 8601 date.",
    "outputs": [
      "metric",
      "start_date",
      "end_date",
      "comparison_operator",
      "comparison_value",
      "task_name",
      "assigned_to_email",
      "list_name",
      "board",
      "due_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "average_session_duration_start_date"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "average_session_duration_end_date"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "engaged_users_start_date"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "engaged_users_end_date"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "total_visits_start_date"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "total_visits_end_date"
  },
  {
    "type": "dynamic",
    "instruction": "Calculate the percent growth of the [metric] from [start_date] to [end_date]. If the calculated percent growth meets the specified condition (based on the comparison_operator and comparison_value), generate a task with the specified details using the `project_management.create_task` function.",
    "outputs": [
      "task_id"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX2  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Check the percent growth of average session duration since Sunday and if was more than engaged users make a backlog task called 'Improve engaged users' for chenwei on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-26\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 2}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve engaged users\", \"assigned_to_email\": \"chenwei@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of average session duration since Friday. If it grew by more than engaged users, plot both lines since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 21.88888888888889, \"2023-11-25\": 20.857142857142858, \"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332, \"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u     }(hh
hX&  **Meta Query**:
Check the percent growth of [metric] since [start_date]. If it grew by more than [comparison_metric], plot both lines since then or create a task based on the condition.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract metric, comparison metric, start date, and condition from the user query. Output the metric, comparison metric, start date, and condition.",
    "outputs": [
      "metric",
      "comparison_metric",
      "start_date",
      "condition"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "current_metric_value"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${current_date}"
    },
    "output": "current_metric_values"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${current_date}"
    },
    "output": "comparison_metric_values"
  },
  {
    "type": "dynamic",
    "instruction": "Calculate the percent growth of the current metric and compare it with the comparison metric. If the condition is met, generate a task or plot both lines.",
    "outputs": [
      "action_needed"
    ]
  },
  {
    "type": "static",
    "action": "project_management.create_task",
    "params": {
      "task_name": "Improve engaged users",
      "assigned_to_email": "chenwei@example.com",
      "list_name": "Backlog",
      "due_date": "${next_friday}",
      "board": "Front end"
    },
    "output": "task_result",
    "if": "${action_needed} == 'create_task'"
  },
  {
    "type": "static",
    "action": "analytics.create_plot",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${current_date}",
      "value_to_plot": "${metric}",
      "plot_type": "line"
    },
    "output": "plot_result",
    "if": "${action_needed} == 'plot'"
  }
]
```ues}h](}(hhhhu}(hh
hX7  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if total visits was more than 21 at any time since October 12? If so, make a backlog task called 'Improve total visits' for dmitri on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-10-12\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-10-12\": 9, \"2023-10-13\": 8, \"2023-10-14\": 10, \"2023-10-15\": 14, \"2023-10-16\": 9, \"2023-10-17\": 15, \"2023-10-18\": 16, \"2023-10-19\": 9, \"2023-10-20\": 8, \"2023-10-21\": 15, \"2023-10-22\": 13, \"2023-10-23\": 8, \"2023-10-24\": 21, \"2023-10-25\": 7, \"2023-10-26\": 10, \"2023-10-27\": 11, \"2023-10-28\": 17, \"2023-10-29\": 14, \"2023-10-30\": 12, \"2023-10-31\": 9, \"2023-11-01\": 16, \"2023-11-02\": 13, \"2023-11-03\": 11, \"2023-11-04\": 9, \"2023-11-05\": 10, \"2023-11-06\": 10, \"2023-11-07\": 13, \"2023-11-08\": 11, \"2023-11-09\": 14, \"2023-11-10\": 11, \"2023-11-11\": 10, \"2023-11-12\": 12, \"2023-11-13\": 8, \"2023-11-14\": 13, \"2023-11-15\": 11, \"2023-11-16\": 7, \"2023-11-17\": 7, \"2023-11-18\": 6, \"2023-11-19\": 10, \"2023-11-20\": 13, \"2023-11-21\": 11, \"2023-11-22\": 10, \"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"dmitri@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of engaged users since Saturday and if was more than total visits make a backlog task called 'Improve total visits' for olga on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX?  **Meta Query**:
Check if [metric] was [comparison] [threshold] at any time since [time_period]. If so, create a backlog task called [task_name] for [assigned_to_email] on the [board] board with a deadline of [due_date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract metric, comparison operator, threshold, time period, task name, assigned to email, board, and due date from the user query.",
    "outputs": [
      "metric",
      "comparison_operator",
      "threshold",
      "time_min",
      "time_max",
      "task_name",
      "assigned_to_email",
      "board",
      "due_date"
    ]
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "total_visits_data"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "engaged_users_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the total visits data or engaged users data meets the condition specified by the comparison operator and threshold. If so, generate a backlog task using the `project_management.create_task` function.",
    "outputs": [
      "task_id"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX"  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to move all of Lena's customers that are in the qualified stage and interested in hardware to lost. Can you make that change in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"assigned_to_email\": \"lena@example.com\", \"status\": \"Qualified\", \"product_interest\": \"Hardware\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000201\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000202\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000203\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  }
]
```

**Sample2**:
**Query**:
I need to move all of Nadia's customers that are in the qualified stage and interested in training to lost. Can you make that change in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"status\": \"Qualified\", \"product_interest\": \"Training\", \"assigned_to_email\": \"nadia@example.com\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000201\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000202\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000203\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000204\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.update_customer\", \"params\": {\"customer_id\": \"00000205\", \"field\": \"status\", \"new_value\": \"Lost\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer not found.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXh  **Meta Query**:
Move all of [user]'s customers that are in the [status] stage and interested in [product_interest] to [new_status].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, status, product interest, and new status from the user query.",
    "outputs": [
      "assigned_to_email",
      "status",
      "product_interest",
      "new_status"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "status": "${status}",
      "product_interest": "${product_interest}"
    },
    "output": "matching_customers"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer in the `matching_customers` list, update the customer's status to the `new_status`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Check the percent growth of average session duration since Friday. If it grew by more than engaged users, plot both lines since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 21.88888888888889, \"2023-11-25\": 20.857142857142858, \"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332, \"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-24\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-24\": 5, \"2023-11-25\": 8, \"2023-11-26\": 2, \"2023-11-27\": 4, \"2023-11-28\": 8, \"2023-11-29\": 5}"
  }
]
```

**Sample2**:
**Query**:
If average session duration is more than 10% lower than it was on Saturday, make a line plot of it since then
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-25\", \"time_max\": \"2023-11-25\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-25\": 20.857142857142858}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-26\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-26\": 25.0, \"2023-11-27\": 22.333333333333332, \"2023-11-28\": 20.31578947368421, \"2023-11-29\": 20.5}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX<  **Meta Query**:
Determine if the [metric] since [start_date] meets a specified condition, and if so, plot the [metric] as a line chart.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric, start date, and condition from the user query. The start date is a natural language date like 'Friday', and the condition can be a comparison operation such as 'more than 10%' or 'less than 5%'. The metric can be 'average session duration' or 'engaged users'. Output the metric, start date, and condition.",
    "outputs": [
      "metric",
      "start_date",
      "condition"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${formatted_end_date}"
    },
    "output": "average_session_duration_data"
  },
  {
    "type": "static",
    "action": "analytics.engaged_users_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${formatted_end_date}"
    },
    "output": "engaged_users_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the [metric] meets the condition specified in the user query. If the metric is 'average session duration', compare it to a baseline date provided in the condition. If the metric is 'engaged users', compare it with another metric or a threshold provided in the condition. If the condition is met, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to the relevant metric.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX"<  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you reassign all of santiago's in progress tasks to fatima?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move any of fatima's tasks that are in review to completed?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"list_name\": \"In Review\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000203\", \"task_name\": \"Update brand colors in website\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000249\", \"task_name\": \"Design logo for e-commerce platform\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000279\", \"task_name\": \"Design logo for website\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-27\", \"board\": \"Design\"}, {\"task_id\": \"00000165\", \"task_name\": \"Design UI for landing page\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-28\", \"board\": \"Front end\"}, {\"task_id\": \"00000113\", \"task_name\": \"Design UI for landing page\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Front end\"}, {\"task_id\": \"00000265\", \"task_name\": \"Update brand colors in e-commerce platform\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Design\"}, {\"task_id\": \"00000183\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-29\", \"board\": \"Front end\"}, {\"task_id\": \"00000276\", \"task_name\": \"Improve UX of onboarding process\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-30\", \"board\": \"Design\"}, {\"task_id\": \"00000070\", \"task_name\": \"Implement search functionality API\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-11-30\", \"board\": \"Back end\"}, {\"task_id\": \"00000092\", \"task_name\": \"Fix bug in payment processing module\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000035\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"fatima.khan@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000067\", \"task_name\": \"Add authentication for payment gateway\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000076\", \"task_name\": \"Implement user profile management API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-01\", \"board\": \"Back end\"}, {\"task_id\": \"00000186\", \"task_name\": \"Add animation to navigation bar\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000115\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"anaya.patel@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000272\", \"task_name\": \"Update brand colors in website\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Design\"}, {\"task_id\": \"00000198\", \"task_name\": \"Add animation to navigation bar\", \"assigned_to_email\": \"anaya.patel@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-02\", \"board\": \"Front end\"}, {\"task_id\": \"00000116\", \"task_name\": \"Fix alignment issue in settings page\", \"assigned_to_email\": \"santiago.martinez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-03\", \"board\": \"Front end\"}, {\"task_id\": \"00000219\", \"task_name\": \"Update brand colors in mobile app\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Design\"}, {\"task_id\": \"00000157\", \"task_name\": \"Design UI for profile page\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Front end\"}, {\"task_id\": \"00000120\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-04\", \"board\": \"Front end\"}, {\"task_id\": \"00000007\", \"task_name\": \"Fix bug in content delivery module\", \"assigned_to_email\": \"yuki.tanaka@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Back end\"}, {\"task_id\": \"00000270\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Design\"}, {\"task_id\": \"00000199\", \"task_name\": \"Design UI for dashboard\", \"assigned_to_email\": \"santiago.martinez@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-05\", \"board\": \"Front end\"}, {\"task_id\": \"00000191\", \"task_name\": \"Integrate Stripe payment API with frontend\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Front end\"}, {\"task_id\": \"00000296\", \"task_name\": \"Improve UX of feedback submission\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Design\"}, {\"task_id\": \"00000252\", \"task_name\": \"Design logo for mobile app\", \"assigned_to_email\": \"amir.ali@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-06\", \"board\": \"Design\"}, {\"task_id\": \"00000025\", \"task_name\": \"Fix bug in payment processing module\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Back end\"}, {\"task_id\": \"00000271\", \"task_name\": \"Design logo for website\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}, {\"task_id\": \"00000217\", \"task_name\": \"Design logo for blog\", \"assigned_to_email\": \"kofi.mensah@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-07\", \"board\": \"Design\"}, {\"task_id\": \"00000292\", \"task_name\": \"Design logo for admin panel\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-08\", \"board\": \"Design\"}, {\"task_id\": \"00000080\", \"task_name\": \"Optimize database query for report generation\", \"assigned_to_email\": \"aisha.chen@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-09\", \"board\": \"Back end\"}, {\"task_id\": \"00000127\", \"task_name\": \"Implement responsive layout for homepage\", \"assigned_to_email\": \"chenwei.zhang@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Front end\"}, {\"task_id\": \"00000230\", \"task_name\": \"Improve UX of feedback submission\", \"assigned_to_email\": \"jinsoo.kim@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Design\"}, {\"task_id\": \"00000053\", \"task_name\": \"Fix bug in data storage module\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-10\", \"board\": \"Back end\"}, {\"task_id\": \"00000094\", \"task_name\": \"Add authentication for file upload\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000126\", \"task_name\": \"Integrate Google Maps API with frontend\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Front end\"}, {\"task_id\": \"00000012\", \"task_name\": \"Update Django to latest version\", \"assigned_to_email\": \"yuki.tanaka@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-11\", \"board\": \"Back end\"}, {\"task_id\": \"00000280\", \"task_name\": \"Improve UX of checkout process\", \"assigned_to_email\": \"luis.ortiz@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Design\"}, {\"task_id\": \"00000118\", \"task_name\": \"Add animation to dropdown menu\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Front end\"}, {\"task_id\": \"00000264\", \"task_name\": \"Develop prototype for login system\", \"assigned_to_email\": \"amir.ali@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Design\"}, {\"task_id\": \"00000073\", \"task_name\": \"Optimize database query for data export\", \"assigned_to_email\": \"dmitri.ivanov@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-12\", \"board\": \"Back end\"}, {\"task_id\": \"00000197\", \"task_name\": \"Fix alignment issue in dashboard\", \"assigned_to_email\": \"nia.johnson@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Front end\"}, {\"task_id\": \"00000121\", \"task_name\": \"Integrate Twilio SMS API with frontend\", \"assigned_to_email\": \"leila.azizi@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Front end\"}, {\"task_id\": \"00000228\", \"task_name\": \"Create wireframe for dashboard\", \"assigned_to_email\": \"olga.petrova@atlas.com\", \"list_name\": \"In Review\", \"due_date\": \"2023-12-13\", \"board\": \"Design\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.update_task\", \"params\": {\"task_id\": \"00000035\", \"field\": \"list_name\", \"new_value\": \"Completed\"}}"
  },
  {
    "from": "observation",
    "value": "\"Task updated successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXm  **Meta Query**:
Move all tasks of a specific user from one list to another or update tasks in a specific list.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, new list name, and any additional parameters from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list",
      "additional_params"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list` or perform any other required updates as specified in `additional_params`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX#  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}]

**Sample1**:
**Query**:
Make bar charts of referral and social media over the last 4 weeks if we got more traffic from referral than social media
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-02\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-02\": 1, \"2023-11-03\": 0, \"2023-11-04\": 1, \"2023-11-05\": 1, \"2023-11-06\": 1, \"2023-11-07\": 2, \"2023-11-08\": 1, \"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-02\", \"time_max\": \"2023-11-29\", \"traffic_source\": \"social media\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-02\": 5, \"2023-11-03\": 3, \"2023-11-04\": 2, \"2023-11-05\": 4, \"2023-11-06\": 2, \"2023-11-07\": 5, \"2023-11-08\": 3, \"2023-11-09\": 1, \"2023-11-10\": 2, \"2023-11-11\": 3, \"2023-11-12\": 2, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 1, \"2023-11-16\": 1, \"2023-11-17\": 1, \"2023-11-18\": 2, \"2023-11-19\": 1, \"2023-11-20\": 2, \"2023-11-21\": 0, \"2023-11-22\": 3, \"2023-11-23\": 0, \"2023-11-24\": 4, \"2023-11-25\": 4, \"2023-11-26\": 0, \"2023-11-27\": 1, \"2023-11-28\": 5, \"2023-11-29\": 4}"
  }
]
```

**Sample2**:
**Query**:
did we get more traffic from referral than direct during the last 3 weeks? If so, make bar charts of both over that period
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-09\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"referral\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-09\": 2, \"2023-11-10\": 0, \"2023-11-11\": 2, \"2023-11-12\": 1, \"2023-11-13\": 1, \"2023-11-14\": 3, \"2023-11-15\": 0, \"2023-11-16\": 2, \"2023-11-17\": 1, \"2023-11-18\": 1, \"2023-11-19\": 2, \"2023-11-20\": 2, \"2023-11-21\": 1, \"2023-11-22\": 0, \"2023-11-23\": 1, \"2023-11-24\": 1, \"2023-11-25\": 1, \"2023-11-26\": 1, \"2023-11-27\": 0, \"2023-11-28\": 0, \"2023-11-29\": 0}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.traffic_source_count\", \"params\": {\"time_min\": \"2023-11-09\", \"time_max\": \"2023-11-30\", \"traffic_source\": \"direct\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-09\": 9, \"2023-11-10\": 8, \"2023-11-11\": 5, \"2023-11-12\": 8, \"2023-11-13\": 6, \"2023-11-14\": 5, \"2023-11-15\": 9, \"2023-11-16\": 3, \"2023-11-17\": 4, \"2023-11-18\": 3, \"2023-11-19\": 5, \"2023-11-20\": 8, \"2023-11-21\": 8, \"2023-11-22\": 4, \"2023-11-23\": 5, \"2023-11-24\": 3, \"2023-11-25\": 9, \"2023-11-26\": 4, \"2023-11-27\": 5, \"2023-11-28\": 12, \"2023-11-29\": 5}"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Determine if traffic from [source_1] is greater than traffic from [source_2] over a specified time period. If so, generate bar charts for both sources over that period.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the time period, [source_1], and [source_2] from the user query. Calculate start and end dates based on the natural language time period and format them as ISO 8601 dates.",
    "outputs": [
      "time_min",
      "time_max",
      "source_1",
      "source_2"
    ]
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "traffic_source": "${source_1}"
    },
    "output": "source_1_visits"
  },
  {
    "type": "static",
    "action": "analytics.traffic_source_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}",
      "traffic_source": "${source_2}"
    },
    "output": "source_2_visits"
  },
  {
    "type": "dynamic",
    "instruction": "Compare the total visits from [source_1] and [source_2]. If [source_1] has more visits than [source_2], generate bar charts for both sources using the `analytics.create_plot` function with the `value_to_plot` set to `total_visits` and `plot_type` set to `bar`. Output the file paths of the generated plots.",
    "outputs": [
      "plot_file_path_source_1",
      "plot_file_path_source_2"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hXo  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Delete my first meeting on December 13
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-13 00:00:00\", \"time_max\": \"2023-12-13 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000256\", \"event_name\": \"project progress update\", \"participant_email\": \"santiago.martinez@atlas.com\", \"event_start\": \"2023-12-13 09:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000100\", \"event_name\": \"performance evaluation\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-13 10:00:00\", \"duration\": \"60\"}, {\"event_id\": \"00000120\", \"event_name\": \"Diversity & Inclusion Workshop\", \"participant_email\": \"jinsoo.kim@atlas.com\", \"event_start\": \"2023-12-13 14:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000152\", \"event_name\": \"Machine Learning Chat\", \"participant_email\": \"anaya.patel@atlas.com\", \"event_start\": \"2023-12-13 15:30:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000256\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
can you cancel my first meeting on December 8
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-08 00:00:00\", \"time_max\": \"2023-12-08 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000236\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-08 10:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000213\", \"event_name\": \"IT Systems Update Briefing\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-08 14:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000185\", \"event_name\": \"strategic planning meeting\", \"participant_email\": \"chenwei.zhang@atlas.com\", \"event_start\": \"2023-12-08 15:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000236\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u<!     }(hh
hXL  **Meta Query**:
Delete the first event on [date].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the target date from the user query and format it to YYYY-MM-DD",
    "outputs": [
      "formatted_date"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${formatted_date} 00:00:00",
      "time_max": "${formatted_date} 23:59:59"
    },
    "output": "events_list"
  },
  {
    "type": "dynamic",
    "instruction": "From the `events_list`, extract the event_id of the first event and set it as `event_id_to_delete`.",
    "outputs": [
      "event_id_to_delete"
    ]
  },
  {
    "type": "static",
    "action": "calendar.delete_event",
    "params": {
      "event_id": "${event_id_to_delete}"
    },
    "output": "deletion_result"
  }
]
```ues}h](}(hhhhu}(hh
hXZ*  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
If I don't have any meetings scheduled with aisha in the next 3 days, send them an email titled 'Catch up soon?' saying 'We have not caught up in a while - can you send some availability over next week?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"aisha\", \"time_min\": \"2023-11-30 00:00:00\", \"time_max\": \"2023-12-03 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000225\", \"event_name\": \"Risk Management Forum\", \"participant_email\": \"aisha.chen@atlas.com\", \"event_start\": \"2023-11-30 12:30:00\", \"duration\": \"120\"}, {\"event_id\": \"00000252\", \"event_name\": \"brainstorming session\", \"participant_email\": \"aisha.chen@atlas.com\", \"event_start\": \"2023-12-01 15:00:00\", \"duration\": \"120\"}]"
  }
]
```

**Sample2**:
**Query**:
I need to check if I have any meetings scheduled with amir in the next 2 days. If not, send them an email titled 'Catch up soon?' saying 'We have not caught up in a while - can you send some availability over next week?'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"amir\", \"time_min\": \"2023-11-30 00:00:00\", \"time_max\": \"2023-12-02 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000261\", \"event_name\": \"performance evaluation\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-01 14:30:00\", \"duration\": \"30\"}]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check if there are any meetings scheduled with [contact] in the next [time_period]. If not, send an email titled 'Catch up soon?' with the body 'We have not caught up in a while - can you send some availability over next week?'

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the contact name and time period from the user query and convert the time period to ISO 8601 format for `time_min` and `time_max`.",
    "outputs": [
      "contact",
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${contact}",
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "Check if any events are found in `events_found`. If no events are found, generate an email to be sent with the recipient as the `contact` email and the subject and body as specified in the query.",
    "outputs": [
      "email_sent"
    ]
  }
]
```ues}h](}(hhhhu}(hh
hX)  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
something came up. Can you cancel my meetings on Tuesday before 9?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_max\": \"2023-12-05 09:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000013\", \"event_name\": \"sync up\", \"participant_email\": \"luis.ortiz@atlas.com\", \"event_start\": \"2023-08-01 09:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000275\", \"event_name\": \"process review\", \"participant_email\": \"fatima.khan@atlas.com\", \"event_start\": \"2023-08-01 11:30:00\", \"duration\": \"90\"}, {\"event_id\": \"00000098\", \"event_name\": \"Data Security and Compliance Training\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-08-02 11:00:00\", \"duration\": \"30\"}, {\"event_id\": \"00000190\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"yuki.tanaka@atlas.com\", \"event_start\": \"2023-08-02 11:30:00\", \"duration\": \"30\"}, {\"event_id\": \"00000071\", \"event_name\": \"daily stand-up\", \"participant_email\": \"kofi.mensah@atlas.com\", \"event_start\": \"2023-08-02 13:30:00\", \"duration\": \"30\"}]"
  }
]
```

**Sample2**:
**Query**:
Cancel my meetings on Tuesday after 3
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-11-28 15:00:00\", \"time_max\": \"2023-11-28 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"No events found.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel my meetings on [day] [time_range].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the day and time range from the user query and format them to ISO 8601 date and time. Output the start and end time of the time range as `time_min` and `time_max`.",
    "outputs": [
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `events_found` list, delete the event using the `calendar.delete_event` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hXy  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
Casey White is no longer a customer. Can you delete them from the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"customer_name\": \"Casey White\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"customer_id\": \"00000167\", \"assigned_to_email\": \"akira.sato@atlas.com\", \"customer_name\": \"Casey White\", \"customer_email\": \"casey.white@flexlogics\", \"customer_phone\": \"887-728-7499\", \"last_contact_date\": \"2023-11-19\", \"product_interest\": \"Services\", \"status\": \"Lead\", \"follow_up_by\": \"2023-12-06\", \"notes\": NaN}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.delete_customer\", \"params\": {\"customer_id\": \"00000167\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Rahul Moore is no longer a customer. Can you delete them from the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"customer_name\": \"Rahul Moore\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"customer_id\": \"00000073\", \"assigned_to_email\": \"akira.sato@atlas.com\", \"customer_name\": \"Rahul Moore\", \"customer_email\": \"rahul.moore@bluepointdesigns\", \"customer_phone\": NaN, \"last_contact_date\": \"2023-11-13\", \"product_interest\": \"Consulting\", \"status\": \"Lost\", \"follow_up_by\": \"2023-11-27\", \"notes\": \"2023-10-02: Saw the demo. 2023-11-28: On holiday. 2023-11-11: Had a call. \"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.delete_customer\", \"params\": {\"customer_id\": \"00000073\"}}"
  },
  {
    "from": "observation",
    "value": "\"Customer deleted successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX]  **Meta Query**:
Delete a customer from the CRM based on their name.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the customer name from the user query.",
    "outputs": [
      "customer_name"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "customer_name": "${customer_name}"
    },
    "output": "customer_data"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the customer_id from the `customer_data` and delete the customer using the `customer_relationship_manager.delete_customer` function.",
    "outputs": [
      "customer_id"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.delete_customer",
    "params": {
      "customer_id": "${customer_id}"
    },
    "output": "delete_result"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
We've decided we don't need any any more health & wellness expo meetings. Can you cancel all future ones?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"health & wellness expo\", \"time_min\": \"2023-11-30 00:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000082\", \"event_name\": \"Health & Wellness Expo\", \"participant_email\": \"sofia.santos@atlas.com\", \"event_start\": \"2023-12-14 11:00:00\", \"duration\": \"90\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000082\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
We've decided we don't need any any more weekly summary meetings. Can you cancel all future ones?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"Summary Meeting\", \"time_min\": \"2023-11-30 00:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"No events found.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel all future events based on the provided event name or keyword.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the event name or keyword from the user's query.",
    "outputs": [
      "event_name_or_keyword"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "query": "${event_name_or_keyword}",
      "time_min": "2023-11-30 00:00:00"
    },
    "output": "future_events"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in the `future_events` list, generate a tool call to delete the event using its `event_id`.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX2  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'analytics.create_plot', 'description': 'Plots the analytics data for a given time range and value.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\nvalue_to_plot : str, optional\n    Value to plot. Available values are: "total_visits", "session_duration_seconds", "user_engaged", "visits_direct", "visits_referral", "visits_search_engine", "visits_social_media"\nplot_type : str, optional\n    Type of plot. Can be "bar", "line", "scatter" or "histogram"\n\nReturns\n-------\nfile_path : str\n    Path to the plot file. Filename is {{time_min}}_{{time_max}}_{{value_to_plot}}_{{plot_type}}.png.\n\nExamples\n--------\n>>> analytics.create_plot("2023-10-01", "2023-12-31", "total_visits")\n"plots/2023-10-01_2023-12-31_total_visits.png"', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'value_to_plot': {'default': None, 'title': 'Value To Plot'}, 'plot_type': {'default': None, 'title': 'Plot Type'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.engaged_users_count', 'description': 'Returns the number of engaged users within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\nengaged_users : dict\n    Number of engaged users in the specified time range.\n\nExamples\n--------\n>>> analytics.engaged_users_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 2, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_average_session_duration', 'description': 'Returns the average session duration within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\naverage_session_duration : float\n    Average session duration in seconds in the specified time range.\n\nExamples\n--------\n>>> analytics.get_average_session_duration("2023-10-01", "2023-10-06")\n{{"2023-10-01": 10.0, "2023-10-02": 20.5, "2023-10-03": 32.8, "2023-10-04": 40.2, "2023-10-05": 5.3, "2023-10-06": 53.0}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.get_visitor_information_by_id', 'description': 'Returns the analytics data for a given visitor ID.\n\nParameters\n----------\nvisitor_id : str, optional\n    ID of the visitor.\n\nReturns\n-------\nvisitor_data : dict\n    Analytics data for the given visitor ID.\n\nExamples\n--------\n>>> analytics.get_visitor_information_by_id("000")\n{{"date_of_visit": "2023-10-01", "visitor_id": "000", "page_views": "3", "session_duration_seconds": "10.0", "traffic_source": "search engine", "user_engaged": "False"}}', 'parameters': {'type': 'object', 'properties': {'visitor_id': {'default': None, 'title': 'Visitor Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.total_visits_count', 'description': 'Returns the total number of visits within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\n\nReturns\n-------\ntotal_visits : dict\n    Total number of visits in the specified time range.\n\nExamples\n--------\n>>> analytics.total_visits_count("2023-10-01", "2023-10-06")\n{{"2023-10-01": 1, "2023-10-02": 2, "2023-10-03": 3, "2023-10-04": 1, "2023-10-05": 0, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'analytics.traffic_source_count', 'description': 'Returns the number of visits from a specific traffic source within a specified time range.\n\nParameters\n----------\ntime_min : str, optional\n    Start date of the time range. Date format is "YYYY-MM-DD".\ntime_max : str, optional\n    End date of the time range. Date format is "YYYY-MM-DD".\ntraffic_source : str, optional\n    Traffic source to filter the visits. Available values are: "direct", "referral", "search engine", "social media"\n\nReturns\n-------\ntraffic_source_visits : dict\n    Number of visits from the specified traffic source in the specified time range.\n\nExamples\n--------\n>>> analytics.traffic_source_count("2023-10-01", "2023-10-06", "search engine")\n{{"2023-10-01": 0, "2023-10-02": 1, "2023-10-03": 0, "2023-10-04": 3, "2023-10-05": 2, "2023-10-06": 4}}', 'parameters': {'type': 'object', 'properties': {'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}, 'traffic_source': {'default': None, 'title': 'Traffic Source'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check the percent growth of engaged users since Wednesday? If it grew by more than total visits make a task called 'Improve total visits' on the front-end backlog for olga that's due next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.engaged_users_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 5}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-29\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-29\": 10}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"olga@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

**Sample2**:
**Query**:
Check the percent growth of average session duration since Monday and if was more than total visits make a backlog task called 'Improve total visits' for amir on the front-end board with a deadline of next Friday
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-27\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-27\": 22.333333333333332}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.get_average_session_duration\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-27\", \"time_max\": \"2023-11-27\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-27\": 6}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-30\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{}"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.create_task\", \"params\": {\"task_name\": \"Improve total visits\", \"assigned_to_email\": \"amir@example.com\", \"list_name\": \"Backlog\", \"due_date\": \"2023-12-08\", \"board\": \"Front end\"}}"
  },
  {
    "from": "observation",
    "value": "\"Assignee email not valid. Please choose from the list of team members.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Check the percent growth of [metric] since [start_date] and if it grew by more than [comparison_metric] make a backlog task called 'Improve [comparison_metric]' for [assigned_to_email] on the front-end board with a deadline of next Friday.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the metric, start date, comparison metric, and assigned_to_email from the user query. Calculate the end date as the current date.",
    "outputs": [
      "metric",
      "comparison_metric",
      "start_date",
      "end_date",
      "assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "metric_start_value"
  },
  {
    "type": "static",
    "action": "analytics.get_average_session_duration",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "metric_end_value"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${start_date}",
      "time_max": "${start_date}"
    },
    "output": "comparison_metric_start_value"
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${end_date}",
      "time_max": "${end_date}"
    },
    "output": "comparison_metric_end_value"
  },
  {
    "type": "dynamic",
    "instruction": "Calculate the percent growth of the metric and the comparison metric. If the percent growth of the metric is more than the percent growth of the comparison metric, generate a task with the name 'Improve [comparison_metric]' for [assigned_to_email] on the front-end backlog with a due date of next Friday.",
    "outputs": [
      "task_name",
      "task_due_date"
    ]
  },
  {
    "type": "static",
    "action": "project_management.create_task",
    "params": {
      "task_name": "${task_name}",
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "Backlog",
      "due_date": "${task_due_date}",
      "board": "Front end"
    },
    "output": "task_created"
  }
]
```ues}h](}(hhhhu}(hh
hX/  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you check if carlos has any overdue tasks? If so, send them an email titled 'Overdue tasks' saying 'You have a few overdue tasks - can you update me on them?'. Otherwise email them with 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000013\", \"task_name\": \"Implement payment gateway API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000043\", \"task_name\": \"Update Vue.js to latest version\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"carlos.rodriguez@atlas.com\", \"subject\": \"Good work this sprint\", \"body\": \"Nice work keeping on top of your tasks this sprint!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

**Sample2**:
**Query**:
I think carlos might have some overdue tasks. Can you check and if so, send them an email titled 'Overdue tasks' saying 'You have a few overdue tasks - can you update me on them?'. Otherwise email them with 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"due_date\": \"2023-11-29\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"task_id\": \"00000013\", \"task_name\": \"Implement payment gateway API\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}, {\"task_id\": \"00000043\", \"task_name\": \"Update Vue.js to latest version\", \"assigned_to_email\": \"carlos.rodriguez@atlas.com\", \"list_name\": \"Completed\", \"due_date\": \"2023-11-29\", \"board\": \"Back end\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.send_email\", \"params\": {\"recipient\": \"carlos.rodriguez@atlas.com\", \"subject\": \"Good work this sprint\", \"body\": \"Nice work keeping on top of your tasks this sprint!\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email sent successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hXA  **Meta Query**:
Check if [user] has any overdue tasks. If so, send them an email titled 'Overdue tasks' saying 'You have a few overdue tasks - can you update me on them?'. Otherwise, email them with 'Nice work keeping on top of your tasks this sprint!' titled 'Good work this sprint'.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract user email from the user query.",
    "outputs": [
      "assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "due_date": "2023-11-29"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the `tasks_found` list is not empty. If the list is not empty, set `email_subject` to 'Overdue tasks' and `email_body` to 'You have a few overdue tasks - can you update me on them?'. Otherwise, set `email_subject` to 'Good work this sprint' and `email_body` to 'Nice work keeping on top of your tasks this sprint!'",
    "outputs": [
      "email_subject",
      "email_body"
    ]
  },
  {
    "type": "static",
    "action": "email.send_email",
    "params": {
      "recipient": "${assigned_to_email}",
      "subject": "${email_subject}",
      "body": "${email_body}"
    },
    "output": "email_result"
  }
]
```ues}h](}(hhhhu}(hh
hX,)  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'email.delete_email', 'description': 'Deletes an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be deleted.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> email.delete_email("12345678")\n"Email deleted successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.forward_email', 'description': 'Forwards an email to the specified recipient.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be forwarded.\nrecipient : str, optional\n    Email address of the recipient.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the email was forwarded successfully.\n\nExamples\n--------\n>>> email.forward_email("12345678", "jane@example.com")\n"Email forwarded successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'recipient': {'default': None, 'title': 'Recipient'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.get_email_information_by_id', 'description': 'Retrieves specific details of an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email.\nfield : str, optional\n    Specific field to return. Available fields: "email_id", "sender", "subject", "sent_date", "body", "inbox/outbox".\n\nReturns\n-------\nemail_information : dict\n    Information of the specified email for the given ID and field.\n\nExamples\n--------\n>>> email.get_email_information_by_id("12345678", "subject")\n{{"subject": "Project Update"}}\n\n>>> email.get_email_information_by_id("12345678", "sent_date")\n{{"sent_date": "2024-01-10 09:30:00"}}', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.reply_email', 'description': 'Replies to an email by its ID.\n\nParameters\n----------\nemail_id : str, optional\n    Unique ID of the email to be replied.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being replied.\n\nExamples\n--------\n>>> email.reply_email("12345678", "Thank you for the update.")\n"Email replied successfully."', 'parameters': {'type': 'object', 'properties': {'email_id': {'default': None, 'title': 'Email Id'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.search_emails', 'description': 'Searches for emails matching the given query across subject, body, or sender fields.\nThe function matches an email if all words in the query appear in any of these fields.\n\nParameters\n----------\nquery : str, optional\n    Search query, matching terms in subject, body, or sender fields.\ndate_min : str, optional\n    Lower date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\ndate_max : str, optional\n    Upper date limit for the email\'s sent date (inclusive). Format: "YYYY-MM-DD"\n\nReturns\n-------\nemails : list\n    List of emails matching the query criteria.\n\nExamples\n--------\n>>> email.search_emails("Project Update")\n[{{"email_id": "12345678", "inbox/outbox": "inbox", "subject": "Project Update", "sender/recipient": "jane@example.com", "sent_datetime": "2024-01-10 09:30:00", "body": "Please find the project update attached."}}]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'date_min': {'default': None, 'title': 'Date Min'}, 'date_max': {'default': None, 'title': 'Date Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'email.send_email', 'description': 'Sends an email to the specified recipient.\n\nParameters\n----------\nrecipient : str, optional\n    Email address of the recipient.\nsubject : str, optional\n    Subject line of the email.\nbody : str, optional\n    Body content of the email.\n\nReturns\n-------\nmessage : str\n    Confirmation message of the email being sent.\n\nExamples\n--------\n>>> email.send_email("jane@example.com", "Meeting Reminder", "Don\'t forget our meeting at 10am tomorrow.")\n"Email sent successfully."', 'parameters': {'type': 'object', 'properties': {'recipient': {'default': None, 'title': 'Recipient'}, 'subject': {'default': None, 'title': 'Subject'}, 'body': {'default': None, 'title': 'Body'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to get back to yuki's last email about 'Update on Client Appreciation Gala' with 'Thanks for the update - I will get back to you tomorrow. Can you send the reply for me?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Update on Client Appreciation Gala\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000206\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"olga.petrova@atlas.com\", \"subject\": \"Update on Client Appreciation Gala\", \"sent_datetime\": \"2023-11-30 14:46:03\", \"body\": \"Hey Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the Client Appreciation Gala. Looking forward to your feedback.\\\\n\\\\nI've been meaning to discuss the recent changes in our project timelines. We've had to make some adjusments to accommodate new client requirements and to ensure that we're delivering the best possible results. I'll be reaching out to you soon to discuss this in more detail, so please keep an eye out for my next email.\\\\n\\\\nBest,\\\\nOlga\"}, {\"email_id\": \"00000266\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"raj.patel@atlas.com\", \"subject\": \"Update on Client Appreciation Gala\", \"sent_datetime\": \"2023-11-21 14:12:38\", \"body\": \"Hey Sam,\\\\n\\\\nEncountered a few challenges while working on the Client Appreciation Gala. Could use your advice.\\\\n\\\\nCheers,\\\\nRaj\"}, {\"email_id\": \"00000477\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"akira.sato@atlas.com\", \"subject\": \"Update on Client Appreciation Gala\", \"sent_datetime\": \"2023-11-20 10:15:37\", \"body\": \"Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the Client Appreciation Gala. Looking forward to your feedback.\\\\n\\\\nAdditionally, I wanted to touch base on some other areas we've been focusing on lately. Our team has been working tirelessly on improving our project management workflows and enhancing collaboration across departments. This effort includes adopting new tools, refining our comunication strategies, and ensuring that all team members are fully aligned with our objectives.\\\\n\\\\nCheers,\\\\nAkira\"}, {\"email_id\": \"00000234\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"yuki.tanaka@atlas.com\", \"subject\": \"Update on Client Appreciation Gala\", \"sent_datetime\": \"2023-11-15 11:20:10\", \"body\": \"Dear Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the Client Appreciation Gala. Looking forward to your feedback.\\\\n\\\\nThanks,\\\\nYuki\"}, {\"email_id\": \"00000222\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"olga.petrova@atlas.com\", \"subject\": \"Update on Client Appreciation Gala\", \"sent_datetime\": \"2023-10-26 13:42:37\", \"body\": \"Hey Sam,\\\\n\\\\nI wanted to let you know that I've completed the tasks for the Client Appreciation Gala. Looking forward to your feedback.\\\\n\\\\nI've been meaning to discuss the recent changes in our project timelines. We've had to make some adjusments to accommodate new client requirements and to ensure that we're delivering the best possible results. I'll be reaching out to you soon to discuss this in more detail, so please keep an eye out for my next email.\\\\n\\\\nBest,\\\\nOlga\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.reply_email\", \"params\": {\"email_id\": \"00000234\", \"body\": \"Thanks for the update - I will get back to you tomorrow.\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email replied successfully.\""
  }
]
```

**Sample2**:
**Query**:
Reply to yuki's last email about 'Update on Corporate Social Responsibility Initiative' with 'Thanks for the update - I will get back to you tomorrow.'
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"email.search_emails\", \"params\": {\"query\": \"Update on Corporate Social Responsibility Initiative\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"email_id\": \"00000446\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"yuki.tanaka@atlas.com\", \"subject\": \"Update on Corporate Social Responsibility Initiative\", \"sent_datetime\": \"2023-11-15 11:55:59\", \"body\": \"Dear Sam,\\\\n\\\\nEncountered a few challenges while working on the Corporate Social Responsibility Initiative. Could use your advice.\\\\n\\\\nThanks,\\\\nYuki\"}, {\"email_id\": \"00000447\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"yuki.tanaka@atlas.com\", \"subject\": \"Update on Corporate Social Responsibility Initiative\", \"sent_datetime\": \"2023-11-01 15:53:31\", \"body\": \"Dear Sam,\\\\n\\\\nEncountered a few challenges while working on the Corporate Social Responsibility Initiative. Could use your advice.\\\\n\\\\nThanks,\\\\nYuki\"}, {\"email_id\": \"00000024\", \"inbox/outbox\": \"inbox\", \"sender/recipient\": \"luis.ortiz@atlas.com\", \"subject\": \"Update on Corporate Social Responsibility Initiative\", \"sent_datetime\": \"2023-10-07 10:32:43\", \"body\": \"Hey Sam,\\\\n\\\\nReminder about the Corporate Social Responsibility Initiative next week. Let's make sure we're all prepared.\\\\n\\\\nCheers,\\\\nLuis\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"email.reply_email\", \"params\": {\"email_id\": \"00000446\", \"body\": \"Thanks for the update - I will get back to you tomorrow.\"}}"
  },
  {
    "from": "observation",
    "value": "\"Email replied successfully.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
uR     }(hh
hX  **Meta Query**:
Reply to [sender]'s last email about [email_subject] with [response_body].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the sender's email, the email subject, and the response body from the user query.",
    "outputs": [
      "sender_email",
      "email_subject",
      "response_body"
    ]
  },
  {
    "type": "static",
    "action": "email.search_emails",
    "params": {
      "query": "${email_subject}",
      "sender": "${sender_email}"
    },
    "output": "matching_emails"
  },
  {
    "type": "dynamic",
    "instruction": "Extract the email ID of the most recent email from the `matching_emails` list",
    "outputs": [
      "email_id"
    ]
  },
  {
    "type": "static",
    "action": "email.reply_email",
    "params": {
      "email_id": "${email_id}",
      "body": "${response_body}"
    },
    "output": "email_reply_result"
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I need to move all of leila's unfinished tasks to the backlog. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"leila@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"leila@example.com\", \"list_name\": \"To do\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
I need to move all of santiago's unfinished tasks to the backlog. Can you do that?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"santiago@example.com\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s unfinished tasks to the backlog.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email from the user query.",
    "outputs": [
      "assigned_to_email"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "In progress"
    },
    "output": "unfinished_tasks"
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "To do"
    },
    "output": "todo_tasks"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `unfinished_tasks` and `todo_tasks` lists, update the task's list_name to 'Backlog'. If a task is already in the backlog, it should be skipped.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX
  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.update_task', 'description': 'Updates a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\nfield : str\n    Field to update. Available fields are: "task_name", "assigned_to_email", "list_name", "due_date", "board"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> project_management.update_task("00000000", "task_name", "New Task Name")\n"Task updated successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you move all of aisha's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"aisha@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of kofi's tasks that are in progress to in review?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list` using the `project_management.update_task` function.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'calendar.create_event', 'description': 'Creates a new event.\n\nParameters\n----------\nevent_name: str, optional\n    Name of the event.\nparticipant_email: str, optional\n    Email of the participant.\nevent_start: str, optional\n    Start time of the event. Format: "YYYY-MM-DD HH:MM:SS"\nduration: str, optional\n    Duration of the event in minutes.\n\nReturns\n-------\nevent_id : str\n    ID of the newly created event.\n\nExamples\n--------\n>>> calendar.create_event("Meeting with Sam", "sam@example.com", "2021-06-01 13:00:00", "60")\n"00000000"', 'parameters': {'type': 'object', 'properties': {'event_name': {'default': None, 'title': 'Event Name'}, 'participant_email': {'default': None, 'title': 'Participant Email'}, 'event_start': {'default': None, 'title': 'Event Start'}, 'duration': {'default': None, 'title': 'Duration'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.delete_event', 'description': 'Deletes an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the deletion was successful.\n\nExamples\n--------\n>>> calendar.delete_event("00000000")\n"Event deleted successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.get_event_information_by_id', 'description': 'Returns the event for a given ID.\n\nParameters\n----------\nevent_id : str, optional\n    8-digit ID of the event.\nfield : str, optional\n    Field to return. Available fields are: "event_id", "event_name", "participant_email", "event_start", "duration"\n\nReturns\n-------\nevent : dict\n    Event information for the given ID and field.\n\n\nExamples\n--------\n>>> calendar.get_event_information_by_id("00000000", "event_name")\n{{"event_name": "Meeting with Sam"}}\n\n>>> calendar.get_event_information_by_id("00000000", "event_start")\n{{"event_start": "2021-06-01 13:00:00"}}\n\n>>> calendar.get_event_information_by_id("00000000", "duration")\n{{"duration": "60"}}', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.search_events', 'description': 'Returns the events for a given query.\n\nParameters\n----------\nquery: str, optional\n    Query to search for. Terms will be matched in the event_name and participant_email fields.\ntime_min: str, optional\n    Lower bound (inclusive) for an event\'s end time to filter by. Format: "YYYY-MM-DD HH:MM:SS"\ntime_max: str, optional\n    Upper bound (inclusive) for an event\'s start time to filter by. Format: "YYYY-MM-DD HH:MM:SS\n\nReturns\n-------\nevents : list\n    List of events matching the query. Returns at most 5 events.\n\nExamples\n--------\n>>> calendar.search_events("Sam")\n[{{"event_id": "00000000", "event_name": "Meeting with Sam", "participant_email: "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "60"}},\n{{"event_id": "00000001", "event_name": "Lunch with Sam", "participant_email": "sam@example.com", "event_start": "2021-06-01 13:00:00", "duration": "30}}"\n]', 'parameters': {'type': 'object', 'properties': {'query': {'default': '', 'title': 'Query'}, 'time_min': {'default': None, 'title': 'Time Min'}, 'time_max': {'default': None, 'title': 'Time Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'calendar.update_event', 'description': 'Updates an event.\n\nParameters\n----------\nevent_id: str, optional\n    8-digit ID of the event.\nfield: str, optional\n    Field to update.\nnew_value: str, optional\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating whether the update was successful.\n\nExamples\n--------\n>>> calendar.update_event("00000000", "event_name", "New Event Name")\n"Event updated successfully."', 'parameters': {'type': 'object', 'properties': {'event_id': {'default': None, 'title': 'Event Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
can you cancel my first meeting on December 8
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"time_min\": \"2023-12-08 00:00:00\", \"time_max\": \"2023-12-08 23:59:59\"}}"
  },
  {
    "from": "observation",
    "value": "[{\"event_id\": \"00000236\", \"event_name\": \"Product Launch Analysis\", \"participant_email\": \"dmitri.ivanov@atlas.com\", \"event_start\": \"2023-12-08 10:30:00\", \"duration\": \"60\"}, {\"event_id\": \"00000213\", \"event_name\": \"IT Systems Update Briefing\", \"participant_email\": \"amir.ali@atlas.com\", \"event_start\": \"2023-12-08 14:00:00\", \"duration\": \"90\"}, {\"event_id\": \"00000185\", \"event_name\": \"strategic planning meeting\", \"participant_email\": \"chenwei.zhang@atlas.com\", \"event_start\": \"2023-12-08 15:30:00\", \"duration\": \"30\"}]"
  },
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.delete_event\", \"params\": {\"event_id\": \"00000236\"}}"
  },
  {
    "from": "observation",
    "value": "\"Event deleted successfully.\""
  }
]
```

**Sample2**:
**Query**:
Cancel my meetings on Tuesday after 3
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"calendar.search_events\", \"params\": {\"query\": \"\", \"time_min\": \"2023-11-28 15:00:00\", \"time_max\": \"2023-11-28 18:00:00\"}}"
  },
  {
    "from": "observation",
    "value": "\"No events found.\""
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Cancel all meetings on [natural_language_date] that meet the [criteria].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the date and criteria for filtering meetings from the user query. Output the date in ISO format (YYYY-MM-DD) and any necessary parameters for filtering meetings.",
    "outputs": [
      "formatted_date",
      "time_min",
      "time_max"
    ]
  },
  {
    "type": "static",
    "action": "calendar.search_events",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "events_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each event in `events_found`, generate a call to `calendar.delete_event` with the event_id.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hX~  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'customer_relationship_manager.add_customer', 'description': 'Adds a new customer record.\n\nParameters\n----------\ncustomer_name : str\n    Name of the customer.\nassigned_to_email : str\n    Email address of the person assigned to the customer.\nstatus : str\n    Current status of the customer. One of: "Qualified", "Won", "Lost", "Lead", "Proposal"\ncustomer_email : str, optional\n    Email address of the customer.\ncustomer_phone : str, optional\n    Phone number of the customer.\nlast_contact_date : str, optional\n    The last date the customer was contacted. Format: "YYYY-MM-DD"\nproduct_interest : str, optional\n    Product interest of the customer. One of: "Software", "Hardware", "Services", "Consulting", "Training"\nnotes : str, optional, optional\n    Notes about the customer.\nfollow_up_by : str, optional\n    Date for the next follow up. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomer_id : str\n    ID of the new customer.\n\nExamples\n--------\n>>> crm.add_customer("Sam Smith", "sam@example.com", "Lead", "sam.smith@example.com", "123-456-7890", "2023-01-01", "Software")\n"00000201"', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'status': {'default': None, 'title': 'Status'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'customer_phone': {'default': None, 'title': 'Customer Phone'}, 'last_contact_date': {'default': None, 'title': 'Last Contact Date'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'notes': {'default': '', 'title': 'Notes'}, 'follow_up_by': {'default': None, 'title': 'Follow Up By'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.delete_customer', 'description': 'Deletes a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> crm.delete_customer("00000001")\n"Customer deleted successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.search_customers', 'description': 'Searches for customers based on the given parameters.\n\nParameters\n----------\ncustomer_name : str, optional\n    Name of the customer.\ncustomer_email : str, optional\n    Email address of the customer.\nproduct_interest : str, optional\n    Product interest of the customer.\nstatus : str, optional\n    Current status of the customer.\nassigned_to_email : str, optional\n    Email address of the person assigned to the customer.\nlast_contact_date_min : str, optional\n    Minimum last contact date. Format: "YYYY-MM-DD"\nlast_contact_date_max : str, optional\n    Maximum last contact date. Format: "YYYY-MM-DD"\nfollow_up_by_min : str, optional\n    Minimum follow up date. Format: "YYYY-MM-DD"\nfollow_up_by_max : str, optional\n    Maximum follow up date. Format: "YYYY-MM-DD"\n\nReturns\n-------\ncustomers : dict\n    Customer information for the given parameters. Returns at most 5 records.\n\nExamples\n--------\n>>> crm.search_customers(customer_name="John")\n{{"customer_id": "00000001", "assigned_to_email": "sam@example.com", "customer_name": "John Smith",\n"customer_email": "john.smith@example.com", "customer_phone": "123-456-7890", "last_contact_date": "2023-01-01",\n"product_interest": "Software", "status": "Qualified", "follow_up_by": "2023-01-15", "notes": "Had a call on 2023-01-01. "}}', 'parameters': {'type': 'object', 'properties': {'customer_name': {'default': None, 'title': 'Customer Name'}, 'customer_email': {'default': None, 'title': 'Customer Email'}, 'product_interest': {'default': None, 'title': 'Product Interest'}, 'status': {'default': None, 'title': 'Status'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'last_contact_date_min': {'default': None, 'title': 'Last Contact Date Min'}, 'last_contact_date_max': {'default': None, 'title': 'Last Contact Date Max'}, 'follow_up_by_min': {'default': None, 'title': 'Follow Up By Min'}, 'follow_up_by_max': {'default': None, 'title': 'Follow Up By Max'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'customer_relationship_manager.update_customer', 'description': 'Updates a customer record by ID.\n\nParameters\n----------\ncustomer_id : str\n    ID of the customer.\nfield : str\n    Field to update. Available fields are: "customer_name", "assigned_to_email", "customer_email", "customer_phone", "last_contact_date", "product_interest", "status", "notes", "follow_up_by"\nnew_value : str\n    New value for the field.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the update.\n\nExamples\n--------\n>>> crm.update_customer("00000001", "status", "Won")\n"Customer updated successfully."', 'parameters': {'type': 'object', 'properties': {'customer_id': {'default': None, 'title': 'Customer Id'}, 'field': {'default': None, 'title': 'Field'}, 'new_value': {'default': None, 'title': 'New Value'}}, 'required': []}}}]

**Sample1**:
**Query**:
I think there's a few customers that haven't responded to a proposal for the software product in 6 weeks. Can you move them to lost in the crm?
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Software\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-25\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
Move all customers that haven't responded to a proposal for the consulting product in 6 weeks to lost in the crm
**Workflow**:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"customer_relationship_manager.search_customers\", \"params\": {\"product_interest\": \"Consulting\", \"status\": \"Proposal\", \"follow_up_by_max\": \"2023-10-14\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
u}(hh
hX  **Meta Query**:
Move all customers that haven't responded to a proposal for the [product_interest] product in [natural_language_time_period] to "Lost" status in the CRM.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the product interest and time period from the user query. Calculate the maximum follow-up date based on the natural language time period (e.g., '6 weeks' ago). Output the product interest and maximum follow-up date.",
    "outputs": [
      "product_interest",
      "follow_up_by_max"
    ]
  },
  {
    "type": "static",
    "action": "customer_relationship_manager.search_customers",
    "params": {
      "product_interest": "${product_interest}",
      "status": "Proposal",
      "follow_up_by_max": "${follow_up_by_max}"
    },
    "output": "customers_to_update"
  },
  {
    "type": "dynamic",
    "instruction": "For each customer in the `customers_to_update` list, update their status to 'Lost'.",
    "outputs": []
  }
]
```ues}h](}(hhhhu}(hh
hXQ  
**Now Summary the Following Examples:**
**API Documentation**:
[{'type': 'function', 'function': {'name': 'project_management.create_task', 'description': 'Creates a new task.\n\nParameters\n----------\ntask_name : str\n    Name of the task.\nassigned_to_email : str\n    Email address of the person assigned to the task.\nlist_name : str\n    Name of the list the task belongs to.\ndue_date : str\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str\n    Name of the board the task belongs to.\n\nReturns\n-------\ntask_id : str\n    8-digit ID of the new task.\n\nExamples\n--------\n>>> project_management.create_task("Integrate API service with frontend", "sam@example.com", "In progress", "2023-06-01", "Front end")\n"00000001"', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.delete_task', 'description': 'Deletes a task by ID.\n\nParameters\n----------\ntask_id : str\n    8-digit ID of the task.\n\nReturns\n-------\nmessage : str\n    Message indicating the status of the deletion.\n\nExamples\n--------\n>>> project_management.delete_task("00000000")\n"Task deleted successfully."', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.get_task_information_by_id', 'description': 'Returns the task infomration for a given ID.\n\nParameters\n----------\ntask_id : str, optional\n    8-digit ID of the task.\nfield : str, optional\n    Field to return. Available fields are: "task_id", "task_name", "assigned_to_email", "list_name", "due_date", "board"\n\nReturns\n-------\ntask : dict\n    Task information for the given ID and field.\n\nExamples\n--------\n>>> project_management.get_task_information_by_id("00000000", "task_name")\n{{"task_name": "Refactor code"}}', 'parameters': {'type': 'object', 'properties': {'task_id': {'default': None, 'title': 'Task Id'}, 'field': {'default': None, 'title': 'Field'}}, 'required': []}}}, {'type': 'function', 'function': {'name': 'project_management.search_tasks', 'description': 'Searches for tasks based on the given parameters.\n\nParameters\n----------\ntask_name : str, optional\n    Name of the task.\nassigned_to_email : str, optional\n    Email address of the person assigned to the task.\nlist_name : str, optional\n    Name of the list the task belongs to.\ndue_date : str, optional\n    Due date of the task in "YYYY-MM-DD" format.\nboard : str, optional\n    Name of the board the task belongs to.\n\nReturns\n-------\ntasks : dict\n    Task information for the given parameters.\n\nExamples\n--------\n>>> project_management.search_tasks("Refactor code", "tishtrya@example.com" "In progress", "2023-06-01", "Front end")\n{{"task_id": "00000000", "task_name": "Refactor code", "assigned_to_email": "tishtrya@example.com", "list_name": "In Progress", "due_date": "2023-06-01", "board": "Front End"}}', 'parameters': {'type': 'object', 'properties': {'task_name': {'default': None, 'title': 'Task Name'}, 'assigned_to_email': {'default': None, 'title': 'Assigned To Email'}, 'list_name': {'default': None, 'title': 'List Name'}, 'due_date': {'default': None, 'title': 'Due Date'}, 'board': {'default': None, 'title': 'Board'}}, 'required': []}}}, {'type': 'function', 'funct