
ADAPTATION_PROMPT_TEMPLATE = """**YourTask**: Based on the provided context below, **concretize the current subtask** to ensure seamless integration with historical and future steps. Your output must explicitly define actionable steps for the AGENT to execute *without ambiguity*. 
Total Task: {{total_task}}

Total workflow: {{workflow}}

Current subtask to be concretized: {{current_sub_task}}

Current list of variables: {{context}}

History Logs prior to the subtask: {{history_logs}}

Available APIs and their documentation:
{{api_docs}}


Follow these guidelines:

1. In `instruction`, clearly describe the subtask that the agent should accomplish, including which variables from the history interaction may be used as inputs if applicable.
2. In `outputs`, clearly define output variables. If it is not there, set it to an empty list.
3. You need to give an answer based on a combination of history logs and subsequent workflow.
4. Please don't answer for subtask, you just need to define the task based on the context.

**Goal**: The AGENT must execute this subtask **independently** while ensuring:  
- Zero conflicts with historical steps (e.g., variable name collisions).  
- Outputs directly enable the following subtasks (e.g., the variables defined and utilized upon completion of this subtask may be referenced in future tool calls. If which variables are needed in future, please specify.). 

Let's think step by step, first carefully think about the problem then give your answer.
**Output Format**:  
Thought: "<Analysis about the problem, such as which parts need to be concretized according to the history interaction, whether there are variables used in future tool calling and need to newly defined in this subtask?>"

Final Answer:
```json  
{
    "type": "dynamic",
    "instruction": "...",
    "outputs": "[...]"
}
```   
"""


REFLECTION_PROMPT_TEMPLATE = """The {{variables}} variables failed to output correctly as in the `\boxed{json key value pair}` format output, please check the output."""

SUMMARIZATION_ICL_PROMPT1 = """Examples for reference:
**Example1:**
**Sample1**:
**Query**:
Can you send an email to attendees of the first event on November 30? Title it with the event name and tell them \'Remember to attend this event.\'
**Workflows or tool calls with execution results**:
```json  
  {
    "from": "function_call",
    "value": {
      "action": "calendar.search_events",
      "params": {
        "time_min": "2023-11-30 09:00:00",
        "time_max": "2023-11-30 18:00:00"
      }
    }
  },
  {
    "from": "observation",
    "value": [
      {
        "event_id": "00000200",
        "event_name": "Annual Budget Planning Session",
        "participant_email": "fatima.khan@atlas.com",
        "event_start": "2023-11-30 09:30:00",
        "duration": "60"
      },
      {
        "event_id": "00000225",
        "event_name": "Risk Management Forum",
        "participant_email": "aisha.chen@atlas.com",
        "event_start": "2023-11-30 12:30:00",
        "duration": "120"
      },
      {
        "event_id": "00000027",
        "event_name": "team coordination meeting",
        "participant_email": "sofia.santos@atlas.com",
        "event_start": "2023-11-30 14:30:00",
        "duration": "60"
      },
      {
        "event_id": "00000253",
        "event_name": "project progress update",
        "participant_email": "kofi.mensah@atlas.com",
        "event_start": "2023-11-30 15:30:00",
        "duration": "120"
      }
    ]
  },
  {
    "from": "function_call",
    "value": {
      "action": "email.send_email",
      "params": {
        "recipient": "fatima.khan@atlas.com",
        "subject": "Annual Budget Planning Session",
        "body": "Remember to attend this event."
      }
    }
  },
  {
    "from": "observation",
    "value": "Email sent successfully."
  }
]
```

**Sample2**:
**Query**:
I need to make sure everyone remembers to attend the first event on December 11. Can you send an email to the attendees with the event name as the title and \'Remember to attend this event.\' in the email?
**Workflows or tool calls with execution results**:
```json 
[
  {
    "from": "function_call",
    "value": {
      "action": "calendar.search_events",
      "params": {
        "query": "",
        "time_min": "2023-12-11 09:00:00",
        "time_max": "2023-12-11 18:00:00"
      }
    }
  },
  {
    "from": "observation",
    "value": [
      {
        "event_id": "00000279",
        "event_name": "Annual Budget Planning Session",
        "participant_email": "nia.johnson@atlas.com",
        "event_start": "2023-12-11 11:00:00",
        "duration": "30"
      },
      {
        "event_id": "00000086",
        "event_name": "daily stand-up",
        "participant_email": "kofi.mensah@atlas.com",
        "event_start": "2023-12-11 11:30:00",
        "duration": "90"
      },
      {
        "event_id": "00000161",
        "event_name": "introductory call",
        "participant_email": "nadia.moreau@atlas.com",
        "event_start": "2023-12-11 13:30:00",
        "duration": "60"
      },
      {
        "event_id": "00000012",
        "event_name": "strategic planning meeting",
        "participant_email": "raj.patel@atlas.com",
        "event_start": "2023-12-11 14:30:00",
        "duration": "120"
      }
    ]
  },
  {
    "from": "function_call",
    "value": {
      "action": "email.send_email",
      "params": {
        "recipient": "nia.johnson@atlas.com",
        "subject": "Annual Budget Planning Session",
        "body": "Remember to attend this event."
      }
    }
  },
  {
    "from": "observation",
    "value": "Email sent successfully."
  }
]
```

Output:

**Meta Query**:
Send an email to attendees of the first event on {natural_language_event_date}. Title it with the event name and tell them \'Remember to attend this event.\'

**Meta Workflow**:
```json
[
    {
        "type": "dynamic",
        "instruction": "Extract date from user query and format to YYYY-MM-DD",
        "outputs": ["formatted_date"]
    },
    {
        "type": "static",
        "action": "calendar.search_events",
        "params": {
            "time_min": "${formatted_date} 09:00:00",
            "time_max": "${formatted_date} 18:00:00"
        },
        "output": "event_data"
    },
    {
        "type": "dynamic",
        "instruction": "Extract the name and participant_email of the earliest event from the `event_data` list",
        "outputs": ["event_name", "participant_email"]
    },
    {
        "type": "static",
        "action": "email.send_email",
        "params": {
            "recipient": "${participant_email}",
            "subject": "${event_name}",
            "body": "Remember to attend this event."
        },
        "output": "email_result"
    }
]
```

"""



SUMMARIZATION_ICL_PROMPT2 = """
**Example2:**
**Sample1**:
**Query**:
Was total visits more than 21 at any time in the last 1 weeks? If so, please plot it as a line chart
**Workflows or tool calls with execution results***:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-16\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-16\": 7, \"2023-11-17\": 7, \"2023-11-18\": 6, \"2023-11-19\": 10, \"2023-11-20\": 13, \"2023-11-21\": 11, \"2023-11-22\": 10, \"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

**Sample2**:
**Query**:
Was total visits less than 3 at any time in the last 1 weeks? If so, please plot it as a line chart
**Workflows or tool calls with execution results***:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"analytics.total_visits_count\", \"params\": {\"time_min\": \"2023-11-23\", \"time_max\": \"2023-11-30\"}}"
  },
  {
    "from": "observation",
    "value": "{\"2023-11-23\": 7, \"2023-11-24\": 9, \"2023-11-25\": 14, \"2023-11-26\": 6, \"2023-11-27\": 6, \"2023-11-28\": 19, \"2023-11-29\": 10}"
  }
]
```

Output:

**Meta Query**:
Was the total visits [comparison_operator] [threshold] at any time in the last [natural_language_time_period]? If so, please plot it as a line chart.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the comparison operator, threshold, and time period from the user query and calculate the start and end date. The time period is natural language like '1 week' or '2 weeks'. Output the start and end dates as ISO 8601 format.",
    "outputs": [
      "time_min",
      "time_max",
      "comparison_operator",
      "threshold"
    ]
  },
  {
    "type": "static",
    "action": "analytics.total_visits_count",
    "params": {
      "time_min": "${time_min}",
      "time_max": "${time_max}"
    },
    "output": "total_visits_data"
  },
  {
    "type": "dynamic",
    "instruction": "Check if the total visits data meets the condition specified by the comparison operator and threshold. If so, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `total_visits`.",
    "outputs": [
      "plot_file_path"
    ]
  }
]
```
"""


SUMMARIZATION_ICL_PROMPT3 = """
**Example3:**
**Sample1**:
**Query**:
Move all of kofi's tasks that are in progress to in review
**Workflows or tool calls with execution results***:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
can you move all of kofi's tasks that are in progress to in review?
**Workflows or tool calls with execution results***:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

Output:

**Meta Query**:
Move all of [user]'s tasks that are in [current_list] to [new_list].

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Extract the user email, current list name, and new list name from the user query.",
    "outputs": [
      "assigned_to_email",
      "current_list",
      "new_list"
    ]
  },
  {
    "type": "static",
    "action": "project_management.search_tasks",
    "params": {
      "assigned_to_email": "${assigned_to_email}",
      "list_name": "${current_list}"
    },
    "output": "tasks_found"
  },
  {
    "type": "dynamic",
    "instruction": "For each task in the `tasks_found` list, update the task's list_name to the `new_list`.",
    "outputs": []
  }
]
```
"""


SUMMARIZATION_ICL_PROMPT4 = """
**Example4:**
**Sample1**:
**Query**:
Move all of kofi's tasks that are in progress to in review
**Workflows or tool calls with execution results***:
```json
[
  {
    "from": "function_call",
    "value": "{\"action\": \"project_management.search_tasks\", \"params\": {\"assigned_to_email\": \"kofi@example.com\", \"list_name\": \"In progress\"}}"
  },
  {
    "from": "observation",
    "value": "[]"
  }
]
```

**Sample2**:
**Query**:
I need to make sure everyone remembers to attend the first event on December 11. Can you send an email to the attendees with the event name as the title and \'Remember to attend this event.\' in the email?
**Workflows or tool calls with execution results**:
```json 
[
  {
    "from": "function_call",
    "value": {
      "action": "calendar.search_events",
      "params": {
        "query": "",
        "time_min": "2023-12-11 09:00:00",
        "time_max": "2023-12-11 18:00:00"
      }
    }
  },
  {
    "from": "observation",
    "value": [
      {
        "event_id": "00000279",
        "event_name": "Annual Budget Planning Session",
        "participant_email": "nia.johnson@atlas.com",
        "event_start": "2023-12-11 11:00:00",
        "duration": "30"
      },
      {
        "event_id": "00000086",
        "event_name": "daily stand-up",
        "participant_email": "kofi.mensah@atlas.com",
        "event_start": "2023-12-11 11:30:00",
        "duration": "90"
      },
      {
        "event_id": "00000161",
        "event_name": "introductory call",
        "participant_email": "nadia.moreau@atlas.com",
        "event_start": "2023-12-11 13:30:00",
        "duration": "60"
      },
      {
        "event_id": "00000012",
        "event_name": "strategic planning meeting",
        "participant_email": "raj.patel@atlas.com",
        "event_start": "2023-12-11 14:30:00",
        "duration": "120"
      }
    ]
  },
  {
    "from": "function_call",
    "value": {
      "action": "email.send_email",
      "params": {
        "recipient": "nia.johnson@atlas.com",
        "subject": "Annual Budget Planning Session",
        "body": "Remember to attend this event."
      }
    }
  },
  {
    "from": "observation",
    "value": "Email sent successfully."
  }
]
```


Output:

**Meta Query**:
Complete some actions.

**Meta Workflow**:
```json
[
  {
    "type": "dynamic",
    "instruction": "Complete user's query",
    "outputs": []
  }
]
```
"""


SUMMARIZATION_USER_PROMPT =  """
**Now Summary the Following Examples:**
**API Documentation**:
{api_docs}

**Sample1**:
**Query**:
{query1}
**Workflow**:
{workflow1}

**Sample2**:
**Query**:
{query2}
**Workflow**:
{workflow2}

Output:

**Meta Query**:
[Provide the generalized meta query here]

**Meta Workflow**:
[Provide the generalized meta workflow, which should include static tool calls and dynamic agent configurations. The meta workflow should be in JSON format.]
"""


SUMMARIZATION_SYSTEM_PROMPT = """You are tasked with analyzing two examples, each contains a user query and its corresponding workflow (defined to be the same as the output workflow) or tool calls with execution results. Based on these examples, your objective is to generalize a meta workflow that can solve similar problems using a combination of static executable tool calls and dynamic LLM agent configurations. The meta workflow you generalize should not only summarize the given samples, but it should be as general as possible so that it can solve similar problems by reusing static code and utilizing dynamic agents.
The meta workflow runs sequentially. When encountering a static tool call, it is executed directly. When encountering a dynamic agent's JSON configuration file, an LLM agent is triggered to generate tool calls to solve the specific task. The tool calls generated by the LLM agent and the static tool calls will operate within the same compilation environment, allowing them to output and reference variables to interact with each other.

# Key Requirements:

## Static tool calls:

Static tool calls represent reusable logic that can be executed without model inference. These calls must:
- Be complete and executable.
- Use constants or variables defined in earlier steps.
- Avoid variable placeholders in the `"action"` field (e.g., `"action": "email.send_email"` is valid, but `"action": "${some_variable}"` is not).

Example:
```json
{
  "type": "static",
  "action": "calendar.search_events",
  "params": {
    "time_min": "${formatted_date} 09:00:00",
    "time_max": "${formatted_date} 18:00:00"
  },
  "output": "event_data"
}



## Dynamic Configurations:

Dynamic steps delegate logic to an LLM, which should be used for query-specific reasoning. These should:
- The `instruction` that clearly defines the query-specific logic.
- The `outputs` defines a list of output variables for the dynamic agent. If there are no output variables, it is left empty.


Example:

```json
{
  "type": "dynamic",
  "instruction": "Extract the name and participant_email of the earliest event from the `event_data` list",
  "outputs": ["event_name", "participant_email"]
}
```
## Meta Query:

The meta query should describe the type of problem that the meta workflow can solve, without including all specific details from the input queries. It should use placeholders (e.g., [criteria]) to generalize the problem.

## Meta Workflow Structure:

The meta workflow should alternate between static tool calls and dynamic agent's configurations.
"""




VERIFY_PROMPT_TEMPLATE = """Strictly verify if the query is a valid instance of the meta query by following these criteria:

1. **Operation Structure Match**  
   - The query must execute ALL operations specified in the meta query, in the same logical order.  
   - Reject if:  
     * The query adds/removes/modifies any core operation from the meta query.  
     * The query reorders interdependent operations (e.g., using a value before generating it).  

2. **Parameter Consistency**  
   - Every parameterized value in the meta query (e.g., ) `[customer_name]`must either:  
     a) Be explicitly provided in the query, OR  
     b) Be resolved through a dedicated dynamic step in the meta workflow.  
   - Reject if:  
     a) Some general operations in meta query (such as `some actions` or parameterized value) have no corresponding operations in the query.

**Examples1**:
query: Can you find the person with the fewest overdue tasks and assign Cameron Brown to them as a new lead in the crm?
meta_query : Find the person with the fewest overdue tasks and assign [user] to them as a new lead in the CRM.
meta_workflow: [{'type': 'dynamic', 'instruction': 'Extract the user name from the user query.', 'outputs': ['user']}, {'type': 'static', 'action': 'project_management.search_tasks', 'params': {'due_date': '2023-11-29'}, 'output': 'tasks_due_date_2023_11_29'}, {'type': 'static', 'action': 'project_management.search_tasks', 'params': {'due_date': '2023-11-30', 'list_name': 'Backlog'}, 'output': 'tasks_due_date_2023_11_30'}, {'type': 'dynamic', 'instruction': 'Calculate the total number of overdue tasks for each user from the `tasks_due_date_2023_11_29` and `tasks_due_date_2023_11_30` lists. Determine the user with the fewest overdue tasks and extract their email.', 'outputs': ['user_email']}, {'type': 'static', 'action': 'customer_relationship_manager.add_customer', 'params': {'customer_name': '${user}', 'assigned_to_email': '${user_email}', 'status': 'Lead'}, 'output': 'customer_id'}]
verify_result: Thought: "The meta query is a generalized version of the query, where the specific user 'Cameron Brown' is replaced by a placeholder '[user]'. The meta workflow is designed to extract the user name from the query, find the person with the fewest overdue tasks, and assign the extracted user as a new lead in the CRM. The steps in the meta workflow align with the requirements of the query, making it a suitable solution."

Final Answer:
```json  
{  
  "answer": "True",  
}
```

**Examples2**:
query: Add Jordan Moore as a new lead in the crm and assign them to Nadia
meta_query : Add [customer_name] to the CRM. They're a new lead and need to be assigned to [assigned_to_email].
meta_workflow: [{'type': 'dynamic', 'instruction': 'Extract the customer name and assigned_to_email from the user query.', 'outputs': ['customer_name', 'assigned_to_email']}, {'type': 'static', 'action': 'customer_relationship_manager.add_customer', 'params': {'customer_name': '${customer_name}', 'assigned_to_email': '${assigned_to_email}', 'status': 'Lead'}, 'output': 'customer_id'}]
verify_result:  Thought: "The query provides 'Nadia' for `assigned_to_email`, but the meta_query strictly requires an email address (e.g., 'nadia@example.com'). Since the query does not supply a valid email, it fails parameter consistency validation."
Final Answer:
```json  
{  
  "answer": "False",  
}
```

**Examples3**:
query: Add a new task to the Back end backlog called Fix alignment issue in homepage and assign it to anaya. It's due on December 5.
meta_query : Perform an action based on the user's criteria. This could include checking for emails or tasks, reassigning tasks, or scheduling meetings.
meta_workflow: [{'type': 'dynamic', 'instruction': 'Extract the user, action, and any additional parameters (such as duration, day_of_week, time, current_status, new_status) from the user query. Format the day_of_week and time to ISO 8601 format.', 'outputs': ['user', 'action', 'additional_params']}, {'type': 'static', 'action': 'email.search_emails', 'params': {'query': '${user}', 'date_min': '${formatted_date_min}', 'date_max': '${formatted_date_max}'}, 'output': 'email_data'}, {'type': 'static', 'action': 'project_management.search_tasks', 'params': {'assigned_to_email': '${user}', 'list_name': "${additional_params['current_status']}"}, 'output': 'task_data'}, {'type': 'dynamic', 'instruction': 'Based on the action and additional parameters, perform the specified action. This could include checking for emails or tasks, reassigning tasks, or scheduling meetings.', 'outputs': []}]
verify_result:  Thought: "The query is a valid instance of the meta_query. It provides all required parameters (user, action, additional_params) and fits the meta_workflow's dynamic action execution. While the query does not use all static steps (email/task searches), the meta_query allows flexible actions, making this compliant." 
Final Answer:
```json  
{  
  "answer": "True",  
}
```

**Examples4**:
query: Was total visits more than 10 at any time in the last 2 weeks? If so, please plot it as a line chart
meta_query : Check if the number of engaged users since [start_date] was [comparison_operator] [threshold]. If so, generate a line chart of engaged users since [start_date].
meta_workflow: [{'type': 'dynamic', 'instruction': 'Extract the start date, comparison operator, and threshold from the user query. Format the start date into YYYY-MM-DD.', 'outputs': ['formatted_start_date', 'comparison_operator', 'threshold']}, {'type': 'static', 'action': 'analytics.engaged_users_count', 'params': {'time_min': '${formatted_start_date}', 'time_max': '2023-11-29'}, 'output': 'engaged_users_data'}, {'type': 'dynamic', 'instruction': 'Check if the engaged users data meets the condition specified by the comparison operator and threshold. If so, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `user_engaged`.', 'outputs': []}]
verify_result:  Thought: "The query fails strict verification because: (1) it uses 'total visits' instead of the meta_query's required 'engaged users' metric, and (2) the condition logic ('at any time' vs. aggregate count) does not match the meta_query's structure. Parameter consistency is violated." 
Final Answer:
```json  
{  
  "answer": "True",  
}
```

**Examples5**:
query: Can you make a line chart of engaged users since Sunday if it is more than 5% lower than Sunday?
meta_query : Is the number of engaged users on [comparison_day] more than [percentage] lower than it was on [base_day]? If so, please plot it as a line chart from [base_day] to [comparison_day].
meta_workflow: [{'type': 'dynamic', 'instruction': 'Extract the comparison day, percentage, and base day from the user query. Format the extracted days as ISO 8601 format.', 'outputs': ['comparison_day', 'percentage', 'base_day']}, {'type': 'static', 'action': 'analytics.engaged_users_count', 'params': {'time_min': '${base_day}', 'time_max': '${base_day}'}, 'output': 'base_day_engaged_users'}, {'type': 'static', 'action': 'analytics.engaged_users_count', 'params': {'time_min': '${comparison_day}', 'time_max': '${comparison_day}'}, 'output': 'comparison_day_engaged_users'}, {'type': 'dynamic', 'instruction': 'Compare the number of engaged users on the comparison day with the base day. If the engaged users on the comparison day are more than the specified percentage lower, generate a line chart using the `analytics.create_plot` function with the `value_to_plot` set to `user_engaged`.', 'outputs': []}]
verify_result:  Thought: "The query violates the meta_query's structure by comparing a date range ('since Sunday') against a single day (Sunday). The meta-workflow only supports single-day comparisons (base_day vs. comparison_day) and cannot process multi-day aggregates or plot trends over a period."
Final Answer:
```json  
{  
  "answer": "False",  
}
```
---

Now check the following sample:
query: {{query}}

meta_query : {{meta_query}}

meta_workflow: {{meta_workflow}}

**Output Format**:  
Thought: "<Analysis about the problem, such as is meta query a summary of query, does running some static code in Meta workflow help complete the task, is the dynamic agent json in Meta workflow a disassembly of query, or are they completely unrelated?>"

Final Answer:
```json  
{  
  "answer": "...",  
}
```   

"""


def make_summarization_prompt(example, ICL_number=-1, version=1, leaf_nodes=None):
    from generate_results_openai_using_class import build_tools

    workflow1, workflow2 = example['workflow1'], example['workflow2']
    if not workflow1.startswith("```"):
        workflow1 = "```json\n" + workflow1 + "\n```"
    if not workflow2.startswith("```"):
        workflow2 = "```json\n" + workflow2 + "\n```"




    # ==============API DOC===============
    leaf_ids = example['leaf_ids']
    domians = [leaf_nodes[id]['domains'] for id in leaf_ids]
    domains = list(set(item for sublist in domians for item in sublist))

    api_docs, _ = build_tools(domains)


    # ====================================

    user_prompt = SUMMARIZATION_USER_PROMPT.format(api_docs=api_docs,
                                                   query1=example['query1'],
                                                   workflow1=workflow1,
                                                   query2=example['query2'],
                                                   workflow2=workflow2)
    prompts = [
        SUMMARIZATION_ICL_PROMPT1,
        SUMMARIZATION_ICL_PROMPT2,
        SUMMARIZATION_ICL_PROMPT3,
        SUMMARIZATION_ICL_PROMPT4,

    ]

    if 0 < ICL_number <= len(prompts):
        user_prompt = ''.join(prompts[:ICL_number]) + user_prompt
    elif ICL_number <= 0:
        user_prompt = user_prompt
    else:
        raise Exception('ICL number not valid.')

    return {
        "prompt": [
            {"role": "system", "content": SUMMARIZATION_SYSTEM_PROMPT},
            {"role": "user", "content": user_prompt},
        ],
    }



def build_ICL_examples():
    import json
    import pickle

    golden_nodes_path = "metaflow_neurips/WorkBench/output/GolendNodes_Workbench_RFT_v1_ICL4_qwen2.5-32b-instruct_temp0.7_react_InitDelta0.1_max200_2.pkl"

    with open(golden_nodes_path, "rb") as f:
        golden_nodes = pickle.load(f)

    lst = [node for node in golden_nodes.values() if '|' in node['id']]

    for sample in lst:
        ICL_EXAMPLE = f"""**Sample1**:
**Query**:
{sample['source'][0]['query']}
**Workflow and Execution Results***:
```json
{json.dumps(sample['source'][0]['toolcall_and_results'], indent=2)}
```

**Sample2**:
**Query**:
{sample['source'][1]['query']}
**Workflow and Execution Results***:
```json
{json.dumps(sample['source'][1]['toolcall_and_results'], indent=2)}
```

Output:

**Meta Query**:
{sample['query']}

**Meta Workflow**:
```json
{json.dumps(sample['workflow'], indent=2)}
```
    """
        print(ICL_EXAMPLE)

        print('-' * 50)



if __name__ == '__main__':
    build_ICL_examples()

