import pandas as pd
from langchain.tools import tool

class CompanyDirectory:
    def __init__(self):
        self.EMAILS = pd.read_csv("data/raw/email_addresses.csv", header=None, names=["email_address"])

    def find_email_address(self, name=""):
        """
        Finds the email address of an employee by their name.

        Parameters
        ----------
        name : str, optional
            Name of the person.

        Returns
        -------
        email_address : str
            Email addresses of the person.

        Examples
        --------
        >>> directory.find_email_address("John")
        "john.smith@example.com"
        """
        if name == "":
            return "Name not provided."
        name = name.lower()
        email_address = self.EMAILS[self.EMAILS["email_address"].str.contains(name)]
        return email_address["email_address"].values


if __name__ == "__main__":
    # 创建公司目录的实例
    directory = CompanyDirectory()

    # 查找某个员工的邮箱
    emails = directory.find_email_address("John")
    print(emails)  # 输出与"John"匹配的邮箱地址
