import pandas as pd
import argparse
import sys
import os
import ast
from tqdm import tqdm
project_root = os.path.abspath(os.path.curdir)
sys.path.append(project_root)
from src.evals.utils import calculate_metrics, get_correct_predictions
import pickle

def find_files_with_string(source_root_dir, search_string):
    """
    获取指定目录下所有包含特定字符串的文件的绝对路径。

    Parameters
    ----------
    source_root_dir : str
        源目录的路径。
    search_string : str
        需要在文件路径中搜索的特定字符串。

    Returns
    -------
    list
        包含特定字符串的文件路径的绝对路径列表。
    """
    matching_files = []

    for dirpath, _, filenames in os.walk(source_root_dir):
        for filename in filenames:
            if search_string in filename:
                # 获取文件的绝对路径
                file_path = os.path.join(dirpath, filename)
                matching_files.append(file_path)

    return matching_files

all_pathes = []
for model_name in ["qwen2.5-32b-instruct", "gpt-4", "gpt-3.5", "claude-2", 'mistral']:
    all_pathes += find_files_with_string("./data/results", model_name)

combined_df = pd.DataFrame()
for path in tqdm(all_pathes):
    domain = path.split('/')[-2]
    ground_truth_path = f"./data/processed/queries_and_answers/{domain}_queries_and_answers.csv"

    predictions = pd.read_csv(path)
    ground_truth = pd.read_csv(ground_truth_path, dtype=str)
    ground_truth["answer"] = ground_truth["answer"].apply(ast.literal_eval)
    predictions["function_calls"] = predictions["function_calls"].apply(ast.literal_eval)


    correct_df = get_correct_predictions(ground_truth, predictions)
    combined_df = pd.concat([combined_df, correct_df], ignore_index=True)


combined_df.to_pickle('metaflow_neurips/output/combined_correct_predictions.pkl')
