# -*- coding: utf-8 -*-

import os
import shutil
import pickle

def read_txt(path):
    """read text file from path."""
    with open(path, "r") as f:
        return f.read().splitlines()


def write_txt(data, out_path, type="w"):
    """write the data to the txt file."""
    with open(out_path, type) as f:
        f.write(data)


def write_pickle(data, path):
    """dump file to dir."""
    print("write --> data to path: {}\n".format(path))
    with open(path, 'wb') as handle:
        pickle.dump(data, handle)


def build_dirs(path):
    try:
        os.makedirs(path)
    except OSError as e:
        pass


def remove_folder(path):
    try:
        shutil.rmtree(path)
    except OSError as e:
        pass
