import matplotlib.pyplot as plt
import re
import os
# assign directory
directory = '/home/iclr/'
paths = []
# iterate over files in
# that directory
for filename in os.listdir(directory):
    f = os.path.join(directory, filename)
    # checking if it is a file
    if os.path.isfile(f) and not ".png" in f and not ".py" in f and not ".pdf" in f:
        paths.append(f)

for path in paths:
    print(path)
    best_acc = 0.0
    # Using readlines()
    file1 = open(path, 'r')
    Lines = file1.readlines()
    key = ['top1', 'top5']
    pattern = 'Prec@1: (.*?) Prec@5: (.*?)$'
    accuracies = []
    for line in Lines:
        l = line.strip()
        if "Val at batch: " in l and "Process: 0" in l:
            matched_line = re.findall(pattern, line, re.DOTALL)[0]
            if float(matched_line[0])>float(best_acc):
                best_acc = matched_line[0]
            accuracies.append(dict((k, float(v)) for k, v in zip(key, matched_line)))
            
    loss_values = [d['top1'] for d in accuracies]
    plt.ylim([0,100])
    plt.plot(loss_values)
    plt.xlabel('Epoch')
    plt.ylabel('Top1 Accuracy')
    plt.title(path.split('/')[-1] + ', acc: '+ str(best_acc))
    plt.gcf().savefig(directory + path.split('/')[-1] + '.pdf')
    plt.clf()