#!/bin/bash

data_path=$1
model_path=$2
round=2
lr=1e-5

echo "The provided data_path is $data_path, model_path is $model_path"

python pretrain.py \
            --model_name_or_path $model_path \
            --data_path  $data_path \
	    --round $round \
            --run_name BSM_${round}_${lr} \
            --model_max_length 1024 \
            --learning_rate ${lr} \
            --num_train_epochs 1 \
            --fp16 True\
            --save_steps 200 \
            --output_dir results/models \
            --evaluation_strategy steps \
            --eval_steps 200 

