# Autonomous Imitation of Visual Expert Demonstrations with Mutual Information Constraints
## Requirements

1) To replicate the experiments in this project you need to install the Mujoco
simulation software with a valid license. You can find instructions [here](https://github.com/openai/mujoco-py).

2) The rest of the requirements can be installed with [conda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/linux.html),
by utilizing the provided environment file:
```setup
conda env create -f environment.yml
conda activate autonomous_imitation
```

## Collect data/Training

To collect expert/prior data and perform *observational* imitation to
replicate the paper's experiment, please refer to the
notebook *training_notebook.ipynb*.
The notebook can be accessed via `jupyter notebook` after activating the anaconda environment.

## Plotting

To reproduce the provided plots we provide two functions to process and display the results collected:

* plot.py - to obtain plots of multiple algorithms for a single *observational* imitation problem.

* multi_plot.py - to compare multiple plots for multiple *observational* imitation problems on the same axis.

e.g. to plot the results for *1-Linked Inverted Pendulum* -> *1-Linked Colored Inverted Pendulum*:
```setup
python plot.py experiments_data/InvertedPendulum_to_colored --min_score 5 --max_score 50 --logdir . --epochs 20 --cumulative --show_legend --yaxis 'Scaled cumulative reward'
```

## Future plans

This anonymized code is meant to provide minimal reproducibility for the results in the related paper.
We plan to publicly release our documented full code after review.
