# Install Julia 1.10.10

# Installing Julia packages

import Pkg
Pkg.add(name = "CUDA", version = "5.3.5")
Pkg.add(name = "Flux", version = "0.14.22")
Pkg.add(["Cairo", "ColorSchemes", "Conda", "CSV", "DataFrames", "Distributions", "Fontconfig", "Gadfly", "Graphs", "JSON", "LinearAlgebra", "Optimisers", "Pipe", "PlotUtils", "ProgressMeter", "PyCall", "Random", "RCall", "Statistics", "Zygote"])

# Installing local Python

import Conda
Conda.list()
Conda.pip_interop(true)
ENV["PYTHON"] = "/.julia/conda/3/x86_64/bin"
Pkg.build("PyCall")

# Installing DAGMA 

Conda.run(`/.julia/conda/3/x86_64/bin/pip install torch==2.7.1 --index-url https://download.pytorch.org/whl/cu118`)
Conda.pip("install", "/Experiments/dagma")

# Installing DiBS

Conda.run(`/.julia/conda/3/x86_64/bin/pip install --upgrade "jax[cuda12]" -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html`)
Conda.pip("install", "dibs-lib")

# Installing BOSS

Conda.pip("install", "JPype1")
Conda.pip("install", "git+https://github.com/cmu-phil/py-tetrad")

# Installing Gadget

Conda.pip("install", "sumu")]

# Installing torchmetriscs/networkx/cdt

Conda.pip("install", "torchmetrics")
Conda.pip("install", "networkx")
Conda.pip("install", "cdt")

# Installing BayesDAG

# git clone https://github.com/microsoft/Project-BayesDAG.git
# https://github.com/microsoft/Project-BayesDAG/pull/22/commits/ffec6d0cb8b94fb592b338aa5787ed164fd54d4c
# Add tensorflow-io-gcs-filesystem = "0.34" below [tool.poetry.dependencies] in src/pyproject.toml
# Copy README.md to src

mkdir("/.julia/conda38")
Conda.create("/.julia/conda38")
Conda.add("python=3.8", "/.julia/conda38")
Conda.pip_interop(true, "/.julia/conda38")
Conda.pip("install", "poetry", "/.julia/conda38")
cd("/Experiments/bayes_dag/src")
Conda.run(`/.julia/conda38/bin/poetry lock`)
Conda.run(`/.julia/conda38/bin/poetry install`)
venv_path = chomp(read(`/.julia/conda38/bin/poetry env info --path`, String))
run(`$venv_path/bin/python3 -m pip install graphical_models`)