# =================================================================================================#
# Description: Plots the projection times results
# Author: Ryan Thompson
# =================================================================================================#

cd("/Experiments")

import Cairo, CSV, DataFrames, Fontconfig, Gadfly, Pipe, Statistics

# Summarise results for plotting
result = Pipe.@pipe CSV.read("Results/timings_projection.csv", DataFrames.DataFrame)  |>
        DataFrames.stack(_, [:time]) |>
        DataFrames.groupby(_, [:n, :p, :estimator, :variable]) |>
        DataFrames.combine(
        _, 
        :value => Statistics.mean => :mean, 
        :value => (x -> Statistics.mean(x) - Statistics.std(x) / sqrt(size(x, 1))) => :low,
        :value => (x -> Statistics.mean(x) + Statistics.std(x) / sqrt(size(x, 1))) => :high
        )

# Plot timings
Gadfly.plot(
    result,
    x = :p,
    y = :mean,
    ymin = :low,
    ymax = :high,
    Gadfly.Geom.line, 
    Gadfly.Geom.point, 
    Gadfly.Geom.yerrorbar,
    Gadfly.Coord.cartesian(xmin = 20),
    Gadfly.Guide.xlabel("Number of variables"), 
    Gadfly.Guide.ylabel("Projection time (seconds)"),
    Gadfly.Theme(default_color = "black", plot_padding = [0Gadfly.mm], line_width = 1.5Gadfly.pt)
    ) |> 
    Gadfly.PDF("Figures/timings_projection.pdf", 5Gadfly.inch, 2.7Gadfly.inch)