import sys
import pandas as pd
import pytetrad.tools.TetradSearch as ts
process_id = sys.argv[1]
data_file = f"boss/data_{process_id}.csv"
adj_file  = f"boss/adjacency_matrix_{process_id}.csv"
data = pd.read_csv(data_file)
search = ts.TetradSearch(data)
search.use_sem_bic()
search.run_boss()
adj = search.get_graph_to_matrix(nullEpt = 0, circleEpt = 0, arrowEpt = 1, tailEpt = 0)
adj_df = pd.DataFrame(adj)
adj_df.to_csv(adj_file, index = False)
