# =================================================================================================#
# Description: Tables the experimental results for the Gadget comparisons
# Author: Ryan Thompson
# =================================================================================================#

cd("/Experiments")

import CSV, DataFrames, Statistics, Pipe, Printf

# Create function that returns mean (standard error)
function mean_se_str(x; digs_mean::Int = 0, digs_se::Int = 1)
    m  = Statistics.mean(x)
    se = Statistics.std(x) / sqrt(length(x))
    return Printf.@sprintf("%.*f ± %.*f", digs_mean, m, digs_se, se)
end

# Summarise results for tabling
Pipe.@pipe CSV.read("Results/gadget.csv", DataFrames.DataFrame) |>
    DataFrames.groupby(_, [:estimator]) |>
    DataFrames.combine(_, 
        :bscore => (x -> mean_se_str(x)) => :bscore,
        :shd => (x -> mean_se_str(x)) => :shd,
        :f1score => (x -> mean_se_str(x * 100)) => :f1score,
        :auroc => (x -> mean_se_str(x * 100)) => :auroc,
        :sparsity => (x -> mean_se_str(x)) => :sparsity
    )