# =================================================================================================#
# Description: Tables the run time results across Bayesian estimators
# Author: Ryan Thompson
# =================================================================================================#

cd("/Experiments")

import CSV, DataFrames, Statistics, Pipe, Printf

# Create function that returns mean (standard error)
function mean_se_str(x; digs_mean::Int = 0, digs_se::Int = 1)
    m  = Statistics.mean(x)
    se = Statistics.std(x) / sqrt(length(x))
    return Printf.@sprintf("%.*f ± %.*f", digs_mean, m, digs_se, se)
end

# Summarise results for tabling
Pipe.@pipe CSV.read("Results/timings_comparisons.csv", DataFrames.DataFrame) |>
    DataFrames.groupby(_, [:estimator, :sem_type]) |>
    DataFrames.combine(_, :time => (x -> mean_se_str(x)) => :time) |>
    DataFrames.unstack(_, :sem_type, :time)