# NeurIPS 2025 Supplementary Materials

This supplementary package includes the code and datasets used in our paper _"MemEIC: A Step Toward Continual and
Compositional Knowledge Editing"_.

---

## 1. `1_code.zip` — Source Code for CCKE

This archive provides the full implementation of our **CCKE (Continual Compositional Knowledge Editing)** method.

**Structure**:
```
1_code.zip/
└── temp-supplemental/
    ├── easyeditor/               # Core implementation built on EasyEdit
    ├── hparams/                  # Hyperparameter settings
    ├── ccke.yaml                 # YAML configuration file for CCKE
    ├── test_sequential_editing.py  # Main script to evaluate CCKE
    ├── README.md                 # Usage instructions and reproducibility steps
    └── .gitignore
```

**Usage**:
- Please refer to `README.md` inside the archive for detailed instructions.


## 2. `2_datasets_CCKEB_train_test.zip` — CCKEB Dataset for Compositional Editing

This archive contains the dataset used for training and evaluating our **Compositional Continual Knowledge Editing Benchmark (CCKEB)**.

**Files**:
```
2_datasets_CCKEB_train_test.zip/
├── train_compositional_edit.json     # Training examples
└── eval_compositional_edit.json      # Evaluation examples
```

Each JSON file contains a list of entries structured for multi-modal and compositional knowledge editing. The benchmark is designed to test how well a model maintains factual correctness and compositional consistency across edits involving textual and visual modalities.

### Format Overview (per example)

Each entry is a dictionary with the following fields:

| Field | Description |
|-------|-------------|
| `src` | Original natural question for the image |
| `rephrase` | Semantically equivalent rephrasing of `src` |
| `pred` | Original model prediction (pre-edit) |
| `alt` | Target corrected answer (post-edit) |
| `image` | Image filename associated with the `src` question |
| `image_rephrase` | Image associated with rephrased question |
| `loc`, `loc_ans` | locality question and answer(textual) |
| `m_loc`, `m_loc_q`, `m_loc_a` | Multi-modal locality question, and answer |
| `textual_edit` | textual knowledge edit |
| `comp_new` | compositional reliability |

```json
{
  "src": "What is the name of the city depicted in the image?",
  "rephrase": "Which capital city of New York is seen in the picture?",
  "pred": "Denton,_Texas",
  "alt": "Albany, New York",
  ...
}
```
