# Readme

Create a file named `global_config.yaml` with the cache directory under `CACHE_DIR` and access token for HuggingFace models under `hf_access_token`.

# File overview
- `cached_activation_flop_counting.ipynb` - Count FLOPs assuming cached activations
- `clean_eval_saes.ipynb` - Evaluate SAEs + cosine similarity over training
- `entropy_neurons.ipynb` - Functional features results
- `evaluate_stitch.ipynb` - Evaluate stitch, generate attribution scores
- `generate_augmented_data.ipynb` - Generate augmented data (but already included in `data/`), classify semantic v. structural
- `generate_tokenized_data.ipynb` - Generate tokenized data for Openwebtext
- `language_steering.ipynb` - Language steering results
- `sae_scaling_law.ipynb` - Analyzing Wandb loss curves for SAE, deriving scaling laws
- `sparse_probing.ipynb` - Sparse probing / general dense probing results
- `spearman_correlations_gemma.ipynb` - Spearman correlations/attribution scores for Gemma specifically
- `svcca.ipynb` - Compute SVCCA to get layer pairs
- `cache_activations_seccond_half.py` - Cache activations of second half of model and compute losses
- `cache_activations.py` - Cache activations at layer of a model
- `train_mappings_cached.py` - Train stitching layer from cached activations
- `train_mappings.py` - Train mappings without caching
- `train_topk_sae_[transfer].py` - Train SAE with or without transfer initialization respectively

See `config/` for examples of config files for the various scripts.

