#!/bin/bash

# 定义要执行的命令
CMD="bash train_dist.sh 8 config/cfg_coco.py config/datasets_mixed_odvg_20.json ./fewshot_log/task_2/radiation_mask"

# 设置最大尝试次数
MAX_RETRIES=2
count=0

while [ $count -lt $MAX_RETRIES ]
do
  # 执行命令
  echo "尝试次数: $((count+1))"
  $CMD
  
  # 检查命令执行的返回值
  status=$?
  if [ $status -eq 0 ]; then
    echo "命令成功执行."
    break  # 如果成功执行，跳出循环
  else
    echo "命令执行失败，正在重新尝试..."
    count=$((count+1))
    sleep 5  # 等待5秒
  fi
done

if [ $count -eq $MAX_RETRIES ]; then
  echo "命令在指定次数后失败."
fi