
from spikingjelly.clock_driven import neuron, surrogate, cu_kernel_opt, layer, functional
import torch.nn as nn
import torch
import torch.nn.functional as F


def conv3x3(in_planes, out_planes, stride=1, groups=1, dilation=1):
    """3x3 convolution with padding"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=3, stride=stride,
                     padding=dilation, groups=groups, bias=False, dilation=dilation)


def conv5x5(in_planes, out_planes, stride=1):
    """3x3 convolution with padding"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=5, stride=stride ,padding=2 ,bias=False)

func_dict = {
    '3' : conv3x3,
    '5' : conv5x5
}




def conv1x1(in_planes, out_planes, stride=1):
    """1x1 convolution"""
    return nn.Conv2d(in_planes, out_planes, kernel_size=1, stride=stride, bias=False)


class channel_BasicBlock(nn.Module):
    expansion = 1

    def __init__(self, inplanes, planes, stride=1, downsample=None, groups=1,
                 base_width=64, dilation=1, norm_layer=None):
        super(channel_BasicBlock, self).__init__()
        if norm_layer is None:
            norm_layer = nn.BatchNorm2d
        if groups != 1 or base_width != 64:
            raise ValueError('BasicBlock only supports groups=1 and base_width=64')
        if dilation > 1:
            raise NotImplementedError("Dilation > 1 not supported in BasicBlock")

        # Both self.conv1 and self.downsample layers downsample the input when stride != 1


        #####


        self.conv1 = conv3x3(inplanes, planes, stride)
        self.bn1 = norm_layer(planes)
        self.conv2 = conv3x3(planes, planes)
        self.bn2 = norm_layer(planes)

        self.downsample = downsample
        self.outchannel = planes

        self.bn1_mid = norm_layer(int(planes * 0.8))
        self.bn2_mid = norm_layer(int(planes * 0.8))

        self.bn1_small = norm_layer(int(planes * 0.6))
        self.bn2_small = norm_layer(int(planes * 0.6))



        self.spike1 = neuron.MultiStepLIFNode(surrogate_function=surrogate.ATan(), backend='cupy' ,decay_input=False)
        self.spike2 = neuron.MultiStepLIFNode(surrogate_function=surrogate.ATan(), backend='cupy' ,decay_input=False)

    def forward(self, x , channel = 0):

        T, B, C, H, W = x.shape
        identity = x

        if channel == 1:
            out = resotre(x)
            # out = self.conv1(out)
            out = F.conv2d(out, weight=self.conv1.weight[:, : C], stride=self.conv1.stride ,padding=self.conv1.padding)
            out = self.bn1(out)
            out = divide(out, T)
            out = self.spike1(out)

            out = resotre(out)
            out = self.conv2(out)
            out = self.bn2(out)
            out = divide(out, T)

            if self.downsample is not None:
                identity = resotre(identity)
                identity = F.conv2d(identity, weight=self.downsample[0].weight[:, : C],
                                    stride=self.downsample[0].stride, padding=0)
                identity = self.downsample[1](identity)
                identity = divide(identity, T)

        elif channel == 0:
            out = resotre(x)
            out = F.conv2d(out ,weight=self.conv1.weight[:int(self.outchannel * 0.8) ,: C] ,stride=self.conv1.stride
                           ,padding=self.conv1.padding)
            # out = F.batch_norm(out,weight=)
            out = self.bn1_mid(out)
            out = divide(out, T)
            out = self.spike1(out)

            out = resotre(out)
            out = F.conv2d(out, weight=self.conv2.weight[:int(self.outchannel * 0.8), : int(self.outchannel * 0.8)], stride=self.conv2.stride, padding=self.conv2.padding)
            out = self.bn2_mid(out)
            out = divide(out, T)

            if self.downsample is not None:
                identity = resotre(identity)
                identity = F.conv2d(identity, weight=self.downsample[0].weight[:int(self.outchannel * 0.8), : C], stride=self.downsample[0].stride, padding=0)
                identity = self.downsample[2](identity)
                identity = divide(identity, T)
        else:

            out = resotre(x)
            out = F.conv2d(out, weight=self.conv1.weight[:int(self.outchannel * 0.6), : C], stride=self.conv1.stride, padding=self.conv1.padding)
            # out = F.batch_norm(out,weight=)
            out = self.bn1_small(out)
            out = divide(out, T)
            out = self.spike1(out)

            out = resotre(out)
            out = F.conv2d(out, weight=self.conv2.weight[:int(self.outchannel * 0.6), : int(self.outchannel * 0.6)], stride=self.conv2.stride, padding=self.conv2.padding)
            out = self.bn2_small(out)
            out = divide(out, T)

            if self.downsample is not None:
                identity = resotre(identity)
                identity = F.conv2d(identity, weight=self.downsample[0].weight[:int(self.outchannel * 0.6), : C], stride=self.downsample[0].stride,
                                    padding=0)
                identity = self.downsample[-1](identity)
                identity = divide(identity, T)

        out = out + identity
        out = self.spike2(out)
        return out


def resotre(x):
    T, B, C, H, W = x.shape
    x = x.reshape(-1, C, H, W)
    return x


def divide(x, T):
    B, C, H, W = x.shape
    x = x.reshape(T, B // T, C, H, W)
    return x


class Bottleneck(nn.Module):
    # Bottleneck in torchvision places the stride for downsampling at 3x3 convolution(self.conv2)
    # while original implementation places the stride at the first 1x1 convolution(self.conv1)
    # according to "Deep residual learning for image recognition"https://arxiv.org/abs/1512.03385.
    # This variant is also known as ResNet V1.5 and improves accuracy according to
    # https://ngc.nvidia.com/catalog/model-scripts/nvidia:resnet_50_v1_5_for_pytorch.

    expansion = 4

    def __init__(self, inplanes, planes, stride=1, downsample=None, groups=1,
                 base_width=64, dilation=1, norm_layer=None):
        super(Bottleneck, self).__init__()
        if norm_layer is None:
            norm_layer = nn.BatchNorm2d
        width = int(planes * (base_width / 64.)) * groups
        # Both self.conv2 and self.downsample layers downsample the input when stride != 1
        self.conv1 = conv1x1(inplanes, width)
        self.bn1 = norm_layer(width)
        self.conv2 = conv3x3(width, width, stride, groups, dilation)
        self.bn2 = norm_layer(width)
        self.conv3 = conv1x1(width, planes * self.expansion)
        self.bn3 = norm_layer(planes * self.expansion)
        self.downsample = downsample
        self.stride = stride
        self.spike1 = neuron.MultiStepLIFNode(surrogate_function=surrogate.ATan(), backend='cupy', decay_input=False,
                                              )
        self.spike2 = neuron.MultiStepLIFNode(surrogate_function=surrogate.ATan(), backend='cupy', decay_input=False,
                                              )
        self.spike3 = neuron.MultiStepLIFNode(surrogate_function=surrogate.ATan(), backend='cupy', decay_input=False,
                                              )


    def forward(self, x):
        T = x.shape[0]
        identity = x

        out = resotre(x)
        out = self.conv1(out)
        out = self.bn1(out)

        out = divide(out, T)
        out = self.spike1(out)
        out = resotre(out)

        out = self.conv2(out)
        out = self.bn2(out)

        out = divide(out, T)
        out = self.spike2(out)

        out = resotre(out)
        out = self.conv3(out)
        out = self.bn3(out)
        out = divide(out, T)

        if self.downsample is not None:
            identity = resotre(identity)
            identity = self.downsample(identity)
            identity = divide(identity, T)

        out += identity

        return self.spike3(out)


class ResNet(nn.Module):

    def __init__(self, block, layers, num_classes=10, zero_init_residual=False,
                 groups=1, width_per_group=64, replace_stride_with_dilation=None,
                 norm_layer=None, T=4):
        super(ResNet, self).__init__()
        if norm_layer is None:
            norm_layer = nn.BatchNorm2d
        self._norm_layer = norm_layer

        self.T = T

        self.inplanes = 64
        self.dilation = 1
        if replace_stride_with_dilation is None:
            # each element in the tuple indicates if we should replace
            # the 2x2 stride with a dilated convolution instead
            replace_stride_with_dilation = [False, False, False]
        if len(replace_stride_with_dilation) != 3:
            raise ValueError("replace_stride_with_dilation should be None "
                             "or a 3-element tuple, got {}".format(replace_stride_with_dilation))
        self.groups = groups
        self.base_width = width_per_group
        channel = [80 ,160 ,320 ,640]
        self.conv1 = nn.Conv2d(3, self.inplanes, kernel_size=3, stride=1, padding=1,
                               bias=False)
        self.bn1 = norm_layer(self.inplanes)

        self.layer1 = self._make_layer(block, channel[0] , layers[0])
        self.layer2 = self._make_layer(block, channel[1], layers[1], stride=2,
                                       dilate=replace_stride_with_dilation[0])
        self.layer3 = self._make_layer(block, channel[2], layers[2], stride=2,
                                       dilate=replace_stride_with_dilation[1])

        self.layer4 = self._make_layer(block, channel[3], layers[3], stride=2,
                                       dilate=replace_stride_with_dilation[2])
        self.avgpool = nn.AdaptiveAvgPool2d((1, 1))
        self.fc = nn.Linear(channel[3] * block.expansion, num_classes)

        self.spike = neuron.MultiStepLIFNode(surrogate_function=surrogate.ATan() ,backend='cupy', decay_input=False
                                             ,detach_reset=True)

        self.layer = layers


        for m in self.modules():
            if isinstance(m, nn.Conv2d):
                nn.init.kaiming_normal_(m.weight, mode='fan_out', nonlinearity='relu')
            elif isinstance(m, (nn.BatchNorm2d, nn.GroupNorm)):
                nn.init.constant_(m.weight, 1)
                nn.init.constant_(m.bias, 0)


        # Zero-initialize the last BN in each residual branch,
        # so that the residual branch starts with zeros, and each residual block behaves like an identity.
        # This improves the model by 0.2~0.3% according to https://arxiv.org/abs/1706.02677

        for m in self.modules():
            if isinstance(m, Bottleneck):
                nn.init.constant_(m.bn3.weight, 0)
            elif isinstance(m, BasicBlock):
                nn.init.constant_(m.bn2.weight, 0)
            elif isinstance(m, BasicBlock_5x5):
                nn.init.constant_(m.bn2.weight, 0)

        if block == BasicBlock:
            self.transform1 = transform(channel[0] ,64)
            self.transform2 = transform(channel[1] ,128)
            self.transform3 = transform(channel[2] ,256)
            self.transform4 = transform(channel[3] ,512)





    def _make_layer(self, block, planes, blocks, stride=1, dilate=False ,):
        norm_layer = self._norm_layer
        downsample = None
        previous_dilation = self.dilation
        if dilate:
            self.dilation *= stride
            stride = 1
        if stride != 1 or self.inplanes != planes * block.expansion:
            downsample = nn.ModuleList([
                conv1x1(self.inplanes, planes * block.expansion, stride),
                norm_layer(planes * block.expansion),
                norm_layer(int(planes * block.expansion * 0.8)),
                norm_layer(int(planes * block.expansion * 0.6)),
            ])

        layers = []

        ####不同操作
        tmp = nn.ModuleList([])
        tmp.append(channel_BasicBlock(self.inplanes, planes, stride, downsample, self.groups,
                                      self.base_width, previous_dilation, norm_layer))

        layers.append(tmp)

        self.inplanes = planes * block.expansion
        for i in range(1, blocks):
            tmp = nn.ModuleList([])
            tmp.append(channel_BasicBlock(self.inplanes, planes, groups=self.groups, base_width=self.base_width,dilation=self.dilation ,norm_layer=norm_layer))
            layers.append(tmp)

        # return nn.Sequential(*layers)
        return nn.ModuleList(layers)

    # def _forward_impl(self, x):
    def res(self):
        for m in self.modules():
            if hasattr(m, 'reset'):
                m.reset()

    def small_forward(self ,x , layers = [2 ,2 ,2 ,2] ,channel = [-1 ,-1 ,-1 ,-1]):

        x = resotre(x)
        x = self.conv1(x)
        x = self.bn1(x)
        x = divide(x, self.T)
        x = self.spike(x)
        feature = []

        h = 0
        for blk in self.layer1:
            x = blk[0](x ,channel[0])
            h += 1
            if h >= layers[0]:
                break
        if self.training:
            feature.append(self.transform1(x))


        h = 0
        for blk in self.layer2:
            x = blk[0](x ,channel[1])
            h += 1
            if h >= layers[1]:
                break
        if self.training:
            feature.append(self.transform2(x))


        h = 0
        for blk in self.layer3:
            x = blk[0](x ,channel[2])
            h += 1
            if h >= layers[2]:
                break
        if self.training:
            feature.append(self.transform3(x))


        h = 0
        for blk in self.layer4:
            x = blk[0](x ,channel[3])
            h += 1
            if h >= layers[3]:
                break
        if self.training:
            feature.append(self.transform4(x))


        x = self.avgpool(x)
        x = torch.flatten(x, 2)
        out = F.linear(x ,self.fc.weight[: ,:x.shape[2]] ,bias=self.fc.bias)
        # out = self.fc(x)

        if self.training:
            return out.mean(0), feature
        return out.mean(0)

    def big_forward(self ,x):

        x = resotre(x)
        x = self.conv1(x)
        x = self.bn1(x)
        x = divide(x, self.T)
        x = self.spike(x)
        feature = []

        for blk in self.layer1:
            x = blk[-1](x ,1)
        if self.training:
            feature.append(self.transform1(x))

        for blk in self.layer2:
            x = blk[-1](x ,1)

        if self.training:
            feature.append(self.transform2(x))

        for blk in self.layer3:
            x = blk[-1](x ,1)
        if self.training:
            feature.append(self.transform3(x))

        for blk in self.layer4:
            x = blk[-1](x ,1)
        if self.training:
            feature.append(self.transform4(x))

        x = self.avgpool(x)
        x = torch.flatten(x, 2)
        # out = self.fc(x)
        out = F.linear(x, self.fc.weight[:, :x.shape[2]], bias=self.fc.bias)

        if self.training:
            return out.mean(0), feature
        return out.mean(0)
    def rand_forward(self ,x ,layers=None ,channel = [-1 ,0 ,-1 ,1], ops = [0 ,0 ,0 ,0]):

        x = resotre(x)
        x = self.conv1(x)
        x = self.bn1(x)
        x = divide(x, self.T)
        x = self.spike(x)
        feature = []

        h = 0
        for blk in self.layer1:
            # x = blk[torch.randint(low=0,high=2,size=(1,)).item()](x)
            x = blk[ops[0]](x , channel[0])
            h += 1
            if h >= layers[0]:
                break

        if self.training:
            feature.append(self.transform1(x))

        h = 0
        for blk in self.layer2:
            # x = blk[torch.randint(low=0,high=2,size=(1,)).item()](x)
            x = blk[ops[1]](x , channel[1])
            h += 1
            if h >= layers[1]:
                break

        if self.training:
            feature.append(self.transform2(x))

        h = 0
        for blk in self.layer3:
            # x = blk[torch.randint(low=0,high=2,size=(1,)).item()](x)
            x = blk[ops[2]](x , channel[2])
            h += 1
            if h >= layers[2]:
                break

        if self.training:
            feature.append(self.transform3(x))

        h = 0
        for blk in self.layer4:
            # x = blk[torch.randint(low=0,high=2,size=(1,)).item()](x)
            x = blk[ops[3]](x , channel[3])
            h += 1
            if h >= layers[3]:
                break

        if self.training:
            feature.append(self.transform4(x))

        x = self.avgpool(x)
        x = torch.flatten(x, 2)
        # out = self.fc(x)
        out = F.linear(x, self.fc.weight[:, :x.shape[2]], bias=self.fc.bias)

        if self.training:
            return out.mean(0), feature
        return out.mean(0)


    def forward(self ,input ,layers=None ,channel = [-1 ,0 ,-1 ,1], ops = [0 ,0 ,0 ,0]):

        x = input.unsqueeze(0)
        x = x.repeat(self.T, 1, 1, 1, 1)

        if self.training:

            out_small , fea_small = self.small_forward(x ,layers=[2 ,2 ,2 ,2])

            self.res()

            out_big , fea_big =  self.big_forward(x)

            self.res()

            out , feature = self.rand_forward(x , layers , channel , ops)
            return out, feature, out_small, fea_small, out_big, fea_big

        else:
            out = self.rand_forward(x ,layers ,channel ,ops)
            return out


def _resnet(arch, block, layers, pretrained, progress, **kwargs):
    model = ResNet(block, layers, **kwargs)
    # if pretrained:
    #     state_dict = load_state_dict_from_url(model_urls[arch],
    #                                           progress=progress)
    #     model.load_state_dict(state_dict)
    return model


def sup_resnet82__(pretrained=False, progress=True, **kwargs):
    return _resnet('resnet18', BasicBlock, [5, 5, 8, 5], pretrained, progress,
                   **kwargs)




class transform(nn.Module):
    def __init__(self, channel ,out_channel):
        super(transform, self).__init__()
        self.net = nn.Conv2d(channel, out_channel , 1, 1, 0, bias=False)
        self.bn = nn.BatchNorm2d(out_channel)

    def forward(self, x):
        out = F.conv2d(x.mean(0), weight=self.net.weight[ : , : x.shape[2]] ,stride=1 ,padding=0)
        return self.bn(out)


