# VectorMapNet_code
**VectorMapNet: End-to-end Vectorized HD Map Learning**

This is the codebase of VectorMapNet



# Run VectorMapNet

## 0. Enviroment

Set up environment by following this [script](env.md)

## 1. Prepare your dataset

Store your data with following structure:

```
    root
        |--datasets
            |--nuScenes
            |--Argoverse2

```

### 1.1 Generate annotation files

#### Preprocess nuScenes

```
python tools/data_converter/nuscenes_converter.py --data-root your/dataset/nuScenes/
```

## 2. Evaluate VectorMapNet


### Do Training

In single gpu
```
python tools/train.py configs/vectormapnet.py
```

For multi gpus
```
bash tools/dist_train.sh configs/vectormapnet.py $num_gpu
```

The defualt checkpoint path is `work_dirs/vectormapnet/xxx`

### Do Evalution

In single gpu
```
python tools/test.py configs/vectormapnet.py /path/to/ckpt --eval name
```

For multi gpus
```
bash tools/dist_test.sh configs/vectormapnet.py /path/to/ckpt $num_gpu --eval name
```


### Expected Results

| $AP_{ped}$   | $AP_{divider}$ | $AP_{boundary}$ | mAP   |
|--------------|----------------|-----------------|-------|
| 39.8 | 47.7    | 38.8          | 42.1 |

