import numpy as np
from utils2 import Tukey_Depth, Projection_Depth, sampled_sphere


def DW(X,Y, n_alpha=10, ndirs=100, data_depth="Tukey", eps=0, eps_max=1, p=2):

	haussdorff = 0
	d = X.shape[1]
	U = sampled_sphere(ndirs,d)
	if data_depth == "Tukey":
		Depth_X, M_X = Tukey_Depth(X, ndirs=ndirs, U=U)
		Depth_Y, M_Y = Tukey_Depth(Y, ndirs=ndirs, U=U)
	elif data_depth == "Projection":
		Depth_X, M_X = Projection_Depth(X, ndirs=ndirs, U=U)
		Depth_Y, M_Y = Projection_Depth(Y, ndirs=ndirs, U=U)


	#alpha_upper = np.minimum(np.max(Depth_X),np.max(Depth_Y)) #- 0.00001
	#alpha_lower = np.minimum(np.min(Depth_X),np.min(Depth_Y)) 
	#alpha_lower = alpha_lower + eps * (alpha_upper - alpha_lower)
	#liste_alpha = np.linspace(alpha_upper, alpha_lower, n_alpha)
	liste_alpha = np.linspace(int(eps * 100),int(eps_max * 100),n_alpha)
	quantiles_DX = [np.percentile(Depth_X, j) for j in liste_alpha]
	quantiles_DY = [np.percentile(Depth_Y, j) for j in liste_alpha]



	for i in range(n_alpha):

		D_alpha_X = np.where(Depth_X >= quantiles_DX[i])[0]
		D_alpha_Y = np.where(Depth_Y >= quantiles_DY[i])[0]

		h_K_X = np.max(M_X[D_alpha_X], axis=0)
		h_K_Y = np.max(M_Y[D_alpha_Y], axis=0)
		haussdorff += np.max((h_K_X - h_K_Y) ** p)




	return (haussdorff / n_alpha) ** (1 / p)
