import os
import json


class CocoProcessor:
    def __init__(self, fpath="coco", fname="captions_val2014.json"):  # human_all_captions_coco
        self.fpath = os.path.join("data", fpath)
        self.fname = fname
        # https://cocodataset.org/#captions-leaderboard
        self.coco_results_dict = {"Human": [0.638, 0.675, 4.836, 3.428, 0.352],
                                  "Google": [0.273, 0.317, 4.107, 2.742, 0.233],
                                  "MSR": [0.268, 0.322, 4.137, 2.662, 0.234],
                                  "Montreal/Toronto": [0.262, 0.272, 3.932, 2.832, 0.197],
                                  "MSR Captivator": [0.250, 0.301, 4.149, 2.565, 0.233],
                                  "Berkeley LRCN": [0.246, 0.268, 3.924, 2.786, 0.204],
                                  "m-RNN": [0.223, 0.252, 3.897, 2.595, 0.202],
                                  "Nearest Neighbor": [0.216, 0.255, 3.801, 2.716, 0.196],
                                  "PicSOM": [0.202, 0.250, 3.965, 2.552, 0.182],
                                  "Brno University": [0.194, 0.213, 3.079, 3.482, 0.154],
                                  "m-RNN (Baidu/ UCLA)": [0.190, 0.241, 3.831, 2.548, 0.195],
                                  "MIL": [0.168, 0.197, 3.349, 2.915, 0.159],
                                  "MLBL": [0.167, 0.196, 3.659, 2.420, 0.156],
                                  "NeuralTalk": [0.166, 0.192, 3.436, 2.742, 0.147],
                                  "ACVT": [0.154, 0.190, 3.516, 2.599, 0.155],
                                  "Tsinghua Bigeye": [0.100, 0.146, 3.510, 2.163, 0.116],
                                  "Random": [0.007, 0.020, 1.084, 3.247, 0.013]}
        self.path_dict = {
            # "MSR_Captivator":"MSR Captivator",
            "OriolVinyals": "Google",
            "human": "Human",
            # "NearestNeighbor":"Nearest Neighbor",
            # "mmitchell":"MSR",
            "rakshithShetty": "PicSOM",
            "Q.Wu": "ACVT",
            "karpathy": "NeuralTalk",
            "myamaguchi": "MIL",
            "ryank": "MLBL",
            "mRNN_share.JMao": "m-RNN",
            "kolarmartin": "Brno University",
            "jeffdonahue": "Berkeley LRCN",
            "junhua.mao": "m-RNN (Baidu/ UCLA)",
            "TsinghuaBigeye": "Tsinghua Bigeye",
            "kelvin_xu": "Montreal/Toronto"
        }


if __name__ == "__main__":
    save_dir = "data/coco"
    coco_processor = CocoProcessor()
    NUMBER_OF_CHUNKS = 20
    CHUNK_LENGTH = 250
    # Start b

    dirs = os.listdir(coco_processor.fpath)
    all_dict_results = {}
    for dir_ in dirs:
        if dir_ in coco_processor.path_dict.keys():
            path = os.path.join(coco_processor.fpath, dir_)
            onlyfiles = [f for f in os.listdir(path) if os.path.isfile(os.path.join(path, f))]
            file_to_open = [f for f in onlyfiles if (("results.json" in f) and ("val" in f))]
            with open(os.path.join(coco_processor.fpath, dir_, file_to_open[0]), "r") as file:
                refs = json.load(file)
            ref_cleaned = {}
            for ref in refs:
                ref_cleaned[ref["image_id"]] = ref["caption"]
            all_dict_results[coco_processor.path_dict[dir_]] = ref_cleaned

    with open(os.path.join(coco_processor.fpath, coco_processor.fname), "r") as file:
        ref = json.load(file)
    keys = list(set([i["image_id"] for i in ref["annotations"]]))
    ref_dic = {}
    for key in keys:
        ref_dic[int(key)] = []
    for annot in ref["annotations"]:
        ref_dic[int(annot["image_id"])].append(annot["caption"])

    coco_formated_dict = {}
    index_number = 0
    for index_number, (key, value) in enumerate(ref_dic.items()):
        coco_formated_dict[index_number] = {}
        coco_formated_dict[index_number]["system"] = {}
        coco_formated_dict[index_number]["references_sentences"] = value
        for system_name, value_system in all_dict_results.items():
            coco_formated_dict[index_number]["system"][system_name] = {}
            coco_formated_dict[index_number]["system"][system_name]["generated_sentence"] = value_system[key]
            coco_formated_dict[index_number]["system"][system_name]["scores"] = {}
    for chunk_index in range(NUMBER_OF_CHUNKS):
        processed_json = "coco_formated_{}.json"
        dict_items = coco_formated_dict.items()
        first_items = list(dict_items)[:NUMBER_OF_CHUNKS * CHUNK_LENGTH][
                      chunk_index * CHUNK_LENGTH:(chunk_index + 1) * CHUNK_LENGTH]
        with open(os.path.join(save_dir, processed_json.format(chunk_index)), "w") as file:
            json.dump(dict(first_items), file)
