#!/usr/bin/env bash
export ROUGE_HOME=/gpfsdswork/projects/rech/qsq/uwi62ct/SummEval/evaluation/summ_eval/ROUGE-1.5.5/
export PYTHONPATH=$PYTHONPATH:/gpfsdswork/projects/rech/qsq/uwi62ct/SummEval/evaluation/summ_eval/

for metric in 'infolm'; do
  for CHUNK_ID in 0 1 2 3 4 5 6 7 8 9; do
    sbatch --job-name=${metric}_${CHUNK_ID}_${dataset} \
      --gres=gpu:1 \
      --no-requeue \
      --cpus-per-task=10 \
      --hint=nomultithread \
      --time=15:00:00 \
      --output=jobinfo/${metric}_${CHUNK_ID}_${dataset}_%j.out \
      --error=jobinfo/${metric}_${CHUNK_ID}_${dataset}_%j.err \
      --qos=qos_gpu-t3 \
      --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;  python main_cnn.py --metric=${metric} --chunk_id=${CHUNK_ID}"

  done
done

for metric in 'infolm'; do
  for CHUNK_ID in 0 1 2 3 4 5 6 7 8 9; do
    sbatch --job-name=${metric}_${CHUNK_ID}_${dataset} \
      --gres=gpu:1 \
      --no-requeue \
      --cpus-per-task=10 \
      --hint=nomultithread \
      --time=15:00:00 \
      --output=jobinfo/${metric}_${CHUNK_ID}_${dataset}_%j.out \
      --error=jobinfo/${metric}_${CHUNK_ID}_${dataset}_%j.err \
      --qos=qos_gpu-t3 \
      --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ; python main_cnn.py --use_abs --metric=${metric} --chunk_id=${CHUNK_ID}"

  done
done
