# from infoscores import *
from summ_eval.chrfpp_metric import ChrfppMetric
# from summ_eval.bert_score_metric import BertScoreMetric
from summ_eval.bleu_metric import BleuMetric
from summ_eval.meteor_metric import MeteorMetric
from custom_mover import MoverScoreMetric
from summ_eval.rouge_metric import RougeMetric
from summ_eval.rouge_we_metric import RougeWeMetric
from summ_eval.sentence_movers_metric import SentenceMoversMetric
from moverinfoscores import MoverInfoScore
from ngram_infolm import NgramInfoLM
from ot_infoscores import Opti_DistribuScore
from optimscores import *
from mover_score_dtw import DTWScoreMetric
from bary_score import BaryScoreMetric


# import pyter


class Ter:
    def __init__(self):
        pass

    def evaluate_batch(self, hyps, refs):
        results = []
        for i in range(len(hyps)):
            results.append(pyter.ter(hyps[i].split(), refs[i].split()))
        return {"pyter": sum(results) / len(results)}


try:
    from allennlp.commands.elmo import ElmoEmbedder
except:
    pass

# CIDER image captionning

available_metric = {
    'info_score': InfoScore(),
    'info_score_2': NgramInfoLM(ngrams=2),
    'info_score_3': NgramInfoLM(ngrams=3),
    'info_score_4': NgramInfoLM(ngrams=4),
    'wasserstein': OTLMScore(topk_number=500),
    'info_mover_score': MoverInfoScore(),
    'sent_mover': SentenceMoversMetric(n_workers=1, metric='s+wms'),
    'bert_score': BertScoreMetric(model_type='/gpfswork/rech/qsq/uwi62ct/transformers_models/bert-base-uncased'),
    'meteor': MeteorMetric(),
    'bleu': BleuMetric(n_workers=1),
    'ter': Ter(),
    'rouge': RougeMetric(),
    'rouge_we': RougeWeMetric(),
    'chrf': ChrfppMetric(),
    'bary_score': BaryScoreMetric(stop_wordsf='data/stopwords.txt'),
    'mover_score': MoverScoreMetric(stop_wordsf='data/stopwords.txt'),
    'bert_score': BleuMetric(n_workers=1)
}

# hardcode stop_wordsf
