## A New Paradigm for Federated Structure Non-IID Subgraph Learning 

**Requirements**

Hardware environment: Intel(R) Xeon(R) Gold 6230R CPU @ 2.10GHz, NVIDIA GeForce RTX 3090 with 24GB memory.

Software environment: Ubuntu 18.04.6, Python 3.8, PyTorch 1.11.0 and CUDA 11.4.

1. Please refer to [PyTorch](https://pytorch.org/get-started/locally/) and [PyG](https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html) to install the environments;
2. Run 'pip install -r requirements.txt' to download required packages;

**Training**

To train the model(s) in the paper, follow these steps to use

1. Open gmodel_main.py to train federated global knowledge extractor, we provide PubMed dataset as example.
  You can set sampling methods (Louvain, Noniid), number of local systems, and more settings can be found in config.py

  Run this command:

  ```python
  python gmodel_main.py
  ```

2. Due to space limitations, more details can be referred to the source code we release later, datasets name (Cora, Citeseer, etc)

3. Open main.py, you can use the default hyperparameters (by Optuna) to load partitioned datasets (e.g., PubMed) and train AdaGFL. Run this command:

   ```python
   python train.py
   ```

4. Or you can obtain new data partition results and conduct training, we suggest using optuna_train.py to execute auto hyperparameter tuning.



