import argparse
parser = argparse.ArgumentParser()

parser.add_argument('--seed', help='seed everything', type=int,
                    default=2022)


parser.add_argument('--num_clients', help='number of clients', type=int,
                    default=3)


parser.add_argument('--dirichlet_alpha', help='dirichlet distribution parameter', type=float,
                    default=0.5)


parser.add_argument('--evalute_lr', help='evalute global or isolate data', type=float,
                    default=1e-2)
                    

parser.add_argument('--homo', help='homo & hete datasets', type=bool,
                    default=False)



parser.add_argument('--gmlp_normalize_train', help='number of global model training times', type=int,
                    default=1)

parser.add_argument('--gmlp_num_rounds', help='number of global mlp training rounds', type=int,
                    default=50)

parser.add_argument('--gmlp_num_epochs', help='number of global mlp local training epochs', type=int,
                    default=20)

parser.add_argument('--gmlp_num_layers', help='number of global mlp layers', type=int,
                    default=3)

parser.add_argument('--gmlp_lr', help='global mlp learning rate', type=float,
                    default=1e-2)

parser.add_argument('--gmlp_weight_decay', help='global mlp weight decay', type=float,
                    default=5e-4)

parser.add_argument('--gmlp_drop', help='global mlp drop out prob', type=float,
                    default=0.5)

parser.add_argument('--gmlp_bn', help='global mlp batch normalization', type=int,
                    default=0)

parser.add_argument('--gmlp_ln', help='global mlp layer normalization', type=int,
                    default=0)



parser.add_argument('--message_op', help='personal local model message aggregation method', type=str,
                    default="last")


parser.add_argument('--main_normalize_train', help='number of personal local model training times', type=int,
                    default=1)

parser.add_argument('--main_hidden_dim', help='multi layer model hidden units', type=int,
                    default=64)




parser.add_argument('--main_homo_num_epochs', help='number of personal local homo model training epochs', type=int,
                    default=500)

parser.add_argument('--main_homo_lr', help='personal homo local model learning rate', type=float,
                    default=5e-3)

parser.add_argument('--main_homo_weight_decay', help='personal homo local model weight decay', type=float,
                    default=5e-4)

parser.add_argument('--homo_drop', help='personal local homo model drop out prob', type=float,
                    default=0.5)

parser.add_argument('--homo_bn', help='personal local homo model batch normalization', type=int,
                    default=0)

parser.add_argument('--homo_ln', help='personal local homo model layer normalization', type=int,
                    default=0)

parser.add_argument('--homo_layers', help='local homo model layers', type=int,
                    default=2)

parser.add_argument('--homo_kd_ratio', help='local homo model kd loss ratio', type=float,
                    default=0.01)


parser.add_argument('--main_hete_num_epochs', help='number of personal local hete model training epochs', type=int,
                    default=2000)

parser.add_argument('--main_hete_lr', help='personal hete local model learning rate', type=float,
                    default=1e-3)

parser.add_argument('--main_hete_weight_decay', help='personal hete local model weight decay', type=float,
                    default=5e-4)

parser.add_argument('--hete_drop', help='personal local hete model drop out prob', type=float,
                    default=0.9)

parser.add_argument('--hete_bn', help='personal local hete model batch normalization', type=int,
                    default=0)

parser.add_argument('--hete_ln', help='personal local hete model layer normalization', type=int,
                    default=0)

parser.add_argument('--hete_re_temperature', help='hete model relationship temperature', type=float,
                    default=0.7)

parser.add_argument('--hete_negative_slope', help='hete model leakyrelu negative_slope', type=float,
                    default=0.1)

parser.add_argument('--hete_re_smooth', help='hete model universal propagation re smooth', type=float,
                    default=0.3)

parser.add_argument('--hete_propagation_op', help='local hete model message propagation method', type=str,
                    default="ori")


    
args = parser.parse_args()

