import sys
import os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '../..')))

from abl.reasoning import ReasonerBase, KBBase
from datasets.addition import digits_to_number

def split_list(lst):
    middle = len(lst) // 2
    list1 = lst[:middle]
    list2 = lst[middle:]
    return list1, list2

def digits_to_number(digits, digit_base=10) -> int:
    number = 0
    for d in digits:
        number *= digit_base
        number += d
    return number


class add_KB(KBBase):
    def __init__(
        self,
        pseudo_label_list=list(range(10)),  # Range 0-15 for hex digits
        prebuild_GKB=True,
        GKB_len_list=[1 * 2],
        max_err=0,
        use_cache=True,
        kb_file_path=None,
    ):
        super().__init__(
            pseudo_label_list, prebuild_GKB, GKB_len_list, max_err, use_cache, kb_file_path
        )

    def logic_forward(self, nums):
        nums1, nums2 = split_list(nums)
        return digits_to_number(nums1, 10) + digits_to_number(nums2, 10)

if __name__ == "__main__":
    kb = add_KB(GKB_len_list=[4], kb_file_path='./kb/addition_2.pl')