:- dynamic at/2.

ic :- at(Pos1,T1), at(Pos2,T2), Pos1 \= Pos2, attack(Pos1,T1,Pos2), T1 \= T2.

attack((X1,Y1),T,(X2,Y2)) :- king(T), one_step((X1,Y1),(X2,Y2)).
attack((X1,Y1),T,(X2,Y2)) :- queen(T), straight((X1,Y1),(X2,Y2)).
attack((X1,Y1),T,(X2,Y2)) :- queen(T), diag((X1,Y1),(X2,Y2)).
attack((X1,Y1),T,(X2,Y2)) :- rook(T), straight((X1,Y1),(X2,Y2)).
attack((X1,Y1),T,(X2,Y2)) :- bishop(T), diag((X1,Y1),(X2,Y2)).
attack((X1,Y1),T,(X2,Y2)) :- knight(T), lshape((X1,Y1),(X2,Y2)).
attack((X1,Y1),T,(X2,Y2)) :- pawn(T), diag_forward((X1,Y1),(X2,Y2)).

left((X1,Y1),(X2,Y2)) :- X2 is X1 + 1, Y1 = Y2.
right((X1,Y1),(X2,Y2)) :- X2 is X1 - 1, Y1 = Y2.
forward((X1,Y1),(X2,Y2)) :- X1 = X2, Y2 is Y1 + 1.
backward((X1,Y1),(X2,Y2)) :- X1 = X2, Y2 is Y1 - 1.

left_forward((X1,Y1),(X2,Y2)) :- left((X1,Y1),(X3,Y3)), forward((X3,Y3),(X2,Y2)).
right_forward((X1,Y1),(X2,Y2)) :- right((X1,Y1),(X3,Y3)), forward((X3,Y3),(X2,Y2)).
left_backward((X1,Y1),(X2,Y2)) :- left((X1,Y1),(X3,Y3)), backward((X3,Y3),(X2,Y2)).
right_backward((X1,Y1),(X2,Y2)) :- right((X1,Y1),(X3,Y3)), backward((X3,Y3),(X2,Y2)).

one_step((X1,Y1),(X2,Y2)) :- left((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- right((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- forward((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- backward((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- left_forward((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- right_forward((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- left_backward((X1,Y1),(X2,Y2)).
one_step((X1,Y1),(X2,Y2)) :- right_backward((X1,Y1),(X2,Y2)).

straight((X1,Y1),(X2,Y2)) :- X1 = X2, Y1 < Y2.
straight((X1,Y1),(X2,Y2)) :- X1 = X2, Y1 > Y2.
straight((X1,Y1),(X2,Y2)) :- Y1 = Y2, X1 < X2.
straight((X1,Y1),(X2,Y2)) :- Y1 = Y2, X1 > X2.

diag((X1,Y1),(X2,Y2)) :- diag_0((X1,Y1),(X2,Y2)).
diag((X1,Y1),(X2,Y2)) :- diag_1((X1,Y1),(X2,Y2)).
diag((X1,Y1),(X2,Y2)) :- diag_2((X1,Y1),(X2,Y2)).
diag((X1,Y1),(X2,Y2)) :- diag_3((X1,Y1),(X2,Y2)).

diag_0((X1,Y1),(X2,Y2)) :- left_forward((X1,Y1),(X2,Y2)).
diag_1((X1,Y1),(X2,Y2)) :- right_forward((X1,Y1),(X2,Y2)).
diag_2((X1,Y1),(X2,Y2)) :- left_backward((X1,Y1),(X2,Y2)).
diag_3((X1,Y1),(X2,Y2)) :- right_backward((X1,Y1),(X2,Y2)).

lshape((X1,Y1),(X2,Y2)) :- left_forward((X1,Y1),(X3,Y3)), left((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- left_forward((X1,Y1),(X3,Y3)), forward((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- right_forward((X1,Y1),(X3,Y3)), right((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- right_forward((X1,Y1),(X3,Y3)), forward((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- left_backward((X1,Y1),(X3,Y3)), left((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- left_backward((X1,Y1),(X3,Y3)), backward((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- right_backward((X1,Y1),(X3,Y3)), right((X3,Y3),(X2,Y2)).
lshape((X1,Y1),(X2,Y2)) :- right_backward((X1,Y1),(X3,Y3)), backward((X3,Y3),(X2,Y2)).

diag_forward((X1,Y1),(X2,Y2)) :- left_forward((X1,Y1),(X2,Y2)).
diag_forward((X1,Y1),(X2,Y2)) :- right_forward((X1,Y1),(X2,Y2)).

king(ki). 
queen(q). 
rook(r). 
bishop(b). 
knight(kn). 
pawn(p).

sat :- \+ ic. 
-sat :- ic.

% example query: 
% ?- assert(at((1,1), kn)), assert(at((1,2), ki)), sat.
