# -*- coding: utf-8 -*-
import pickle
import time
import pandas as pd
import tqdm
from openai import OpenAI
from bs4 import BeautifulSoup

from ..data_utils import read_csv

def get_ahs_text():
    data = read_csv("train.csv")
    ahs, text = data[1], data[-1]
    data = read_csv("test.csv")
    return ahs+data[1], text+data[-1]

api_key = "YOUR API KEY"
client = OpenAI(api_key=api_key, base_url="https://api.deepseek.com")

def get_response(user_msg, system_msg=None, max_tokens=500):
    if system_msg is None:
        system_msg = "You are a helpful assistant"
    response = client.chat.completions.create(
        model="deepseek-chat",
        messages=[
            {"role": "system", "content": system_msg},
            {"role": "user", "content": user_msg},
        ],
        temperature=1.0,
        max_tokens=max_tokens,
        stream=False
    )

    answer_text = response.choices[0].message.content
    return answer_text

def parse_raw_text(markup):
    soup = BeautifulSoup(markup, features="html.parser")
    return soup.text

prompt_plain = """请生成位于<text>与</text>间的刑事判决书的摘要，限200字以内。

<text>{}</text>"""

prompt_heuristic = """请生成位于<text>与</text>间的刑事判决书的摘要，需少于500字。摘要需包含被告人个人信息，过往犯罪记录，犯罪事实，是否主动认罪，是否给被害人造成损失，是否得到被害人谅解等要素。

<text>{}</text>"""

system_prompt = """你是一个法律领域的专家，需要为用户输入的刑事判决书生成500字以内的摘要。摘要需包含被告人的个人信息，过往犯罪记录，犯罪事实，是否主动坦白认罪，是否给被害人造成损失，是否得到被害人谅解等要素。你需要注意以下几点：
1. 最后一次刑满释放在5年以外则不属于累犯。
2. 当判决书中只有“对指控事实无异议”，而没有“坦白”、“认罪”、“悔罪”等描述，则不属于主动认罪。
3. 不属于的性质需要在摘要中省略。"""


if __name__ == '__main__':
    prompt = prompt_plain
    f = open("summary.pkl", "wb")
    ahs, texts = get_ahs_text()
    answer_dict = {}
    for ah, text_r in tqdm.tqdm(list(zip(ahs, texts))):
        text = parse_raw_text(text_r)
        query = prompt.format(text)
        answer = get_response(query)
        assert ah not in answer_dict
        answer_dict[ah] = answer
        time.sleep(1.0)
    pickle.dump(answer_dict, f)
    f.close()


