from main import *
from dataLoader import *
from utils import *

datasetName = "Parkinsons"
dataset = loadData(datasetName)
print (dataset.shape, dataset[0,0])

# P = 4
REPS =1000 # max reps of STORM
Itr = 100
avgcount = 100 # results averaged on these runs
alpha = 0.1
ridge_lambda = 0.01 # ridge regression lambda param
hash_type = "prp" # for prp
# hash_type = "alsh_prp" 

logfilename = datasetName+"_"+ str(dataset.shape[0]*0.8) + "_"+str(dataset.shape[1])+ ".txt"
logfile = open(logfilename, 'w')

#placeholder
[L1, L2, M1, M2, A1,A2,A3,A4,S1,S2,C1,C2,R1,R2,V1,V2,T1,T2]  = [float("NaN") for i in range(0,18)]

[L1, L2] = experimentLeastSquare(datasetName, dataset, avgcount, ridge_lambda)
[M1, M2] = experimentMean(datasetName, dataset)
# for Reps in [2, 10, 50, 70, 100, 200, 500, 700, 1000, 1500, 2000, 3000, 5000, 6000, 8000, 10000]:
plotVars = []
P = 4
Reps = [2, 5, 10, 20, 50, 60, 80, 100, 130, 170, 200, 500, 1000]
AllrepSTORM = experimentSTORM(datasetName, dataset, Reps, P, "BestACE_LS", Itr, alpha, ridge_lambda, "zeros", REPS, avgcount, hash_type)

for R in range(len(Reps)):
    # for alpha in [0.05, 0.1, 0.2, 0.3, 0.5, 1, 1.5, 2]:
    print ("datasetName:", datasetName, " Instances:", dataset.shape[0]*0.8, " Reps:", Reps[R], " P:", P, " Itr:" ,Itr," alpha:",  alpha, " avgcount:",avgcount)

    # [A1, A2, sparseMem] = experimentSTORM(datasetName, dataset, Reps, P, "OneEditOneJump", Itr, alpha, "zeros", REPS, avgcount)

    [T1, T2, sparseMem] = AllrepSTORM[R]

    # rho = ((2**P)*Reps*8)/(dataset.size*dataset.itemsize*0.8)
    rho = (sparseMem/(dataset.size*dataset.itemsize*0.8))
    print (rho)
    if rho>0.99:
        break

    # [A3, A4, sparseMem] = experimentSTORM(datasetName, dataset, Reps, P, "OneEditOneJump", Itr, alpha, "random", REPS, avgcount)

    # experimentSTORM(datasetName, dataset, Reps, P, "AllEditLP", Itr, alpha, init, REPS, avgcount)

    # [S1, S2, sparseMem] = experimentSTORM(datasetName, dataset, Reps, P, "BestACE_LP", Itr, alpha, "dm", REPS, avgcount)

    [R1, R2] = experimentRandomSampling(datasetName, dataset, rho, ridge_lambda, avgcount)

    #ridge regression baseline is random sampling only
    if ridge_lambda==0:
        [V1, V2] = experimentLeverageSampling(datasetName, dataset, rho, avgcount)
        [C1, C2] = experimentClarkson(datasetName, dataset, rho, avgcount)

    # rho = ((2**P)*Reps*8)/(dataset.size*dataset.itemsize*0.8)
    print ("Summary======================================================================================================================================================")
    print (datasetName,",",dataset.shape[0]*0.8,"x",dataset.shape[1],",",L1, L2,",",R1, R2,",",V1, V2,",",C1, C2,",",A1, A2,",",A3, A4,",",T1, T2,",",S1, S2,",",M1, M2, ",",Reps[R],",",P, ",",sparseMem, ",",rho,",",avgcount)
    print (datasetName,",",dataset.shape[0]*0.8,"x",dataset.shape[1],",",L1, L2,",",R1, R2,",",V1, V2,",",C1, C2,",",A1, A2,",",A3, A4,",",T1, T2,",",S1, S2,",",M1, M2, ",",Reps[R],",",P, ",",sparseMem, ",",rho,",",avgcount, file = logfile)
    print ("SummaryEND======================================================================================================================================================")
    plotVars.append([datasetName,dataset.shape[0]*0.8,dataset.shape[1], L1, L2, M1, M2, A1,A2,A3,A4,S1,S2,C1,C2,R1,R2,V1,V2,T1,T2,Reps[R],P,sparseMem,rho,avgcount])

plotres(plotVars, ridge_lambda)
logfile.close()
