## Repository overview

The repository is organised for ease of use:
- The `src/` folder contains all necessary functions.
- The `notebooks/` folder includes notebooks for generating the plots in the paper.
- The `assets/explanations/` folder includes pre-computed explanations for various explanation methods across different models.

## How to run

#### 0. Collect Explanations with Explanation Methods

Follow the instructions on the following project sites to set up and run these explanation methods to collect target explanations:

- [MILAN](https://github.com/evandez/neuron-descriptions)
- [FALCON](https://github.com/NehaKalibhat/falcon-explain)
- [CLIP-Dissect](https://github.com/Trustworthy-ML-Lab/CLIP-dissect)
- [INVERT](https://github.com/lapalap/invert)

#### 1. Collect Activations

Collect activations for your model.

```bash
python src/activation_collector.py
```

#### 2. Generate Explanation Images

```bash
torchrun src/image_generator.py --nproc_per_node=3
```

Use the ``--nproc_per_node`` argument to specify the number of GPUs to use. For more information on distributed inference follow these [instructions](https://huggingface.co/docs/diffusers/main/en/training/distributed_inference).

#### 3. Evaluate Explanations

```bash
python src/evaluation.py
```
