# GIFT Code Repository

This repository contains scripts for immunization, fine-tuning, and attacking a stable diffusion model using GIFT.

## Setup
1.  Create and activate a virtual environment (optional but recommended):
    ```bash
    python3 -m venv .venv
    source .venv/bin/activate
    ```
2.  Install the required dependencies:
    ```bash
    pip install -r requirements.txt
    ```
## Usage

The main scripts in this repository are:

*   **Immunization**: To immunize a model, run the `immunize.sh` script.
    ```bash
    ./immunize.sh
    ```
*   **Fine-tuning**: To fine-tune a model, use the `finetune.sh` script.
    ```bash
    ./finetune.sh
    ```
*   **Attack**: To run an attack on a model, execute the `attack.sh` script.
    ```bash
    ./attack.sh
    ```

### Data

*   Malicious data samples can be found in `data/malicious/`.
*   Safe data samples are located in `data/safe/`.

### Training Scripts

Custom training scripts are available in the `train/` directory:
*   [`train/custom_unet2d.py`](gift_code/train/custom_unet2d.py)
*   [`train/immunize.py`](gift_code/train/immunize.py)
*   [`train/train_dreambooth.py`](gift_code/train/train_dreambooth.py)

### Results

Results from various runs are stored in the `results/` directory.

### Logging

Outputs from script executions may be found in `nohup.out`. Experiment tracking with Weights & Biases is stored in the `wandb/` directory.