export WANDB_NAME="gift_immunized"
# export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export MODEL_NAME="runwayml/stable-diffusion-v1-5"
export OUTPUT_DIR='results/immunization'

export INSTANCE_PROMPT="a photo of plushie penguin"
export INSTANCE_DIR="data/malicious/plushie_penguin/train"
export CLASS_PROMPT="toy penguin"
export CLASS_DIR="data/malicious/plushie_penguin/class_prior"

accelerate launch --num_processes=1 --gpu_ids='0' train/immunize.py \
  --rep_noising_weight=2e-3 \
  --learning_rate=5e-6 \
  --learning_rate_defense=8e-6 \
  --pretrained_model_name_or_path=$MODEL_NAME  \
  --instance_data_dir=$INSTANCE_DIR \
  --output_dir=$OUTPUT_DIR \
  --instance_prompt="${INSTANCE_PROMPT}" \
  --resolution=512 \
  --train_batch_size=1 \
  --gradient_accumulation_steps=1 \
  --report_to="wandb" \
  --lr_scheduler="constant" \
  --lr_warmup_steps=0 \
  --max_train_steps=1500 \
  --seed="0" \
  --inner_loop_steps=1 \
  --outer_loop_steps=1 \
  --mixed_precision="bf16" \
  --gradient_checkpointing \
  --output_unet_name=$WANDB_NAME \
  --use_8bit_adam \
  --class_data_dir=$CLASS_DIR \
  --class_prompt="${CLASS_PROMPT}" \
  --num_class_images=60 \
  --with_prior_preservation \
  --rep_noising \
