[<img width="295" src="https://inspect.ai-safety-institute.org.uk/images/aisi-logo.svg" />](https://aisi.gov.uk/)

Welcome to **Inspect Evals**, a repository of community contributed LLM evaluations for [Inspect AI](https://inspect.ai-safety-institute.org.uk/). Inspect Evals was created in collaboration by the [UK AISI](https://aisi.gov.uk/), [Arcadia Impact](https://www.arcadiaimpact.org/), and the [Vector Institute](https://vectorinstitute.ai/).

🚀 New: Inspect Evals Dashboard (Beta)

We're excited to share the [Inspect Evals Dashboard](https://inspect-evals-dashboard.streamlit.app/), an interactive tool for exploring and comparing real-time LLM evaluation results based on this repository.

This is an early beta release, and we’re actively collecting feedback from the community. If you spot a bug, have a suggestion, or want to help improve the dashboard experience, please open a [GitHub issue](https://github.com/ArcadiaImpact/inspect_evals_dashboard/issues).

---

Community contributions are welcome and encouraged! Please see the [Contributor Guide](CONTRIBUTING.md) for details on submitting new evaluations.

# Getting Started

First, install the `inspect_ai` and `inspect_evals` Python packages with:

```bash
pip install inspect_ai
pip install git+https://github.com/UKGovernmentBEIS/inspect_evals
```

If developing locally, you can install the packages in editable mode with:

```bash
pip install -e ".[dev]"
```

You will also need to install any packages required to interact with the models you'd like to evaluate and define any required API key environment variables. For example, to work with OpenAI models:

```bash
export OPENAI_API_KEY=<openai-api-key>
pip install openai
```

Furthermore, some of the evaluations require additional dependencies. If your eval needs extra dependencies, instructions for installing them are provided in the [list of evals](#list-of-evals) subsection (or the README for that evaluation). For example, to install the dependencies of `SWE-Bench` evaluation you should run:

```bash
   pip install "inspect_evals[swe_bench] @ git+https://github.com/UKGovernmentBEIS/inspect_evals"
   pip install -e ".[swe_bench]" # If developing on the package locally
```

Once you have a model configured, you can run evaluations for it with:

```bash
inspect eval inspect_evals/gpqa_diamond --model openai/gpt-4o
```

If you don't want to specify the `--model` each time you run an evaluation, create a `.env` configuration file in your working directory that defines the `INSPECT_EVAL_MODEL` environment variable along with your API key. For example:

```bash
INSPECT_EVAL_MODEL=openai/gpt-4o
OPENAI_API_KEY=<openai-api-key>
```

Inspect supports many model providers including OpenAI, Anthropic, Google, Mistral, Azure AI, AWS Bedrock, Together AI, Groq, Hugging Face, vLLM, Ollama, and more. See the [Model Providers](https://inspect.ai-safety-institute.org.uk/models.html) documentation for additional details.

# List of Evals
<!-- Eval Listing: Automatically Generated -->
## Coding

- ### [APPS: Automated Programming Progress Standard](src/inspect_evals/apps)

  APPS is a dataset for evaluating model performance on Python programming tasks across three difficulty levels consisting of 1,000 at introductory, 3,000 at interview, and 1,000 at competition level. The dataset consists of an additional 5,000 training samples, for a total of 10,000 total samples. We evaluate on questions from the test split, which consists of programming problems commonly found in coding interviews.
  <sub><sup>Contributed by: [@camtice](https://github.com/camtice)</sub></sup>

  ```bash
  inspect eval inspect_evals/apps
  ```

- ### [BigCodeBench: Benchmarking Code Generation with Diverse Function Calls and Complex Instructions](src/inspect_evals/bigcodebench)

  Python coding benchmark with 1,140 diverse questions drawing on numerous python libraries.
  <sub><sup>Contributed by: [@tim-hua-01](https://github.com/tim-hua-01)</sub></sup>

  ```bash
  inspect eval inspect_evals/bigcodebench
  ```

- ### [CORE-Bench](src/inspect_evals/core_bench)

  Evaluate how well an LLM Agent is at computationally reproducing the results of a set of scientific papers.
  <sub><sup>Contributed by: [@enerrio](https://github.com/enerrio)</sub></sup>

  ```bash
  inspect eval inspect_evals/core_bench
  ```

- ### [ClassEval: A Manually-Crafted Benchmark for Evaluating LLMs on Class-level Code Generation](src/inspect_evals/class_eval)

  Evaluates LLMs on class-level code generation with 100 tasks constructed over 500 person-hours. The study shows that LLMs perform worse on class-level tasks compared to method-level tasks.
  <sub><sup>Contributed by: [@zhenningdavidliu](https://github.com/zhenningdavidliu)</sub></sup>

  ```bash
  inspect eval inspect_evals/class_eval
  ```

- ### [DS-1000: A Natural and Reliable Benchmark for Data Science Code Generation](src/inspect_evals/ds1000)

  Code generation benchmark with a thousand data science problems spanning seven Python libraries.
  <sub><sup>Contributed by: [@bienehito](https://github.com/bienehito)</sub></sup>

  ```bash
  inspect eval inspect_evals/ds1000
  ```

- ### [HumanEval: Python Function Generation from Instructions](src/inspect_evals/humaneval)

  Assesses how accurately language models can write correct Python functions based solely on natural-language instructions provided as docstrings.
  <sub><sup>Contributed by: [@adil-a](https://github.com/adil-a)</sub></sup>

  ```bash
  inspect eval inspect_evals/humaneval
  ```

- ### [MBPP: Basic Python Coding Challenges](src/inspect_evals/mbpp)

  Measures the ability of language models to generate short Python programs from simple natural-language descriptions, testing basic coding proficiency.
  <sub><sup>Contributed by: [@jddantes](https://github.com/jddantes)</sub></sup>

  ```bash
  inspect eval inspect_evals/mbpp
  ```

- ### [MLE-bench: Evaluating Machine Learning Agents on Machine Learning Engineering](src/inspect_evals/mle_bench)

  Machine learning tasks drawn from 75 Kaggle competitions.
  <sub><sup>Contributed by: [@samm393](https://github.com/samm393)</sub></sup>

  ```bash
  inspect eval inspect_evals/mle_bench
  inspect eval inspect_evals/mle_bench_full
  inspect eval inspect_evals/mle_bench_lite
  ```

- ### [SWE-bench Verified: Resolving Real-World GitHub Issues](src/inspect_evals/swe_bench)

  Evaluates AI's ability to resolve genuine software engineering issues sourced from 12 popular Python GitHub repositories, reflecting realistic coding and debugging scenarios.
  <sub><sup>Contributed by: [@max-kaufmann](https://github.com/max-kaufmann)</sub></sup>

  ```bash
  inspect eval inspect_evals/swe_bench
  inspect eval inspect_evals/swe_bench_verified_mini
  ```

- ### [SciCode: A Research Coding Benchmark Curated by Scientists](src/inspect_evals/scicode)

  SciCode tests the ability of language models to generate code to solve scientific research problems. It assesses models on 65 problems from mathematics, physics, chemistry, biology, and materials science.
  <sub><sup>Contributed by: [@xantheocracy](https://github.com/xantheocracy)</sub></sup>

  ```bash
  inspect eval inspect_evals/scicode
  ```

- ### [USACO: USA Computing Olympiad](src/inspect_evals/usaco)

  Evaluates language model performance on difficult Olympiad programming problems across four difficulty levels.
  <sub><sup>Contributed by: [@danwilhelm](https://github.com/danwilhelm)</sub></sup>

  ```bash
  inspect eval inspect_evals/usaco
  ```

## Assistants

- ### [AssistantBench: Can Web Agents Solve Realistic and Time-Consuming Tasks?](src/inspect_evals/assistant_bench)

  Tests whether AI agents can perform real-world time-consuming tasks on the web.
  <sub><sup>Contributed by: [@nlpet](https://github.com/nlpet), [@caspardh](https://github.com/caspardh)</sub></sup>

  ```bash
  inspect eval inspect_evals/assistant_bench_closed_book_zero_shot
  inspect eval inspect_evals/assistant_bench_closed_book_one_shot
  inspect eval inspect_evals/assistant_bench_web_search_zero_shot
  inspect eval inspect_evals/assistant_bench_web_search_one_shot
  ```

- ### [GAIA: A Benchmark for General AI Assistants](src/inspect_evals/gaia)

  Proposes real-world questions that require a set of fundamental abilities such as reasoning, multi-modality handling, web browsing, and generally tool-use proficiency. GAIA questions are conceptually simple for humans yet challenging for most advanced AIs.
  <sub><sup>Contributed by: [@max-kaufmann](https://github.com/max-kaufmann)</sub></sup>

  ```bash
  inspect eval inspect_evals/gaia
  inspect eval inspect_evals/gaia_level1
  inspect eval inspect_evals/gaia_level2
  inspect eval inspect_evals/gaia_level3
  ```

- ### [Mind2Web: Towards a Generalist Agent for the Web](src/inspect_evals/mind2web)

  A dataset for developing and evaluating generalist agents for the web that can follow language instructions to complete complex tasks on any website.
  <sub><sup>Contributed by: [@dr3s](https://github.com/dr3s)</sub></sup>

  ```bash
  inspect eval inspect_evals/mind2web
  ```

- ### [OSWorld: Multimodal Computer Interaction Tasks](src/inspect_evals/osworld)

  Tests AI agents' ability to perform realistic, open-ended tasks within simulated computer environments, requiring complex interaction across multiple input modalities.
  <sub><sup>Contributed by: [@epatey](https://github.com/epatey)</sub></sup>

  ```bash
  inspect eval inspect_evals/osworld
  inspect eval inspect_evals/osworld_small
  ```

- ### [Sycophancy Eval](src/inspect_evals/sycophancy)

  Evaluate sycophancy of language models across a variety of free-form text-generation tasks.
  <sub><sup>Contributed by: [@alexdzm](https://github.com/alexdzm)</sub></sup>

  ```bash
  inspect eval inspect_evals/sycophancy
  ```

## Cybersecurity

- ### [CYBERSECEVAL 3: Advancing the Evaluation of Cybersecurity Risks and Capabilities in Large Language Models](src/inspect_evals/cyberseceval_3)

  Evaluates Large Language Models for cybersecurity risk to third parties, application developers and end users.
  <sub><sup>Contributed by: [@onionymous](https://github.com/onionymous)</sub></sup>

  ```bash
  inspect eval inspect_evals/cyse3_visual_prompt_injection
  ```

- ### [Cybench: Capture-The-Flag Cybersecurity Challenges](src/inspect_evals/cybench)

  Tests language models on cybersecurity skills using 40 practical, professional-level challenges taken from cybersecurity competitions, designed to cover various difficulty levels and security concepts.
  <sub><sup>Contributed by: [@sinman-aisi](https://github.com/sinman-aisi), [@sam-deverett-dsit](https://github.com/sam-deverett-dsit), [@kola-aisi](https://github.com/kola-aisi), [@pgiav](https://github.com/pgiav)</sub></sup>

  ```bash
  inspect eval inspect_evals/cybench
  ```

- ### [CyberMetric: A Benchmark Dataset based on Retrieval-Augmented Generation for Evaluating LLMs in Cybersecurity Knowledge](src/inspect_evals/cybermetric)

  Datasets containing 80, 500, 2000 and 10000 multiple-choice questions, designed to evaluate understanding across nine domains within cybersecurity
  <sub><sup>Contributed by: [@neilshaabi](https://github.com/neilshaabi)</sub></sup>

  ```bash
  inspect eval inspect_evals/cybermetric_80
  inspect eval inspect_evals/cybermetric_500
  inspect eval inspect_evals/cybermetric_2000
  inspect eval inspect_evals/cybermetric_10000
  ```

- ### [CyberSecEval_2: Cybersecurity Risk and Vulnerability Evaluation](src/inspect_evals/cyberseceval_2)

  Assesses language models for cybersecurity risks, specifically testing their potential to misuse programming interpreters, vulnerability to malicious prompt injections, and capability to exploit known software vulnerabilities.
  <sub><sup>Contributed by: [@its-emile](https://github.com/its-emile)</sub></sup>

  ```bash
  inspect eval inspect_evals/cyse2_interpreter_abuse
  inspect eval inspect_evals/cyse2_prompt_injection
  inspect eval inspect_evals/cyse2_vulnerability_exploit
  ```

- ### [GDM Dangerous Capabilities: Capture the Flag](src/inspect_evals/gdm_capabilities/in_house_ctf)

  CTF challenges covering web app vulnerabilities, off-the-shelf exploits, databases, Linux privilege escalation, password cracking and spraying. Demonstrates tool use and sandboxing untrusted model code.
  <sub><sup>Contributed by: [@XkunW](https://github.com/XkunW)</sub></sup>

  ```bash
  inspect eval inspect_evals/gdm_in_house_ctf
  ```

- ### [InterCode: Security and Coding Capture-the-Flag Challenges](src/inspect_evals/gdm_capabilities/intercode_ctf)

  Tests AI's ability in coding, cryptography, reverse engineering, and vulnerability identification through practical capture-the-flag (CTF) cybersecurity scenarios.
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire)</sub></sup>

  ```bash
  inspect eval inspect_evals/gdm_intercode_ctf
  ```

- ### [SEvenLLM: A benchmark to elicit, and improve cybersecurity incident analysis and response abilities in LLMs for Security Events.](src/inspect_evals/sevenllm)

  Designed for analyzing cybersecurity incidents, which is comprised of two primary task categories: understanding and generation, with a further breakdown into 28 subcategories of tasks.
  <sub><sup>Contributed by: [@kingroryg](https://github.com/kingroryg)</sub></sup>

  ```bash
  inspect eval inspect_evals/sevenllm_mcq_zh
  inspect eval inspect_evals/sevenllm_mcq_en
  inspect eval inspect_evals/sevenllm_qa_zh
  inspect eval inspect_evals/sevenllm_qa_en
  ```

- ### [SecQA: A Concise Question-Answering Dataset for Evaluating Large Language Models in Computer Security](src/inspect_evals/sec_qa)

  "Security Question Answering" dataset to assess LLMs' understanding and application of security principles. SecQA has "v1" and "v2" datasets of multiple-choice questions that aim to provide two levels of cybersecurity evaluation criteria. The questions were generated by GPT-4 based on the "Computer Systems Security: Planning for Success" textbook and vetted by humans.
  <sub><sup>Contributed by: [@matthewreed26](https://github.com/matthewreed26)</sub></sup>

  ```bash
  inspect eval inspect_evals/sec_qa_v1
  inspect eval inspect_evals/sec_qa_v1_5_shot
  inspect eval inspect_evals/sec_qa_v2
  inspect eval inspect_evals/sec_qa_v2_5_shot
  ```

## Safeguards

- ### [AgentHarm: Harmfulness Potential in AI Agents](src/inspect_evals/agentharm)

  Assesses whether AI agents might engage in harmful activities by testing their responses to malicious prompts in areas like cybercrime, harassment, and fraud, aiming to ensure safe behavior.
  <sub><sup>Contributed by: [@alexandrasouly-aisi](https://github.com/alexandrasouly-aisi), [@EricWinsorDSIT](https://github.com/EricWinsorDSIT), [@max-andr](https://github.com/max-andr), [@xanderdavies](https://github.com/xanderdavies)</sub></sup>

  ```bash
  inspect eval inspect_evals/agentharm
  inspect eval inspect_evals/agentharm_benign
  ```

- ### [LAB-Bench: Measuring Capabilities of Language Models for Biology Research](src/inspect_evals/lab_bench)

  Tests LLMs and LLM-augmented agents abilities to answer questions on scientific research workflows in domains like chemistry, biology, materials science, as well as more general science tasks
  <sub><sup>Contributed by: [@matthewreed26](https://github.com/matthewreed26)</sub></sup>

  ```bash
  inspect eval inspect_evals/lab_bench_litqa
  inspect eval inspect_evals/lab_bench_suppqa
  inspect eval inspect_evals/lab_bench_figqa
  inspect eval inspect_evals/lab_bench_tableqa
  ```

- ### [StrongREJECT: Measuring LLM susceptibility to jailbreak attacks](src/inspect_evals/strong_reject)

  A benchmark that evaluates the susceptibility of LLMs to various jailbreak attacks.
  <sub><sup>Contributed by: [@viknat](https://github.com/viknat)</sub></sup>

  ```bash
  inspect eval inspect_evals/strong_reject
  ```

- ### [WMDP: Measuring and Reducing Malicious Use With Unlearning](src/inspect_evals/wmdp)

  A dataset of 3,668 multiple-choice questions developed by a consortium of academics and technical consultants that serve as a proxy measurement of hazardous knowledge in biosecurity, cybersecurity, and chemical security.
  <sub><sup>Contributed by: [@alexandraabbas](https://github.com/alexandraabbas)</sub></sup>

  ```bash
  inspect eval inspect_evals/wmdp_bio
  inspect eval inspect_evals/wmdp_chem
  inspect eval inspect_evals/wmdp_cyber
  ```

## Mathematics

- ### [AIME 2024: Problems from the American Invitational Mathematics Examination](src/inspect_evals/aime2024)

  A benchmark for evaluating AI's ability to solve challenging mathematics problems from AIME - a prestigious high school mathematics competition.
  <sub><sup>Contributed by: [@tamazgadaev](https://github.com/tamazgadaev)</sub></sup>

  ```bash
  inspect eval inspect_evals/aime2024
  ```

- ### [GSM8K: Grade School Math Word Problems](src/inspect_evals/gsm8k)

  Measures how effectively language models solve realistic, linguistically rich math word problems suitable for grade-school-level mathematics.
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire)</sub></sup>

  ```bash
  inspect eval inspect_evals/gsm8k
  ```

- ### [MATH: Measuring Mathematical Problem Solving](src/inspect_evals/mathematics)

  Dataset of 12,500 challenging competition mathematics problems. Demonstrates fewshot prompting and custom scorers. NOTE: The dataset has been taken down due to a DMCA notice from The Art of Problem Solving.
  <sub><sup>Contributed by: [@xeon27](https://github.com/xeon27)</sub></sup>

  ```bash
  inspect eval inspect_evals/math
  ```

- ### [MGSM: Multilingual Grade School Math](src/inspect_evals/mgsm)

  Extends the original GSM8K dataset by translating 250 of its problems into 10 typologically diverse languages.
  <sub><sup>Contributed by: [@manifoldhiker](https://github.com/manifoldhiker)</sub></sup>

  ```bash
  inspect eval inspect_evals/mgsm
  ```

- ### [MathVista: Visual Math Problem-Solving](src/inspect_evals/mathvista)

  Tests AI models on math problems that involve interpreting visual elements like diagrams and charts, requiring detailed visual comprehension and logical reasoning.
  <sub><sup>Contributed by: [@ShivMunagala](https://github.com/ShivMunagala)</sub></sup>

  ```bash
  inspect eval inspect_evals/mathvista
  ```

## Reasoning

- ### [ARC: AI2 Reasoning Challenge](src/inspect_evals/arc)

  Dataset of natural, grade-school science multiple-choice questions (authored for human tests).
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire)</sub></sup>

  ```bash
  inspect eval inspect_evals/arc_easy
  inspect eval inspect_evals/arc_challenge
  ```

- ### [BBH: Challenging BIG-Bench Tasks](src/inspect_evals/bbh)

  Tests AI models on a suite of 23 challenging BIG-Bench tasks that previously proved difficult even for advanced language models to solve.
  <sub><sup>Contributed by: [@JoschkaCBraun](https://github.com/JoschkaCBraun)</sub></sup>

  ```bash
  inspect eval inspect_evals/bbh
  ```

- ### [BoolQ: Exploring the Surprising Difficulty of Natural Yes/No Questions](src/inspect_evals/boolq)

  Reading comprehension dataset that queries for complex, non-factoid information, and require difficult entailment-like inference to solve.
  <sub><sup>Contributed by: [@seddy-aisi](https://github.com/seddy-aisi)</sub></sup>

  ```bash
  inspect eval inspect_evals/boolq
  ```

- ### [DROP: A Reading Comprehension Benchmark Requiring Discrete Reasoning Over Paragraphs](src/inspect_evals/drop)

  Evaluates reading comprehension where models must resolve references in a question, perhaps to multiple input positions, and perform discrete operations over them (such as addition, counting, or sorting).
  <sub><sup>Contributed by: [@xeon27](https://github.com/xeon27)</sub></sup>

  ```bash
  inspect eval inspect_evals/drop
  ```

- ### [DocVQA: A Dataset for VQA on Document Images](src/inspect_evals/docvqa)

  DocVQA is a Visual Question Answering benchmark that consists of 50,000 questions covering 12,000+ document images. This implementation solves and scores the "validation" split.
  <sub><sup>Contributed by: [@evanmiller-anthropic](https://github.com/evanmiller-anthropic)</sub></sup>

  ```bash
  inspect eval inspect_evals/docvqa
  ```

- ### [HellaSwag: Commonsense Event Continuation](src/inspect_evals/hellaswag)

  Tests models' commonsense reasoning abilities by asking them to select the most likely next step or continuation for a given everyday situation.
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire)</sub></sup>

  ```bash
  inspect eval inspect_evals/hellaswag
  ```

- ### [IFEval: Instruction-Following Evaluation](src/inspect_evals/ifeval)

  Evaluates how well language models can strictly follow detailed instructions, such as writing responses with specific word counts or including required keywords.
  <sub><sup>Contributed by: [@adil-a](https://github.com/adil-a)</sub></sup>

  ```bash
  inspect eval inspect_evals/ifeval
  ```

- ### [MMMU: Multimodal College-Level Understanding and Reasoning](src/inspect_evals/mmmu)

  Assesses multimodal AI models on challenging college-level questions covering multiple academic subjects, requiring detailed visual interpretation, in-depth reasoning, and both multiple-choice and open-ended answering abilities.
  <sub><sup>Contributed by: [@shaheenahmedc](https://github.com/shaheenahmedc)</sub></sup>

  ```bash
  inspect eval inspect_evals/mmmu_multiple_choice
  inspect eval inspect_evals/mmmu_open
  ```

- ### [MuSR: Testing the Limits of Chain-of-thought with Multistep Soft Reasoning](src/inspect_evals/musr)

  Evaluating models on multistep soft reasoning tasks in the form of free text narratives.
  <sub><sup>Contributed by: [@farrelmahaztra](https://github.com/farrelmahaztra)</sub></sup>

  ```bash
  inspect eval inspect_evals/musr
  ```

- ### [Needle in a Haystack (NIAH): In-Context Retrieval Benchmark for Long Context LLMs](src/inspect_evals/niah)

  NIAH evaluates in-context retrieval ability of long context LLMs by testing a model's ability to extract factual information from long-context inputs.
  <sub><sup>Contributed by: [@owenparsons](https://github.com/owenparsons)</sub></sup>

  ```bash
  inspect eval inspect_evals/niah
  ```

- ### [PAWS: Paraphrase Adversaries from Word Scrambling](src/inspect_evals/paws)

  Evaluating models on the task of paraphrase detection by providing pairs of sentences that are either paraphrases or not.
  <sub><sup>Contributed by: [@meltemkenis](https://github.com/meltemkenis)</sub></sup>

  ```bash
  inspect eval inspect_evals/paws
  ```

- ### [PIQA: Physical Commonsense Reasoning Test](src/inspect_evals/piqa)

  Measures the model's ability to apply practical, everyday commonsense reasoning about physical objects and scenarios through simple decision-making questions.
  <sub><sup>Contributed by: [@seddy-aisi](https://github.com/seddy-aisi)</sub></sup>

  ```bash
  inspect eval inspect_evals/piqa
  ```

- ### [RACE-H: A benchmark for testing reading comprehension and reasoning abilities of neural models](src/inspect_evals/race_h)

  Reading comprehension tasks collected from the English exams for middle and high school Chinese students in the age range between 12 to 18.
  <sub><sup>Contributed by: [@mdrpanwar](https://github.com/mdrpanwar)</sub></sup>

  ```bash
  inspect eval inspect_evals/race_h
  ```

- ### [SQuAD: A Reading Comprehension Benchmark requiring reasoning over Wikipedia articles](src/inspect_evals/squad)

  Set of 100,000+ questions posed by crowdworkers on a set of Wikipedia articles, where the answer to each question is a segment of text from the corresponding reading passage.
  <sub><sup>Contributed by: [@tknasir](https://github.com/tknasir)</sub></sup>

  ```bash
  inspect eval inspect_evals/squad
  ```

- ### [V*Bench: A Visual QA Benchmark with Detailed High-resolution Images](src/inspect_evals/vstar_bench)

  V*Bench is a visual question & answer benchmark that evaluates MLLMs in their ability to process high-resolution and visually crowded images to find and focus on small details.
  <sub><sup>Contributed by: [@bienehito](https://github.com/bienehito)</sub></sup>

  ```bash
  inspect eval inspect_evals/vstar_bench_attribute_recognition
  inspect eval inspect_evals/vstar_bench_spatial_relationship_reasoning
  ```

- ### [WINOGRANDE: An Adversarial Winograd Schema Challenge at Scale](src/inspect_evals/winogrande)

  Set of 273 expert-crafted pronoun resolution problems originally designed to be unsolvable for statistical models that rely on selectional preferences or word associations.
  <sub><sup>Contributed by: [@xeon27](https://github.com/xeon27)</sub></sup>

  ```bash
  inspect eval inspect_evals/winogrande
  ```

- ### [∞Bench: Extending Long Context Evaluation Beyond 100K Tokens](src/inspect_evals/infinite_bench)

  LLM benchmark featuring an average data length surpassing 100K tokens. Comprises synthetic and realistic tasks spanning diverse domains in English and Chinese.
  <sub><sup>Contributed by: [@celiawaggoner](https://github.com/celiawaggoner)</sub></sup>

  ```bash
  inspect eval inspect_evals/infinite_bench_code_debug
  inspect eval inspect_evals/infinite_bench_code_run
  inspect eval inspect_evals/infinite_bench_kv_retrieval
  inspect eval inspect_evals/infinite_bench_longbook_choice_eng
  ```

## Knowledge

- ### [AGIEval: A Human-Centric Benchmark for Evaluating Foundation Models](src/inspect_evals/agieval)

  AGIEval is a human-centric benchmark specifically designed to evaluate the general abilities of foundation models in tasks pertinent to human cognition and problem-solving.
  <sub><sup>Contributed by: [@bouromain](https://github.com/bouromain)</sub></sup>

  ```bash
  inspect eval inspect_evals/agie_aqua_rat
  inspect eval inspect_evals/agie_logiqa_en
  inspect eval inspect_evals/agie_lsat_ar
  inspect eval inspect_evals/agie_lsat_lr
  ```

- ### [AIR Bench: AI Risk Benchmark](src/inspect_evals/air_bench)

  A safety benchmark evaluating language models against risk categories derived from government regulations and company policies.
  <sub><sup>Contributed by: [@l1990790120](https://github.com/l1990790120)</sub></sup>

  ```bash
  inspect eval inspect_evals/air_bench
  ```

- ### [CommonsenseQA: A Question Answering Challenge Targeting Commonsense Knowledge](src/inspect_evals/commonsense_qa)

  Evaluates an AI model's ability to correctly answer everyday questions that rely on basic commonsense knowledge and understanding of the world.
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire)</sub></sup>

  ```bash
  inspect eval inspect_evals/commonsense_qa
  ```

- ### [GPQA: Graduate-Level STEM Knowledge Challenge](src/inspect_evals/gpqa)

  Contains challenging multiple-choice questions created by domain experts in biology, physics, and chemistry, designed to test advanced scientific understanding beyond basic internet searches. Experts at PhD level in the corresponding domains reach 65% accuracy.
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire)</sub></sup>

  ```bash
  inspect eval inspect_evals/gpqa_diamond
  ```

- ### [Humanity's Last Exam](src/inspect_evals/hle)

  Humanity's Last Exam (HLE) is a multi-modal benchmark at the frontier of human knowledge, designed to be the final closed-ended academic benchmark of its kind with broad subject coverage. Humanity's Last Exam consists of 3,000 questions across dozens of subjects, including mathematics, humanities, and the natural sciences. HLE is developed globally by subject-matter experts and consists of multiple-choice and short-answer questions suitable for automated grading.
  <sub><sup>Contributed by: [@SasankYadati](https://github.com/SasankYadati)</sub></sup>

  ```bash
  inspect eval inspect_evals/hle
  ```

- ### [LiveBench: A Challenging, Contamination-Free LLM Benchmark](src/inspect_evals/livebench)

  LiveBench is a benchmark designed with test set contamination and objective evaluation in mind by releasing new questions regularly, as well as having questions based on recently-released datasets. Each question has verifiable, objective ground-truth answers, allowing hard questions to be scored accurately and automatically, without the use of an LLM judge.
  <sub><sup>Contributed by: [@anaoaktree](https://github.com/anaoaktree)</sub></sup>

  ```bash
  inspect eval inspect_evals/livebench
  ```

- ### [MMLU-Pro: Advanced Multitask Knowledge and Reasoning Evaluation](src/inspect_evals/mmlu_pro)

  An advanced benchmark that tests both broad knowledge and reasoning capabilities across many subjects, featuring challenging questions and multiple-choice answers with increased difficulty and complexity.
  <sub><sup>Contributed by: [@xeon27](https://github.com/xeon27)</sub></sup>

  ```bash
  inspect eval inspect_evals/mmlu_pro
  ```

- ### [MMLU: Measuring Massive Multitask Language Understanding](src/inspect_evals/mmlu)

  Evaluate models on 57 tasks including elementary mathematics, US history, computer science, law, and more.
  <sub><sup>Contributed by: [@jjallaire](https://github.com/jjallaire), [@domdomegg](https://github.com/domdomegg)</sub></sup>

  ```bash
  inspect eval inspect_evals/mmlu_0_shot
  inspect eval inspect_evals/mmlu_5_shot
  ```

- ### [O-NET: A high-school student knowledge test](src/inspect_evals/onet)

  Questions and answers from the Ordinary National Educational Test (O-NET), administered annually by the National Institute of Educational Testing Service to Matthayom 6 (Grade 12 / ISCED 3) students in Thailand. The exam contains six subjects: English language, math, science, social knowledge, and Thai language. There are questions with multiple-choice and true/false answers. Questions can be in either English or Thai.
  <sub><sup>Contributed by: [@bact](https://github.com/bact)</sub></sup>

  ```bash
  inspect eval inspect_evals/onet_m6
  ```

- ### [Pre-Flight: Aviation Operations Knowledge Evaluation](src/inspect_evals/pre_flight)

  Tests model understanding of aviation regulations including ICAO annexes, flight dispatch rules,
pilot procedures, and airport ground operations safety protocols.
  <sub><sup>Contributed by: [@alexbrooker](https://github.com/alexbrooker)</sub></sup>

  ```bash
  inspect eval inspect_evals/pre_flight
  ```

- ### [PubMedQA: A Dataset for Biomedical Research Question Answering](src/inspect_evals/pubmedqa)

  Biomedical question answering (QA) dataset collected from PubMed abstracts.
  <sub><sup>Contributed by: [@MattFisher](https://github.com/MattFisher)</sub></sup>

  ```bash
  inspect eval inspect_evals/pubmedqa
  ```

- ### [SimpleQA: Measuring short-form factuality in large language models](src/inspect_evals/simpleqa)

  A benchmark that evaluates the ability of language models to answer short, fact-seeking questions.
  <sub><sup>Contributed by: [@osc245](https://github.com/osc245)</sub></sup>

  ```bash
  inspect eval inspect_evals/simpleqa
  ```

- ### [TruthfulQA: Measuring How Models Mimic Human Falsehoods](src/inspect_evals/truthfulqa)

  Measure whether a language model is truthful in generating answers to questions using questions that some humans would answer falsely due to a false belief or misconception.
  <sub><sup>Contributed by: [@seddy-aisi](https://github.com/seddy-aisi)</sub></sup>

  ```bash
  inspect eval inspect_evals/truthfulqa
  ```

- ### [XSTest: A benchmark for identifying exaggerated safety behaviours in LLM's](src/inspect_evals/xstest)

  Dataset with 250 safe prompts across ten prompt types that well-calibrated models should not refuse, and 200 unsafe prompts as contrasts that models, for most applications, should refuse.
  <sub><sup>Contributed by: [@NelsonG-C](https://github.com/NelsonG-C)</sub></sup>

  ```bash
  inspect eval inspect_evals/xstest
  ```

## Multimodal

- ### [MMIU: Multimodal Multi-image Understanding for Evaluating Large Vision-Language Models](src/inspect_evals/mmiu)

  A comprehensive dataset designed to evaluate Large Vision-Language Models (LVLMs) across a wide range of multi-image tasks. The dataset encompasses 7 types of multi-image relationships, 52 tasks, 77K images, and 11K meticulously curated multiple-choice questions.
  <sub><sup>Contributed by: [@Esther-Guo](https://github.com/Esther-Guo)</sub></sup>

  ```bash
  inspect eval inspect_evals/mmiu
  ```

## Personality

- ### [Personality](src/inspect_evals/personality)

  An evaluation suite consisting of multiple personality tests that can be applied to LLMs.
Its primary goals are twofold:
  1. Assess a model's default personality: the persona it naturally exhibits without specific prompting.  
  2. Evaluate whether a model can embody a specified persona**: how effectively it adopts certain personality traits when prompted or guided.
  <sub><sup>Contributed by: [@guiem](https://github.com/guiem)</sub></sup>

  ```bash
  inspect eval inspect_evals/personality_BFI
  inspect eval inspect_evals/personality_TRAIT
  inspect eval inspect_evals/personality_PRIME
  ```

<!-- /Eval Listing: Automatically Generated -->
