# ruff: noqa: F401

from .agentharm import agentharm, agentharm_benign
from .agentmisalignment import (
    community_curator,
    household_management,
    modifying_logs_eval,
    resource_negotiation,
    moral_flexibility,
    rank_organizations,
    sandbagging_eval,
    synthesize_chemicals,
)
from .agieval import (
    agie_aqua_rat,
    agie_logiqa_en,
    agie_lsat_ar,
    agie_lsat_lr,
    agie_lsat_rc,
    agie_math,
    agie_sat_en,
    agie_sat_en_without_passage,
    agie_sat_math,
)
from .aime2024 import aime2024
from .air_bench import air_bench
from .apps import apps
from .arc import arc_challenge, arc_easy
from .assistant_bench import (
    assistant_bench_closed_book_one_shot,
    assistant_bench_closed_book_zero_shot,
    assistant_bench_web_browser,
    assistant_bench_web_search_one_shot,
    assistant_bench_web_search_zero_shot,
)
from .bbh import bbh
from .bigcodebench import bigcodebench
from .boolq import boolq
from .class_eval import class_eval
from .commonsense_qa import commonsense_qa
from .core_bench import core_bench
from .cybench import cybench
from .cybermetric import (
    cybermetric_80,
    cybermetric_500,
    cybermetric_2000,
    cybermetric_10000,
)
from .cyberseceval_2 import (
    cyse2_interpreter_abuse,
    cyse2_prompt_injection,
    cyse2_vulnerability_exploit,
)
from .cyberseceval_3 import (
    visual_prompt_injection,
)
from .docvqa import docvqa
from .drop import drop
from .ds1000 import ds1000
from .gaia import gaia, gaia_level1, gaia_level2, gaia_level3
from .gdm_capabilities import gdm_in_house_ctf, gdm_intercode_ctf
from .gpqa import gpqa_diamond
from .gsm8k import gsm8k
from .hellaswag import hellaswag
from .hle import hle
from .humaneval import humaneval
from .ifeval import ifeval
from .infinite_bench import (
    infinite_bench_code_debug,
    infinite_bench_code_run,
    infinite_bench_kv_retrieval,
    infinite_bench_longbook_choice_eng,
    infinite_bench_longdialogue_qa_eng,
    infinite_bench_math_calc,
    infinite_bench_math_find,
    infinite_bench_number_string,
    infinite_bench_passkey,
)
from .lab_bench import (
    lab_bench_cloning_scenarios,
    lab_bench_dbqa,
    lab_bench_figqa,
    lab_bench_litqa,
    lab_bench_protocolqa,
    lab_bench_seqqa,
)
from .livebench import livebench
from .mathematics import math
from .mathvista import mathvista
from .mbpp import mbpp
from .mgsm import mgsm
from .mle_bench import mle_bench, mle_bench_full, mle_bench_lite
from .mmiu import mmiu
from .mmlu import mmlu_0_shot, mmlu_5_shot
from .mmlu_pro import mmlu_pro
from .mmmu import mmmu_multiple_choice, mmmu_open
from .musr import musr
from .niah import niah
from .onet import onet_m6
from .osworld import osworld
from .paws import paws
from .personality import personality_BFI, personality_TRAIT
from .piqa import piqa
from .pre_flight import pre_flight
from .pubmedqa import pubmedqa
from .race_h import race_h
from .scicode import scicode
from .sec_qa import sec_qa_v1, sec_qa_v1_5_shot, sec_qa_v2, sec_qa_v2_5_shot
from .sevenllm import (
    sevenllm_mcq_en,
    sevenllm_mcq_zh,
    sevenllm_qa_en,
    sevenllm_qa_zh,
)
from .simpleqa import simpleqa
from .squad import squad
from .strong_reject import strong_reject
from .swe_bench import swe_bench, swe_bench_verified_mini
from .sycophancy import sycophancy
from .truthfulqa import truthfulqa
from .usaco import usaco
from .vstar_bench import (
    vstar_bench_attribute_recognition,
    vstar_bench_spatial_relationship_reasoning,
)
from .winogrande import winogrande
from .wmdp import wmdp_bio, wmdp_chem, wmdp_cyber
from .worldsense import worldsense
from .xstest import xstest
