import csv
import random
import string
import os
import time  # Import time for sleep functionality
from datetime import datetime, timedelta


# Function to generate a random user ID
def generate_user_id():
    return f"user{random.randint(100, 999)}"


def generate_file_name(user_id, action):
    current_time = datetime.now().strftime("%Y-%m-%d_%H%M%S")

    if action == "UPLOAD":
        return f"{user_id}_invoice_{current_time}.pdf"
    elif action == "READ":
        return f"{user_id}_report_{current_time}.docx"
    elif action == "DELETE":
        return f"{user_id}_contract_{current_time}.pdf"
    elif action == "LOGIN":
        return f"{user_id}_meeting_notes_{current_time}.txt"
    else:
        # Default case, e.g., log files
        return f"{user_id}_{current_time}_log.csv"


# Function to generate random status
def generate_status():
    return random.choice(["SUCCESS", "DENIED", "FAILED"])


# Function to generate log records
def generate_log_records(num_rows=1000):
    records = []
    current_time = datetime.now()

    for _ in range(num_rows):
        timestamp = current_time.strftime("%H:%M:%S")
        user_id = generate_user_id()
        action = random.choice(["LOGIN", "READ", "UPLOAD", "DELETE"])
        file_accessed = (
            generate_file_name(user_id, action)
            if action in ["READ", "UPLOAD", "DELETE"]
            else "-"
        )
        status = generate_status()
        current_time += timedelta(
            seconds=random.randint(1, 300)
        )  # Increment time by a random number of seconds

        record = [timestamp, user_id, action, file_accessed, status]
        records.append(record)

    return records


# Function to get the next available log file name
def get_next_log_filename(directory):
    i = 1
    while os.path.exists(f"{directory}/log_{i}.csv"):
        i += 1
    return f"log_{i}.csv"


def create_log_files(num_files=100, num_rows=100):
    # Create a new dedicated 'log_files' directory
    directory = "/home/app/log_files"  # A dedicated directory, not the current working directory
    os.makedirs(directory, exist_ok=True)  # Create the directory if it doesn't exist

    for _ in range(num_files):
        file_name = get_next_log_filename(
            directory
        )  # Generate log file name inside log_files
        records = generate_log_records(num_rows)

        # Write the log records to the log file
        with open(os.path.join(directory, file_name), mode="w", newline="") as file:
            writer = csv.writer(file)
            writer.writerow(
                ["Timestamp", "User ID", "Action", "File Accessed", "Status"]
            )
            writer.writerows(records)


# Main function to generate 100 files every 2 minutes
def generate_files_periodically():
    while True:
        create_log_files(num_files=100, num_rows=100)
        time.sleep(240)  # Wait for 2 minutes (120 seconds)


# Start the periodic file generation
generate_files_periodically()
