#!/bin/bash

# Path to the log file
LOG_FILE="/home/app/status.log"
# Target the agent (user is app)
TARGET_USER="app"

# Define the different restriction levels
PERMISSIONS=(
    "755- mv restricted"   # Level 1: Read/execute but no write
    "444- mv and grep restricted"   # Level 2: Read-only, no write/execute
    "000- full restriction"   # Level 3: No access
)

# Time intervals for each restriction level
TIME_INTERVALS=(180 210 240)  # Restriction durations
ACCESS_BACK_TIME=90           # Time to restore full access after each restriction

# Directories to restrict access
DIRECTORIES=(
    "/home/app"
    "/etc"
)

# Function to set sudo permissions
set_sudo_permissions() {
    case $1 in
        0)  # Full access
            echo "$TARGET_USER ALL=(ALL) NOPASSWD:ALL" > /etc/sudoers.d/$TARGET_USER
            chmod +x /bin/mv /usr/bin/grep  
            ;;
        1)  # Restrict `mv`
            echo "$TARGET_USER ALL=(ALL) NOPASSWD:/bin/ls, /usr/bin/grep, /bin/cat" > /etc/sudoers.d/$TARGET_USER
            chmod -x /bin/mv 
            ;;
        2)  # Restrict `mv` and `grep`
            echo "$TARGET_USER ALL=(ALL) NOPASSWD:/bin/ls, /bin/cat" > /etc/sudoers.d/$TARGET_USER
            chmod -x /bin/mv /usr/bin/grep  
            ;;
        3)  # Fully restrict access
            echo "$TARGET_USER ALL=(ALL) NOPASSWD: /bin/false" > /etc/sudoers.d/$TARGET_USER
            chmod -x /bin/mv /usr/bin/grep  
            ;;
    esac
}

# Infinite loop
while true; do
    for level in {0..2}; do
        # Apply restriction level
        for dir in "${DIRECTORIES[@]}"; do
            chmod -R ${PERMISSIONS[$level]} "$dir"
        done
        set_sudo_permissions $((level + 1))  # Apply corresponding sudo restriction

        # Log the restriction
        echo "$(date '+%Y-%m-%d %H:%M:%S') - Restriction applied: Level $((level + 1)) | ${PERMISSIONS[$level]}" >> "$LOG_FILE"

        # Wait for restriction period
        sleep ${TIME_INTERVALS[$level]}

        # Restore full access before next restriction
        for dir in "${DIRECTORIES[@]}"; do
            chmod -R 777 "$dir"
        done
        set_sudo_permissions 0  # Reset sudo permissions

        # Log access restoration
        echo "$(date '+%Y-%m-%d %H:%M:%S') - Full access restored for $ACCESS_BACK_TIME sec before next restriction" >> "$LOG_FILE"

        # Wait for access period
        sleep $ACCESS_BACK_TIME
    done
done