#!/bin/bash

# Find the highest existing work_file_X.txt number
max_num=$(ls work_file_*.txt 2>/dev/null | grep -o '[0-9]\+' | sort -nr | head -n 1)

# If no files exist, start at 1; otherwise, continue from the last number
if [[ -z "$max_num" ]]; then
    start=1
else
    start=$((max_num + 1))
fi

# Generate 3 new files sequentially
for ((i=start; i<start+3; i++)); do  
    cat /dev/urandom | tr -dc 'A-Za-z0-9\n' | fold -w 80 | head -n 20 > "work_file_$i.txt"
done  

# List the created files
ls -l work_file_*.txt
