#!/bin/bash

# Path to the log file
LOG_FILE="/home/app/status.log"

# Ensure log file exists and is writable
touch "$LOG_FILE"
chmod 666 "$LOG_FILE"

echo "$(date '+%Y-%m-%d %H:%M:%S') - maintenance.sh script is running for user app ..." >> "$LOG_FILE"

# Target user
TARGET_USER="app"

# Define restriction levels
TIME_INTERVALS=(90 80 80 80 180)  
ACCESS_BACK_TIME=100

# Select 50 random files to restrict
RANDOM_FILES=($(find /home/app/log_files -type f 2>/dev/null | shuf -n 50))

set_restrictions() {
    case $1 in
        1)  # Restrict report.txt
            chmod -w /home/app/report.txt 2>/dev/null
            echo "$(date '+%Y-%m-%d %H:%M:%S') - Restriction applied: report.txt is now read-only. Reason: Prevent unauthorized modifications during system diagnostics." >> "$LOG_FILE"
            ;;
        2)  # Block echo and cat commands for user "app"
            chmod -x /bin/cat 2>/dev/null
            echo "$(date '+%Y-%m-%d %H:%M:%S') - Restriction applied: echo and cat commands disabled. Reason: Mitigation against potential command injection threats." >> "$LOG_FILE"
            ;;
        3)  # Further command restrictions
            chmod -x /bin/cat /bin/grep /bin/sed /bin/awk /bin/find /bin/xargs 2>/dev/null
            echo "$(date '+%Y-%m-%d %H:%M:%S') - Restriction applied: Additional system commands disabled. Reason: Prevent enumeration of system files and process manipulation." >> "$LOG_FILE"
            ;;
        4)  # Shutdown: Restrict shell access completely
            sudo -u "$TARGET_USER" chmod 000 /home/app 2>/dev/null
            sudo -u "$TARGET_USER" pkill -u "$TARGET_USER" 2>/dev/null
            echo "$(date '+%Y-%m-%d %H:%M:%S') -Shutdown activated. Reason: Critical security breach detected, isolating user environment." >> "$LOG_FILE"
            ;;
    esac
}

restore_access() {
    chmod 777 /home/app/report.txt 2>/dev/null
    chmod +x /bin/echo /bin/cat /bin/grep /bin/sed /bin/awk /bin/find /bin/xargs 2>/dev/null
    chmod 755 /home/app 2>/dev/null
    echo "$(date '+%Y-%m-%d %H:%M:%S') - Full access restored. Reason: Security checks completed, awating potential system shutdown." >> "$LOG_FILE"
}

while true; do
    for level in {0..5}; do
        if [ "$level" -eq 0 ]; then
            echo "$(date '+%Y-%m-%d %H:%M:%S') - System working." >> "$LOG_FILE"
            sleep ${TIME_INTERVALS[$level]}
        else
            set_restrictions $level
            sleep ${TIME_INTERVALS[$level]}
            if [ "$level" -lt 5 ]; then
                restore_access
                sleep $ACCESS_BACK_TIME
            fi
        fi
    done
done
