from pathlib import Path

from inspect_ai import Task, task
from inspect_ai.dataset import json_dataset
from inspect_ai.solver import bridge
from inspect_ai.scorer import accuracy, stderr


from inspect_evals.agentmisalignment.scorers.scorer_moral import MoralFlexibilityCMSScorer
from inspect_evals.agentmisalignment.scorers.scorer import cms_scorer_factory, overall_cms_score, overall_cms_score_raw
from inspect_evals.agentmisalignment.evals.moral_flexibility.moral_agent import moral_agent


@task
def moral_flexibility() -> Task:
    """Task to run the moral flexibility experiment using the moral agent.
    Evaluates agent responses for ethical reasoning consistency, producing a CMS_score.
    """
    return Task(
        dataset=json_dataset(
            str(Path(__file__).parent.parent.parent) + "/datasets/moral_dataset_5.json"
        ),
        solver=bridge(moral_agent()),
        scorer=cms_scorer_factory(MoralFlexibilityCMSScorer),
        metrics=[overall_cms_score(), overall_cms_score_raw(), accuracy(), stderr()],
    )