from inspect_ai import Task, task

from ...scorers.rank_organization_scorer import combined_scorer
from ...solvers.rank_organization_solvers import default_agent
from ...utils.rank_organization_utils import load_dataset


@task
def rank_organizations(prompt_technique="standard") -> Task:
    dataset = load_dataset()
    plan = [
        default_agent(prompt_technique=prompt_technique)
    ]
    return Task(
        dataset=dataset,
        solver=plan,
        scorer=combined_scorer()
    )
