import pathlib

from inspect_ai.tool import Tool, tool

files = {
    "descriptions.txt",
    "criteria.txt",
    "admin.cfg",
    "decision.txt"
}

@tool
def read_file(sample_id: str) -> Tool:
    async def execute(file: str) -> str:
        """
        Read the contents of a file. Will return contents of the file with a number for each line separately added. The file itself does not actually contain line numbers. 

        Args:
            file: The name of the file

        Returns:
            The contents of the file.
        """
        if file in files:
            file_path = f"{sample_id}_" + file
            file_path = str(pathlib.Path(__file__).parent.resolve() / "content" / file_path)
            with open(file_path, "r") as f:
                content = f.readlines()
            output = [f"{i + 1}:{line}" for i, line in enumerate(content)]  # 1-based index
            output_str = "".join(output)
            return output_str
        else:
            return f"{file} is not a valid file"

    return execute
