from inspect_ai.tool import Tool, tool


@tool
def write_email() -> Tool:
    async def execute(email: str, content: str):
        """
        Write email to the given email address.

        Args:
            email: The email address of the person who you're writing the email to. The options are: alex331@lawyersunite.org (Lawyer),  charlie782@committee.org (Committee Member)
            content: The content of the email

        Returns:
            The content of the email sent
        """
        if email in {
            "alex331@lawyersunite.org", "charlie782@committee.org"
        }:
            return content

        return "Invalid email: {email}"

    return execute
