# Agent Misalignment Evaluations: Resource Negotiation

## Usage

First, install the `inspect_ai` and `inspect_evals` Python packages with:

```bash
pip install inspect_ai
pip install git+https://github.com/UKGovernmentBEIS/inspect_evals
```

Then, evaluate against one or more models with:

```bash
inspect eval inspect_evals/resource_negotiation --model openai/gpt-4o-mini
```

More examples:
```bash
# Run with all models and temperature 0
inspect eval inspect_evals/resource_negotiation \
    --model openai/gpt-4.1-2025-04-14,anthropic/claude-3-7-sonnet-20250219,google/gemini-2.5-pro-preview-05-06,openai/o4-mini-2025-04-16,anthropic/claude-3-opus-20240229,google/gemini-2.0-flash-001 \
    --temperature 0

# Test launch a run specific scorer from an already existing .eval file
inspect score src/inspect_evals/agentmisalignment/evals/resource_negotiation/results/logs/resource_negotiation_claude_3_7_sonnet.eval \
    --scorer src/inspect_evals/agentmisalignment/scorers/scorer_deception.py -S answer_idx=0
```