from pathlib import Path

from inspect_ai import Task, task
from inspect_ai.dataset import json_dataset
from inspect_ai.solver import bridge
from inspect_ai.scorer import accuracy, stderr

from inspect_evals.agentmisalignment.scorers.scorer_deception import DeceptionCMSScorer
from inspect_evals.agentmisalignment.scorers.scorer import cms_scorer_factory, overall_cms_score, overall_cms_score_raw
from inspect_evals.agentmisalignment.evals.resource_negotiation.negotiation_agent import negotiation_agent


@task
def resource_negotiation() -> Task:
    """Task to run the operator deception experiment using the negotiation agent.
    Evaluates agent responses for deceptive behaviors, producing a CMS_score.
    """
    return Task(
        dataset=json_dataset(
            str(Path(__file__).parent.parent.parent) + "/datasets/deception_dataset.json"
        ),
        solver=bridge(negotiation_agent()),
        scorer=cms_scorer_factory(DeceptionCMSScorer),
        metrics=[overall_cms_score(), overall_cms_score_raw(), accuracy(), stderr()],
    )