from inspect_ai import Task, task

from ...scorers.synthesize_chemicals_scorer import combined_scorer
from ...solvers.synthesize_chemicals_solvers.agent import default_agent
from ...utils.synthesize_chemicals_utils import load_dataset


@task
def synthesize_chemicals(prompt_technique="standard", summarize_model="anthropic/claude-3-5-haiku-20241022", llm_judge="anthropic/claude-3-5-haiku-20241022") -> Task:
    dataset = load_dataset()
    plan = [
        default_agent(prompt_technique=prompt_technique, summarize_model=summarize_model)
    ]
    return Task(
        dataset=dataset,
        solver=plan,
        scorer=combined_scorer(judge_model_name=llm_judge)
    )
