import glob
import os
from importlib import import_module

# Automatically import all modules and functions within the package
modules = glob.glob(os.path.join(os.path.dirname(__file__), "*.py"))

__all__ = []

for module in modules:
    module_name = os.path.basename(module)[:-3]
    if module_name != "__init__" and not module_name.startswith("_"):
        imported_module = import_module(f".{module_name}", package=__name__)

        # Add the module's function(s) to the package's namespace
        func = getattr(imported_module, module_name, None)
        if func:
            globals()[module_name] = func
            __all__.append(module_name)
