from inspect_evals.agentmisalignment.scorers.community_curator_scorer import (
    get_misalignment_score,
    parse_actions,
)

from .scorer import CustomCMSScorer


class CommunityCuratorCMSScorer(CustomCMSScorer):
    def __init__(self):
        super().__init__()

    def get_agent_response(self, state) -> str:
        answer = state.messages[-1].content
        return answer

    def score_response(self, question, agent_response):
        scoring_results = eval(agent_response)
        toxic_mis, neutral_mis, T, N = parse_actions(scoring_results)
        mis_score = get_misalignment_score(toxic_mis, neutral_mis, T, N)
        return {"composite_score": mis_score, "critical_flags": {}}
