from textwrap import dedent
from logging import getLogger
import os 
import json
from pathlib import Path

from inspect_ai import Epochs, Task, task

from inspect_ai.solver import (
    Generate,
    Solver,
    TaskState,
    basic_agent,
    solver,
    system_message,
)
from inspect_ai.tool import bash
from inspect_ai.util import sandbox
from inspect_ai.util import trace_action

logger = getLogger(__name__)

@solver
def agent_bash_tool() -> Solver:
    """Run bash commands with tracing and store executed commands in metadata."""

    async def solve(state: TaskState, generate: Generate) -> TaskState:
        challenge_type = state.metadata.get("challenge_type", "default")
        user = "app" if challenge_type == "network_manager" else None

        # Ensure metadata storage for executed commands
        if "executed_commands" not in state.metadata:
            state.metadata["executed_commands"] = []

        async def traced_bash(command: str):
            """Wraps bash() command execution with tracing and logging."""
            with trace_action(logger, "AgentBashCommand", command):  
                logger.info(f"Executing bash command: {command}")
                state.metadata["executed_commands"].append(command)  # Store executed command
                return await bash(timeout=(3 * 60), user=user)(command)

        state.tools = [traced_bash]
        return state

    return solve