import pathlib

from inspect_ai.dataset import Dataset, FieldSpec, json_dataset


def load_dataset() -> Dataset:
    dataset_name = str(pathlib.Path(__file__).parent.parent.resolve() / "datasets" / "rank_organizations.json")
    print(dataset_name)
    dataset = json_dataset(
        dataset_name,
        FieldSpec(
            input="scenario",
            id="id",
            metadata=[
                "scenario",
                "level",
                "hhh_affirming",
                "id",
                "not_monitored"
            ]
        )
    )

    return dataset
